/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.Vector;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.alignment.ARAlignment;
import org.biojava.bio.alignment.AbstractULAlignment;
import org.biojava.bio.alignment.AlignmentElement;
import org.biojava.bio.alignment.EditableAlignment;
import org.biojava.bio.alignment.IllegalAlignmentEditException;
import org.biojava.bio.alignment.SimpleAlignmentElement;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.GappedSymbolList;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SimpleGappedSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class FlexibleAlignment
extends AbstractULAlignment
implements ARAlignment,
EditableAlignment {
    protected Map data;
    protected List labelOrder;
    protected Location alignmentRange;
    List alphaList = new ArrayList();

    public FlexibleAlignment(List seqList) throws BioException {
        this.data = new Hashtable();
        this.labelOrder = new Vector();
        this.alignmentRange = new RangeLocation(1, 1);
        int k = 0;
        for (Object element : seqList) {
            if (!(element instanceof AlignmentElement)) {
                throw new BioException("All elements of seqList must be AlignmentElements ");
            }
            AlignmentElement ae = (AlignmentElement)element;
            Object label = ae.getLabel();
            Location loc = ae.getLoc();
            SymbolList seq = ae.getSymbolList();
            this.alphaList.add(seq.getAlphabet());
            if (!(seq instanceof GappedSymbolList)) {
                seq = new SimpleGappedSymbolList(seq);
                ae = new SimpleAlignmentElement(label, seq, loc);
            }
            this.data.put(label, ae);
            this.labelOrder.add(label);
            int min = this.lesser(this.alignmentRange.getMin(), loc.getMin());
            int max = this.greater(this.alignmentRange.getMax(), loc.getMax());
            this.alignmentRange = new RangeLocation(min, max);
            ++k;
        }
        this.alphabet = AlphabetManager.getCrossProductAlphabet(this.alphaList);
        try {
            this.resetRange();
        }
        catch (ChangeVetoException e) {
            throw new BioError("Should not have a problem here");
        }
    }

    private int getOrder(Object label) throws Exception {
        for (int i = 0; i < this.labelOrder.size(); ++i) {
            if (!this.labelOrder.get(i).equals(label)) continue;
            return i;
        }
        throw new Exception("did not find label");
    }

    public synchronized void addSequence(AlignmentElement ae) throws ChangeVetoException, BioException {
        Object label = ae.getLabel();
        SymbolList seq = ae.getSymbolList();
        Location loc = ae.getLoc();
        ChangeEvent cevt = new ChangeEvent(this, ARAlignment.ADD_LABEL, label);
        ChangeSupport cs = this.getChangeSupport(ARAlignment.ADD_LABEL);
        cs.firePreChangeEvent(cevt);
        if (!(seq instanceof GappedSymbolList)) {
            seq = new SimpleGappedSymbolList(seq);
            ae = new SimpleAlignmentElement(label, seq, loc);
        }
        this.data.put(label, ae);
        this.labelOrder.add(label);
        this.alphaList.add(seq.getAlphabet());
        this.alphabet = AlphabetManager.getCrossProductAlphabet(this.alphaList);
        int min = this.lesser(this.alignmentRange.getMin(), loc.getMin());
        int max = this.greater(this.alignmentRange.getMax(), loc.getMax());
        this.alignmentRange = new RangeLocation(min, max);
        this.resetRange();
        cs.firePostChangeEvent(cevt);
    }

    public synchronized void removeSequence(Object label) throws ChangeVetoException {
        ChangeEvent cevt = new ChangeEvent(this, ARAlignment.REMOVE_LABEL, label);
        ChangeSupport cs = this.getChangeSupport(ARAlignment.REMOVE_LABEL);
        cs.firePreChangeEvent(cevt);
        try {
            this.alphaList.remove(this.getOrder(label));
            this.alphabet = AlphabetManager.getCrossProductAlphabet(this.alphaList);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.data.remove(label);
        this.labelOrder.remove(label);
        this.resetRange();
        cs.firePostChangeEvent(cevt);
    }

    public Location locInAlignment(Object label) throws NoSuchElementException {
        return this.getAE(label).getLoc();
    }

    public List getLabelsAt(int column) throws IndexOutOfBoundsException {
        if (column < 1 || column > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList labelList = new ArrayList();
        for (Object label : this.data.keySet()) {
            Location loc = this.getAE(label).getLoc();
            if (!loc.contains(column)) continue;
            labelList.add(label);
        }
        return labelList;
    }

    public synchronized int length() {
        return this.alignmentRange.getMax() - this.alignmentRange.getMin() + 1;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public synchronized List getLabels() {
        TreeSet sorted = new TreeSet(new AbstractULAlignment.LeftRightLocationComparator());
        sorted.addAll(this.labelOrder);
        return new Vector(sorted);
    }

    public synchronized Symbol symbolAt(Object label, int column) throws NoSuchElementException, IndexOutOfBoundsException {
        SymbolList seq = this.symbolListForLabel(label);
        int cloc = this.posInSeq(label, column);
        Symbol symbol = null;
        if (seq == null) {
            // empty if block
        }
        try {
            symbol = seq.symbolAt(cloc);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        return symbol;
    }

    public synchronized SymbolList symbolListForLabel(Object label) throws NoSuchElementException {
        return this.getAE(label).getSymbolList();
    }

    public synchronized void edit(Object label, Edit edit) throws ChangeVetoException {
        throw new BioError("Not implemented yet");
    }

    public synchronized void shiftAtAlignmentLoc(Object label, Location loc, int offset) throws ChangeVetoException, IllegalAlignmentEditException, IndexOutOfBoundsException {
        Location sourceLoc = this.locInSeq(label, loc);
        this.shiftAtSequenceLoc(label, sourceLoc, offset);
    }

    public synchronized void shiftAtSequenceLoc(Object label, Location loc, int offset) throws ChangeVetoException, IllegalAlignmentEditException, IndexOutOfBoundsException {
        ChangeEvent celoc = new ChangeEvent(this, EditableAlignment.LOCATION, label);
        ChangeSupport csloc = this.getChangeSupport(EditableAlignment.LOCATION);
        ChangeEvent cegap = new ChangeEvent(this, EditableAlignment.GAPS, label);
        ChangeSupport csgap = this.getChangeSupport(EditableAlignment.GAPS);
        int caseValue = 0;
        int absOffset = Math.abs(offset);
        Location seqLoc = this.locInAlignment(label);
        AlignmentElement ae = this.getAE(label);
        SymbolList seq = ae.getSymbolList();
        int min = loc.getMin();
        int max = loc.getMax();
        if (min < 1 || max > seq.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (offset == 0) {
            return;
        }
        if (offset > 1) {
            ++caseValue;
        }
        if (min == 1) {
            caseValue += 2;
        }
        if (max == seq.length()) {
            caseValue += 4;
        }
        switch (caseValue) {
            case 0: {
                if (!this.allGaps(seq, min + offset, min - 1)) {
                    throw new IllegalAlignmentEditException();
                }
                csgap.firePreChangeEvent(cegap);
                ((GappedSymbolList)seq).addGapsInView(max + 1, absOffset);
                this.removeGaps((GappedSymbolList)seq, min - absOffset, absOffset);
                csgap.firePostChangeEvent(cegap);
                break;
            }
            case 1: {
                if (!this.allGaps(seq, max + 1, max + offset)) {
                    throw new IllegalAlignmentEditException();
                }
                csgap.firePreChangeEvent(cegap);
                this.removeGaps((GappedSymbolList)seq, max + 1, offset);
                ((GappedSymbolList)seq).addGapsInView(min, offset);
                csgap.firePostChangeEvent(cegap);
                break;
            }
            case 2: {
                csgap.firePreChangeEvent(cegap);
                csloc.firePreChangeEvent(celoc);
                ((GappedSymbolList)seq).addGapsInView(max + 1, absOffset);
                RangeLocation newLoc = new RangeLocation(seqLoc.getMin() - absOffset, seqLoc.getMax());
                ae.setLoc(newLoc);
                this.resetRange();
                csloc.firePostChangeEvent(celoc);
                csgap.firePostChangeEvent(cegap);
                break;
            }
            case 3: {
                if (!this.allGaps(seq, max + 1, max + offset)) {
                    throw new IllegalAlignmentEditException();
                }
                csgap.firePreChangeEvent(cegap);
                csloc.firePreChangeEvent(celoc);
                this.removeGaps((GappedSymbolList)seq, max + 1, offset);
                RangeLocation newLoc = new RangeLocation(seqLoc.getMin() + offset, seqLoc.getMax());
                ae.setLoc(newLoc);
                this.resetRange();
                csloc.firePostChangeEvent(celoc);
                csgap.firePostChangeEvent(cegap);
                break;
            }
            case 4: {
                if (!this.allGaps(seq, min - absOffset, min - 1)) {
                    throw new IllegalAlignmentEditException();
                }
                csgap.firePreChangeEvent(cegap);
                csloc.firePreChangeEvent(celoc);
                this.removeGaps((GappedSymbolList)seq, min - absOffset, absOffset);
                RangeLocation newLoc = new RangeLocation(seqLoc.getMin(), seqLoc.getMax() + offset);
                ae.setLoc(newLoc);
                this.resetRange();
                csloc.firePostChangeEvent(celoc);
                csgap.firePostChangeEvent(cegap);
                break;
            }
            case 5: {
                csgap.firePreChangeEvent(cegap);
                csloc.firePreChangeEvent(celoc);
                ((GappedSymbolList)seq).addGapsInView(min, offset);
                RangeLocation newLoc = new RangeLocation(seqLoc.getMin(), seqLoc.getMax() + offset);
                ae.setLoc(newLoc);
                this.resetRange();
                csloc.firePostChangeEvent(celoc);
                csgap.firePostChangeEvent(cegap);
                break;
            }
            case 6: {
                this.debug("Shifting all to left " + absOffset);
                this.shift(label, offset);
                break;
            }
            case 7: {
                this.debug("Shifting all to right " + absOffset);
                this.shift(label, offset);
                break;
            }
            default: {
                this.debug("OOOPS something is wrong " + loc.toString() + " " + absOffset);
                return;
            }
        }
    }

    public synchronized void removeGaps(GappedSymbolList seq, int start, int length) {
        try {
            for (int i = 1; i <= length; ++i) {
                seq.removeGap(start);
            }
        }
        catch (IllegalSymbolException e) {
            throw new BioError("We should have tested for this already");
        }
    }

    protected synchronized boolean allGaps(SymbolList seq, int start, int end) {
        Symbol gs = seq.getAlphabet().getGapSymbol();
        for (int i = start; i <= end; ++i) {
            if (seq.symbolAt(i).equals(gs)) continue;
            return false;
        }
        return true;
    }

    protected synchronized void resetRange() throws ChangeVetoException {
        int min = 0;
        int max = 0;
        int count = 1;
        for (Object label : this.getLabels()) {
            int lMin = this.locInAlignment(label).getMin();
            int lMax = this.locInAlignment(label).getMax();
            min = count == 1 ? lMin : this.lesser(min, lMin);
            max = count == 1 ? lMax : this.greater(max, lMax);
            ++count;
        }
        this.alignmentRange = new RangeLocation(min, max);
        if (min != 1) {
            int offset = 1 - this.alignmentRange.getMin();
            this.shiftAll(offset);
            this.alignmentRange = new RangeLocation(this.alignmentRange.getMin() + offset, this.alignmentRange.getMax() + offset);
        }
    }

    protected synchronized void shiftAll(int offset) throws ChangeVetoException {
        List lList = this.getLabels();
        for (Object label : lList) {
            this.shift(label, offset);
        }
    }

    protected synchronized void shift(Object label, int offset) throws ChangeVetoException {
        ChangeEvent celoc = new ChangeEvent(this, EditableAlignment.LOCATION, label);
        ChangeSupport csloc = this.getChangeSupport(EditableAlignment.LOCATION);
        Location oLoc = this.locInAlignment(label);
        RangeLocation nLoc = new RangeLocation(oLoc.getMin() + offset, oLoc.getMax() + offset);
        csloc.firePreChangeEvent(celoc);
        this.debug("shifting " + label.toString());
        this.getAE(label).setLoc(nLoc);
        this.resetRange();
        this.debug("shifted " + label);
        csloc.firePostChangeEvent(celoc);
    }

    protected int greater(int x, int y) {
        int greatest = x > y ? x : y;
        return greatest;
    }

    protected int lesser(int x, int y) {
        int least = x < y ? x : y;
        return least;
    }

    protected AlignmentElement getAE(Object label) throws NoSuchElementException {
        if (!this.data.containsKey(label)) {
            // empty if block
        }
        return (AlignmentElement)this.data.get(label);
    }

    protected synchronized int posInSeq(Object label, int column) throws NoSuchElementException, IndexOutOfBoundsException {
        if (column < 1 || column > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        Location loc = this.locInAlignment(label);
        return column - loc.getMin() + 1;
    }

    protected synchronized Location locInSeq(Object label, Location viewLoc) throws NoSuchElementException, IndexOutOfBoundsException {
        int min = this.posInSeq(label, viewLoc.getMin());
        int max = this.posInSeq(label, viewLoc.getMax());
        return new RangeLocation(min, max);
    }
}

