/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.List;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.SymbolList;

public abstract class SequenceAlignment {
    public abstract String getAlignmentString() throws Exception;

    public abstract List alignAll(SequenceIterator var1, SequenceDB var2) throws Exception;

    public abstract int pairwiseAlignment(SymbolList var1, SymbolList var2) throws Exception;

    public abstract Alignment getAlignment(SymbolList var1, SymbolList var2) throws Exception;

    public static StringBuffer formatOutput(String queryName, String targetName, String[] align, String path, int queryStart, int queryEnd, long queryLength, int targetStart, int targetEnd, long targetLength, int editdistance, long time) {
        int n;
        int l;
        int k;
        String newLine = System.getProperty("line.separator");
        StringBuffer output = new StringBuffer(newLine);
        output.append(" Time (ms):\t");
        output.append(time);
        output.append(newLine);
        output.append(" Length:\t");
        output.append(align[0].length());
        output.append(newLine);
        output.append("  Score:\t" + -1 * editdistance);
        output.append(newLine);
        output.append("  Query:\t");
        output.append(queryName);
        output.append(",\tLength:\t");
        output.append(queryLength);
        output.append(newLine);
        output.append("  Target:\t");
        output.append(targetName);
        output.append(",\tLength:\t");
        output.append(targetLength);
        output.append(newLine);
        output.append(newLine);
        int currline = Math.min(60, align[0].length());
        String space = "  ";
        String kspace = "";
        String jspace = "";
        for (k = 0; k < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++k) {
            space = space + " ";
        }
        for (k = new Integer(queryStart + 1).toString().length(); k <= new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++k) {
            kspace = kspace + " ";
        }
        for (k = new Integer(targetStart + 1).toString().length(); k <= new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++k) {
            jspace = jspace + " ";
        }
        int i = k = queryStart;
        int j = l = targetStart;
        output.append(newLine);
        output.append("Query:\t");
        output.append(kspace);
        output.append(k + 1);
        output.append(' ');
        for (i = currline - Math.min(60, align[0].length()); i < currline; ++i) {
            if (align[0].charAt(i) != '-' && align[0].charAt(i) != '~') {
                ++k;
            }
            if (align[1].charAt(i) == '-' || align[1].charAt(i) == '~') continue;
            ++j;
        }
        output.append(align[0].substring(0, currline));
        output.append(' ');
        output.append(k);
        output.append(' ');
        output.append(newLine);
        output.append("        ");
        output.append(space);
        output.append(path.substring(0, currline));
        output.append(' ');
        output.append(newLine);
        output.append("Target:\t");
        output.append(jspace);
        output.append(l + 1);
        output.append(' ');
        output.append(align[1].substring(0, currline));
        output.append(' ');
        output.append(j);
        output.append(' ');
        output.append(newLine);
        while (currline + 60 < path.length()) {
            l = Math.min(j + 1, targetEnd);
            jspace = "";
            kspace = "";
            for (n = new Integer(k + 1).toString().length() - 1; n < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++n) {
                kspace = kspace + " ";
            }
            for (n = new Integer(j).toString().length() - 1; n < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++n) {
                jspace = jspace + " ";
            }
            output.append(' ');
            output.append(newLine);
            output.append("Query:\t");
            output.append(kspace);
            output.append(Math.min(k + 1, queryEnd));
            output.append(' ');
            for (i = currline; i < currline + 60; ++i) {
                if (align[0].charAt(i) != '-' && align[0].charAt(i) != '~') {
                    ++k;
                }
                if (align[1].charAt(i) == '-' || align[1].charAt(i) == '~') continue;
                ++j;
            }
            output.append(align[0].substring(currline, currline + 60));
            output.append(' ');
            output.append(k);
            output.append(' ');
            output.append(newLine);
            output.append("        ");
            output.append(space);
            output.append(path.substring(currline, currline + 60));
            output.append(' ');
            output.append(newLine);
            output.append("Target:\t");
            output.append(jspace);
            output.append(l);
            output.append(' ');
            output.append(align[1].substring(currline, currline + 60));
            output.append(' ');
            output.append(j);
            output.append(' ');
            output.append(newLine);
            currline += 60;
        }
        align[0] = align[0] + " " + queryEnd;
        align[1] = align[1] + " " + targetEnd;
        if (currline + 1 < path.length()) {
            jspace = "";
            kspace = "";
            for (n = new Integer(k).toString().length() - 1; n < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++n) {
                kspace = kspace + " ";
            }
            for (n = new Integer(j).toString().length() - 1; n < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++n) {
                jspace = jspace + " ";
            }
            output.append(' ');
            output.append(newLine);
            output.append("Query:\t");
            output.append(kspace);
            output.append(Math.min(k + 1, queryEnd));
            output.append(' ');
            output.append(align[0].substring(currline, align[0].length()));
            output.append(' ');
            output.append(newLine);
            output.append("        ");
            output.append(space);
            output.append(path.substring(currline, path.length()));
            output.append(' ');
            output.append(newLine);
            output.append("Target:\t");
            output.append(jspace);
            output.append(Math.min(j + 1, targetEnd));
            output.append(' ');
            output.append(align[1].substring(currline, align[1].length()));
            output.append(newLine);
        }
        output.append(newLine);
        return output;
    }
}

