/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.annodb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.AnnotationTools;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.annodb.AnnotationDB;

public class MergingAnnotationDB
implements AnnotationDB {
    private final String name;
    private final List merged;

    public MergingAnnotationDB(String name) {
        this.name = name;
        this.merged = new ArrayList();
    }

    public MergingAnnotationDB(String name, List merged) {
        this.name = name;
        this.merged = new ArrayList(merged);
    }

    public void addAnnotationDB(AnnotationDB toAdd) {
        if (!this.merged.contains(toAdd)) {
            this.merged.add(toAdd);
        }
    }

    public void removeAnnotationDB(AnnotationDB toRemove) {
        this.merged.remove(toRemove);
    }

    public List getMerged() {
        return new ArrayList(this.merged);
    }

    public String getName() {
        return this.name;
    }

    public AnnotationType getSchema() {
        AnnotationType schema = AnnotationType.NONE;
        for (AnnotationDB db : this.merged) {
            schema = AnnotationTools.union(schema, db.getSchema());
        }
        return schema;
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator ii;
            Iterator ci;
            Object item;
            {
                this.ii = MergingAnnotationDB.this.merged.iterator();
                while (this.item == null && this.ii.hasNext()) {
                    AnnotationDB adb = (AnnotationDB)this.ii.next();
                    this.ci = adb.iterator();
                    if (!this.ci.hasNext()) continue;
                    this.item = this.ci.next();
                }
            }

            public boolean hasNext() {
                return this.item != null;
            }

            public Object next() {
                Object it = this.item;
                this.item = this._next();
                return it;
            }

            private Object _next() {
                while (!this.ci.hasNext()) {
                    if (this.ii.hasNext()) {
                        AnnotationDB adb = (AnnotationDB)this.ii.next();
                        this.ci = adb.iterator();
                        continue;
                    }
                    return null;
                }
                return this.ci.next();
            }

            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }

    public int size() {
        int size = 0;
        Iterator dbi = this.merged.iterator();
        while (dbi.hasNext()) {
            size += ((AnnotationDB)dbi.next()).size();
        }
        return size;
    }

    public AnnotationDB filter(AnnotationType at) {
        ArrayList<AnnotationDB> anns = new ArrayList<AnnotationDB>();
        for (AnnotationDB adb : this.merged) {
            AnnotationDB res = adb.filter(at);
            if (res.size() <= 0) continue;
            anns.add(res);
        }
        if (anns.isEmpty()) {
            return AnnotationDB.EMPTY;
        }
        if (anns.size() == 1) {
            return (AnnotationDB)anns.get(0);
        }
        return new MergingAnnotationDB("", anns);
    }

    public AnnotationDB search(AnnotationType at) {
        ArrayList<AnnotationDB> anns = new ArrayList<AnnotationDB>();
        for (AnnotationDB adb : this.merged) {
            AnnotationDB res = adb.search(at);
            if (res.size() <= 0) continue;
            anns.add(res);
        }
        if (anns.isEmpty()) {
            return AnnotationDB.EMPTY;
        }
        if (anns.size() == 1) {
            return (AnnotationDB)anns.get(0);
        }
        return new MergingAnnotationDB("", anns);
    }
}

