/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.fastq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.biojava.bio.program.fastq.Fastq;
import org.biojava.bio.program.fastq.FastqBuilder;
import org.biojava.bio.program.fastq.FastqReader;
import org.biojava.bio.program.fastq.FastqVariant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFastqReader
implements FastqReader {
    AbstractFastqReader() {
    }

    protected abstract FastqVariant getVariant();

    protected abstract void validateDescription(FastqBuilder var1, String var2, int var3) throws IOException;

    protected abstract void validateSequence(FastqBuilder var1, String var2, int var3) throws IOException;

    protected abstract void validateRepeatDescription(FastqBuilder var1, String var2, int var3) throws IOException;

    protected abstract void validateQuality(FastqBuilder var1, String var2, int var3) throws IOException;

    @Override
    public final Iterable<Fastq> read(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Iterable<Fastq> iterable = this.read(inputStream);
            return iterable;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public final Iterable<Fastq> read(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            Iterable<Fastq> iterable = this.read(inputStream);
            return iterable;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public final Iterable<Fastq> read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        int lineNumber = 0;
        State state = State.DESCRIPTION;
        ArrayList<Fastq> result = new ArrayList<Fastq>();
        FastqBuilder builder = new FastqBuilder().withVariant(this.getVariant());
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while (reader.ready()) {
            String line = reader.readLine();
            switch (state) {
                case DESCRIPTION: {
                    this.validateDescription(builder, line, lineNumber);
                    builder.withDescription(line.substring(1).trim());
                    state = State.SEQUENCE;
                    break;
                }
                case SEQUENCE: {
                    this.validateSequence(builder, line, lineNumber);
                    builder.withSequence(line.trim());
                    state = State.REPEAT_DESCRIPTION;
                    break;
                }
                case REPEAT_DESCRIPTION: {
                    if (!line.startsWith("+")) {
                        builder.appendSequence(line.trim());
                        break;
                    }
                    this.validateRepeatDescription(builder, line, lineNumber);
                    state = State.QUALITY;
                    break;
                }
                case QUALITY: {
                    this.validateQuality(builder, line, lineNumber);
                    builder.withQuality(line.trim());
                    state = State.COMPLETE;
                    break;
                }
                case COMPLETE: {
                    if (!builder.sequenceAndQualityLengthsMatch()) {
                        builder.appendQuality(line.trim());
                        break;
                    }
                    try {
                        result.add(builder.build());
                    }
                    catch (IllegalStateException e) {
                        throw new IOException("caught an IllegalStateException at line " + lineNumber + ", " + e.getMessage());
                    }
                    this.validateDescription(builder, line, lineNumber);
                    builder.withDescription(line.substring(1).trim());
                    state = State.SEQUENCE;
                    break;
                }
            }
            ++lineNumber;
        }
        if (state == State.COMPLETE) {
            try {
                result.add(builder.build());
                state = State.DESCRIPTION;
            }
            catch (IllegalStateException e) {
                throw new IOException("caught an IllegalStateException at line " + lineNumber + ", " + e.getMessage());
            }
        }
        if (state != State.DESCRIPTION) {
            throw new IOException("truncated sequence at line " + lineNumber);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        DESCRIPTION,
        SEQUENCE,
        REPEAT_DESCRIPTION,
        QUALITY,
        COMPLETE;

    }
}

