/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.fastq;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import org.biojava.bio.program.fastq.Fastq;
import org.biojava.bio.program.fastq.FastqWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFastqWriter
implements FastqWriter {
    AbstractFastqWriter() {
    }

    protected abstract void validate(Fastq var1) throws IOException;

    @Override
    public final <T extends Appendable> T append(T appendable, Fastq ... fastq) throws IOException {
        return this.append(appendable, Arrays.asList(fastq));
    }

    @Override
    public final <T extends Appendable> T append(T appendable, Iterable<Fastq> fastq) throws IOException {
        if (appendable == null) {
            throw new IllegalArgumentException("appendable must not be null");
        }
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        for (Fastq f : fastq) {
            this.validate(f);
            if (f == null) continue;
            appendable.append("@");
            appendable.append(f.getDescription());
            appendable.append("\n");
            appendable.append(f.getSequence());
            appendable.append("\n");
            appendable.append("+\n");
            appendable.append(f.getQuality());
            appendable.append("\n");
        }
        return appendable;
    }

    @Override
    public final void write(File file, Fastq ... fastq) throws IOException {
        this.write(file, Arrays.asList(fastq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(File file, Iterable<Fastq> fastq) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            this.append(writer, fastq);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public final void write(OutputStream outputStream, Fastq ... fastq) throws IOException {
        this.write(outputStream, Arrays.asList(fastq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(OutputStream outputStream, Iterable<Fastq> fastq) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream must not be null");
        }
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(outputStream));
            this.append(writer, fastq);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException e) {}
            }
        }
    }
}

