/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.fastq;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FastqVariant {
    FASTQ_SANGER("Original or Sanger format"),
    FASTQ_SOLEXA("Solexa and early Illumina format"),
    FASTQ_ILLUMINA("Illumina 1.3+ format");

    private static final Map<String, FastqVariant> FASTQ_VARIANTS;
    private final String description;

    private FastqVariant(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description must not be null");
        }
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSanger() {
        return this == FASTQ_SANGER;
    }

    public boolean isSolexa() {
        return this == FASTQ_SOLEXA;
    }

    public boolean isIllumina() {
        return this == FASTQ_ILLUMINA;
    }

    public String lowercaseName() {
        return this.name().toLowerCase().replace('_', '-');
    }

    public static FastqVariant parseFastqVariant(String name) {
        return FASTQ_VARIANTS.get(name);
    }

    static {
        FASTQ_VARIANTS = new HashMap<String, FastqVariant>(6);
        for (FastqVariant fastqVariant : FastqVariant.values()) {
            FASTQ_VARIANTS.put(fastqVariant.name(), fastqVariant);
            FASTQ_VARIANTS.put(fastqVariant.lowercaseName(), fastqVariant);
        }
    }
}

