/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.fastq;

import java.io.IOException;
import org.biojava.bio.program.fastq.AbstractFastqReader;
import org.biojava.bio.program.fastq.FastqBuilder;
import org.biojava.bio.program.fastq.FastqVariant;

public final class SangerFastqReader
extends AbstractFastqReader {
    protected FastqVariant getVariant() {
        return FastqVariant.FASTQ_SANGER;
    }

    protected void validateDescription(FastqBuilder builder, String description, int lineNumber) throws IOException {
        if (!description.startsWith("@")) {
            throw new IOException("description must begin with a '@' character at line " + lineNumber);
        }
    }

    protected void validateSequence(FastqBuilder builder, String sequence, int lineNumber) throws IOException {
    }

    protected void validateRepeatDescription(FastqBuilder builder, String repeatDescription, int lineNumber) throws IOException {
        String description = builder.getDescription();
        if (description != null && description.length() > 0 && repeatDescription.length() > 1 && !description.equals(repeatDescription.substring(1))) {
            throw new IOException("repeat description must match description at line " + lineNumber);
        }
    }

    protected void validateQuality(FastqBuilder builder, String quality, int lineNumber) throws IOException {
        for (int i = 0; i < quality.length(); ++i) {
            char c = quality.charAt(i);
            if (c >= '!' && c <= '~') continue;
            throw new IOException("quality scores must contain ASCII codes 33 to 126, found " + c + " at line " + lineNumber);
        }
    }
}

