/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.xff;

import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class LocationHandlerBase
extends StAXContentHandlerBase {
    private int level = 0;
    private Location location = Location.empty;

    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        ++this.level;
        if (this.level != 0 && localName.equals("span")) {
            try {
                String starts = attrs.getValue("start");
                String stops = attrs.getValue("stop");
                if (starts == null || stops == null) {
                    throw new SAXException("Missing start/stop attribute in location span");
                }
                RangeLocation span = new RangeLocation(Integer.parseInt(starts), Integer.parseInt(stops));
                this.location = this.location.union(span);
            }
            catch (NumberFormatException ex) {
                throw new SAXException("Error parsing location", ex);
            }
        }
    }

    public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        --this.level;
        if (this.level == 0) {
            this.setLocationValue(this.location);
        }
    }

    protected abstract void setLocationValue(Location var1) throws SAXException;
}

