/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.PairDistribution;
import org.biojava.bio.dist.SimpleDistribution;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.ChangeVetoException;

public final class DNATools {
    private static final ReversibleTranslationTable complementTable;
    private static final FiniteAlphabet dna;
    private static final SymbolTokenization dnaTokens;
    private static final AtomicSymbol a;
    private static final AtomicSymbol g;
    private static final AtomicSymbol c;
    private static final AtomicSymbol t;
    private static final Symbol n;
    private static final Symbol m;
    private static final Symbol r;
    private static final Symbol w;
    private static final Symbol s;
    private static final Symbol y;
    private static final Symbol k;
    private static final Symbol v;
    private static final Symbol h;
    private static final Symbol d;
    private static final Symbol b;
    private static final SimpleReversibleTranslationTable transcriptionTable;
    private static Map symbolToComplement;

    public static AtomicSymbol a() {
        return a;
    }

    public static AtomicSymbol g() {
        return g;
    }

    public static AtomicSymbol c() {
        return c;
    }

    public static AtomicSymbol t() {
        return t;
    }

    public static Symbol n() {
        return n;
    }

    public static Symbol m() {
        return m;
    }

    public static Symbol r() {
        return r;
    }

    public static Symbol w() {
        return w;
    }

    public static Symbol s() {
        return s;
    }

    public static Symbol y() {
        return y;
    }

    public static Symbol k() {
        return k;
    }

    public static Symbol v() {
        return v;
    }

    public static Symbol h() {
        return h;
    }

    public static Symbol d() {
        return d;
    }

    public static Symbol b() {
        return b;
    }

    private DNATools() {
    }

    public static FiniteAlphabet getDNA() {
        return dna;
    }

    public static FiniteAlphabet getDNAxDNA() {
        return (FiniteAlphabet)AlphabetManager.generateCrossProductAlphaFromName("(DNA x DNA)");
    }

    public static FiniteAlphabet getCodonAlphabet() {
        return (FiniteAlphabet)AlphabetManager.generateCrossProductAlphaFromName("(DNA x DNA x DNA)");
    }

    public static SymbolList createDNA(String dna) throws IllegalSymbolException {
        SymbolTokenization p = null;
        try {
            p = DNATools.getDNA().getTokenization("token");
        }
        catch (BioException e) {
            throw new BioError("Something has gone badly wrong with DNA", e);
        }
        return new SimpleSymbolList(p, dna);
    }

    public static Sequence createDNASequence(String dna, String name) throws IllegalSymbolException {
        if (dna.indexOf(45) != -1 || dna.indexOf(126) != -1) {
            return DNATools.createGappedDNASequence(dna, name);
        }
        return new SimpleSequenceFactory().createSequence(DNATools.createDNA(dna), "", name, new SimpleAnnotation());
    }

    public static GappedSequence createGappedDNASequence(String dna, String name) throws IllegalSymbolException {
        String dna1 = dna.replaceAll("-", "");
        Sequence dnaSeq = DNATools.createDNASequence(dna1, name);
        SimpleGappedSequence dnaSeq1 = new SimpleGappedSequence(dnaSeq);
        int pos = dna.indexOf(45, 0);
        while (pos != -1) {
            dnaSeq1.addGapInView(pos + 1);
            pos = dna.indexOf(45, pos + 1);
        }
        return dnaSeq1;
    }

    public static int index(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return 0;
        }
        if (sym == g) {
            return 1;
        }
        if (sym == c) {
            return 2;
        }
        if (sym == t) {
            return 3;
        }
        DNATools.getDNA().validate(sym);
        throw new IllegalSymbolException("Really confused. Can't find index for " + sym.getName());
    }

    public static Symbol forIndex(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return a;
        }
        if (index == 1) {
            return g;
        }
        if (index == 2) {
            return c;
        }
        if (index == 3) {
            return t;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + index);
    }

    public static Symbol complement(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return t;
        }
        if (sym == g) {
            return c;
        }
        if (sym == c) {
            return g;
        }
        if (sym == t) {
            return a;
        }
        Symbol s = (Symbol)symbolToComplement.get(sym);
        if (s != null) {
            return s;
        }
        DNATools.getDNA().validate(sym);
        throw new BioError("Really confused. Can't find symbol " + sym.getName());
    }

    public static Symbol forSymbol(char token) throws IllegalSymbolException {
        SymbolTokenization toke;
        String t = String.valueOf(token);
        try {
            toke = DNATools.getDNA().getTokenization("token");
        }
        catch (BioException e) {
            throw new BioError("Cannot find the 'token' Tokenization for DNA!?", e);
        }
        return toke.parseToken(t);
    }

    public static SymbolList complement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, DNATools.complementTable());
    }

    public static SymbolList reverseComplement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(list), DNATools.complementTable());
    }

    public static SymbolList flip(SymbolList list, StrandedFeature.Strand strand) throws IllegalAlphabetException {
        if (strand == StrandedFeature.NEGATIVE) {
            return DNATools.reverseComplement(list);
        }
        return list;
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    public static char dnaToken(Symbol sym) throws IllegalSymbolException {
        return dnaTokens.tokenizeSymbol(sym).charAt(0);
    }

    public static Distribution getDNADistribution(double fractionGC) {
        try {
            SimpleDistribution dist = new SimpleDistribution(DNATools.getDNA());
            double gc = 0.5 * fractionGC;
            double at = 0.5 * (1.0 - fractionGC);
            dist.setWeight(DNATools.a(), at);
            dist.setWeight(DNATools.t(), at);
            dist.setWeight(DNATools.c(), gc);
            dist.setWeight(DNATools.g(), gc);
            return dist;
        }
        catch (IllegalSymbolException ise) {
            return null;
        }
        catch (ChangeVetoException cve) {
            return null;
        }
    }

    public static Distribution getDNAxDNADistribution(double fractionGC0, double fractionGC1) {
        return new PairDistribution(DNATools.getDNADistribution(fractionGC0), DNATools.getDNADistribution(fractionGC1));
    }

    public static SymbolList toRNA(SymbolList syms) throws IllegalAlphabetException {
        return SymbolListViews.translate(syms, transcriptionTable);
    }

    public static SymbolList transcribeToRNA(SymbolList syms) throws IllegalAlphabetException {
        syms = DNATools.reverseComplement(syms);
        return DNATools.toRNA(syms);
    }

    public static SymbolList toProtein(SymbolList syms) throws IllegalAlphabetException {
        SymbolList symz = new SimpleSymbolList(syms);
        symz = DNATools.toRNA(symz);
        symz = symz.subList(1, symz.length() - symz.length() % 3);
        return RNATools.translate(symz);
    }

    public static SymbolList toProtein(SymbolList syms, int start, int end) throws IllegalAlphabetException {
        SymbolList symz = new SimpleSymbolList(syms);
        symz = symz.subList(start, end);
        return DNATools.toProtein(symz);
    }

    static {
        try {
            dna = (FiniteAlphabet)AlphabetManager.alphabetForName("DNA");
            dnaTokens = dna.getTokenization("token");
            SimpleSymbolList syms = new SimpleSymbolList(dnaTokens, "agctnmrwsykvhdb");
            a = (AtomicSymbol)syms.symbolAt(1);
            g = (AtomicSymbol)syms.symbolAt(2);
            c = (AtomicSymbol)syms.symbolAt(3);
            t = (AtomicSymbol)syms.symbolAt(4);
            n = syms.symbolAt(5);
            m = syms.symbolAt(6);
            r = syms.symbolAt(7);
            w = syms.symbolAt(8);
            s = syms.symbolAt(9);
            y = syms.symbolAt(10);
            k = syms.symbolAt(11);
            v = syms.symbolAt(12);
            h = syms.symbolAt(13);
            d = syms.symbolAt(14);
            b = syms.symbolAt(15);
            symbolToComplement = new HashMap();
            Symbol gap = dna.getGapSymbol();
            symbolToComplement.put(gap, gap);
            for (Symbol as : AlphabetManager.getAllSymbols(dna)) {
                FiniteAlphabet matches = (FiniteAlphabet)as.getMatches();
                if (matches.size() <= 1) continue;
                HashSet<Symbol> l = new HashSet<Symbol>();
                Iterator<Symbol> j = matches.iterator();
                while (j.hasNext()) {
                    l.add(DNATools.complement(j.next()));
                }
                symbolToComplement.put(as, dna.getAmbiguity(l));
            }
            complementTable = new DNAComplementTranslationTable();
            transcriptionTable = new SimpleReversibleTranslationTable(DNATools.getDNA(), RNATools.getRNA());
            transcriptionTable.setTranslation(a, RNATools.a());
            transcriptionTable.setTranslation(c, RNATools.c());
            transcriptionTable.setTranslation(g, RNATools.g());
            transcriptionTable.setTranslation(t, RNATools.u());
        }
        catch (Throwable th) {
            throw new BioError("Unable to initialize DNATools", th);
        }
    }

    private static class DNAComplementTranslationTable
    implements ReversibleTranslationTable {
        private DNAComplementTranslationTable() {
        }

        public Symbol translate(Symbol s) throws IllegalSymbolException {
            return DNATools.complement(s);
        }

        public Symbol untranslate(Symbol s) throws IllegalSymbolException {
            return DNATools.complement(s);
        }

        public Alphabet getSourceAlphabet() {
            return DNATools.getDNA();
        }

        public Alphabet getTargetAlphabet() {
            return DNATools.getDNA();
        }
    }
}

