/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.db.biosql.DBHelper;
import org.biojava.bio.taxa.CircularReferenceException;
import org.biojava.bio.taxa.EbiFormat;
import org.biojava.bio.taxa.Taxon;
import org.biojava.bio.taxa.TaxonFactory;
import org.biojava.bio.taxa.WeakTaxonFactory;
import org.biojava.utils.ChangeVetoException;

public class TaxonSQL {
    public static Taxon getTaxon(Connection conn, int ncbi_taxon_id) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Taxon t = null;
        try {
            ps = conn.prepareStatement("SELECT name FROM   taxon_name, taxon WHERE  taxon_name.taxon_id = taxon.taxon_id AND       taxon_name.name_class LIKE 'scientific%' AND       ncbi_taxon_id = ?");
            ps.setInt(1, ncbi_taxon_id);
            rs = ps.executeQuery();
            if (rs.next()) {
                t = TaxonSQL.getTaxon(conn, rs.getString(1));
            }
        }
        catch (SQLException exc) {
            try {
                throw new BioRuntimeException(exc);
            }
            catch (Throwable throwable) {
                TaxonSQL.attemptClose(rs);
                TaxonSQL.attemptClose(ps);
                throw throwable;
            }
        }
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(ps);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Taxon getDBTaxon(Connection conn, int taxon_id) throws SQLException, ChangeVetoException {
        Taxon taxon;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String nextID;
            boolean NCBI_ID = true;
            boolean TAXON_ID = false;
            statement = conn.prepareStatement("SELECT ncbi_taxon_id, parent_taxon_id FROM   taxon WHERE  taxon_id = ? ");
            ArrayList<int[]> path = new ArrayList<int[]>();
            while (taxon_id != 0) {
                statement.setInt(1, taxon_id);
                rs = statement.executeQuery();
                if (rs.next()) {
                    path.add(new int[]{taxon_id, rs.getInt(1)});
                    taxon_id = rs.getInt(2);
                    if (rs.wasNull()) {
                        taxon_id = 0;
                    }
                } else {
                    throw new BioRuntimeException("Error fetching taxonomy structure. No taxon with taxon_id=" + taxon_id);
                }
                rs.close();
            }
            statement.close();
            WeakTaxonFactory factory = WeakTaxonFactory.GLOBAL;
            Taxon taxon2 = factory.getRoot();
            int pos = path.size() - 1;
            int[] ids = (int[])path.get(pos--);
            Map names = TaxonSQL.getTaxonNames(conn, ids[0]);
            taxon2.getAnnotation().setProperty(EbiFormat.PROPERTY_NCBI_TAXON, "" + ids[1]);
            taxon2.getAnnotation().setProperty(EbiFormat.PROPERTY_TAXON_NAMES, names);
            if (pos >= 0) {
                ids = (int[])path.get(pos);
                nextID = "" + ids[1];
                Set children = taxon2.getChildren();
                for (Taxon child : children) {
                    Annotation anno = child.getAnnotation();
                    if (anno.containsProperty(EbiFormat.PROPERTY_NCBI_TAXON)) {
                        String childID = (String)anno.getProperty(EbiFormat.PROPERTY_NCBI_TAXON);
                        if (!childID.equals(nextID)) continue;
                        taxon2 = child;
                        continue;
                    }
                    throw new BioRuntimeException("Taxon has not been annotated with NCBI taxon ids.");
                }
            }
            try {
                while (pos >= 0) {
                    ids = (int[])path.get(pos);
                    nextID = "" + ids[1];
                    names = TaxonSQL.getTaxonNames(conn, ids[0]);
                    String sciName = (String)names.get("scientific name");
                    if (sciName == null) {
                        throw new BioRuntimeException("No scientific name for taxon_id=" + ids[0]);
                    }
                    String commonName = (String)names.get("common name");
                    taxon2 = factory.addChild(taxon2, factory.createTaxon(sciName, commonName));
                    taxon2.getAnnotation().setProperty(EbiFormat.PROPERTY_NCBI_TAXON, nextID);
                    taxon2.getAnnotation().setProperty(EbiFormat.PROPERTY_TAXON_NAMES, names);
                    taxon2 = TaxonSQL.getProperties(conn, taxon2);
                    --pos;
                }
            }
            catch (CircularReferenceException ex) {
                throw new BioRuntimeException("Circular references in taxon table. taxon_id=" + ids[0]);
            }
            taxon = TaxonSQL.getProperties(conn, taxon2);
        }
        catch (Throwable throwable) {
            TaxonSQL.attemptClose(rs);
            TaxonSQL.attemptClose(statement);
            throw throwable;
        }
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(statement);
        return taxon;
    }

    private static Map getTaxonNames(Connection conn, int taxon_id) {
        HashMap<String, Object> hashMap;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement("SELECT name_class, name FROM   taxon_name WHERE  taxon_id = ? ");
            statement.setInt(1, taxon_id);
            rs = statement.executeQuery();
            HashMap<String, Object> names = new HashMap<String, Object>();
            while (rs.next()) {
                String name_class = rs.getString(1);
                String name = rs.getString(2);
                if (name_class.equals("scientific name") || name_class.equals("common name")) {
                    names.put(name_class, name);
                    continue;
                }
                HashSet<String> s = new HashSet<String>();
                s.add(name);
                if (names.containsKey(name_class)) {
                    s.addAll((Collection)names.get(name_class));
                }
                names.put(name_class, s);
            }
            hashMap = names;
        }
        catch (SQLException ex) {
            try {
                throw new BioRuntimeException("Error fetching taxonomy annotations", ex);
            }
            catch (Throwable throwable) {
                TaxonSQL.attemptClose(rs);
                TaxonSQL.attemptClose(statement);
                throw throwable;
            }
        }
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(statement);
        return hashMap;
    }

    public static int putTaxon(Connection conn, DBHelper helper, Taxon taxon) throws SQLException {
        int taxon_id;
        Annotation anno = taxon.getAnnotation();
        Object t = anno.getProperty(EbiFormat.PROPERTY_NCBI_TAXON);
        if (t instanceof List) {
            t = (String)((List)t).get(0);
        }
        int ncbi_taxon_id = Integer.parseInt((String)t);
        PreparedStatement selectTaxon = conn.prepareStatement("select taxon_id from taxon where ncbi_taxon_id = ? ");
        selectTaxon.setInt(1, ncbi_taxon_id);
        ResultSet trs = selectTaxon.executeQuery();
        if (trs.next()) {
            taxon_id = trs.getInt(1);
        } else {
            Taxon parent = taxon.getParent();
            String right = "NULL";
            String left = "NULL";
            String mitocode = "NULL";
            String gencode = "NULL";
            String rank = "NULL";
            if (taxon.getAnnotation().containsProperty("rank")) {
                rank = taxon.getAnnotation().getProperty("rank").toString();
            }
            if (taxon.getAnnotation().containsProperty("genetic code id")) {
                gencode = taxon.getAnnotation().getProperty("genetic code id").toString();
            }
            if (taxon.getAnnotation().containsProperty("mitochondrial genetic code id")) {
                mitocode = taxon.getAnnotation().getProperty("mitochondrial genetic code id").toString();
            }
            if (taxon.getAnnotation().containsProperty("left value")) {
                left = taxon.getAnnotation().getProperty("left value").toString();
            }
            if (taxon.getAnnotation().containsProperty("right value")) {
                right = taxon.getAnnotation().getProperty("right value").toString();
            }
            PreparedStatement createTaxon = null;
            if (parent != null) {
                int parent_taxon_id = TaxonSQL.putTaxon(conn, helper, parent);
                createTaxon = conn.prepareStatement("insert into taxon (ncbi_taxon_id, parent_taxon_id, node_rank, genetic_code, mito_genetic_code, left_value, right_value) values (?, ?, ?, ?, ?, ?, ?)");
                createTaxon.setInt(1, ncbi_taxon_id);
                createTaxon.setInt(2, parent_taxon_id);
                if (rank.equals("NULL")) {
                    createTaxon.setNull(3, 12);
                } else {
                    createTaxon.setString(3, rank);
                }
                if (gencode.equals("NULL")) {
                    createTaxon.setNull(4, -6);
                } else {
                    createTaxon.setInt(4, new Integer(gencode));
                }
                if (mitocode.equals("NULL")) {
                    createTaxon.setNull(5, -6);
                } else {
                    createTaxon.setInt(5, new Integer(mitocode));
                }
                if (left.equals("NULL")) {
                    createTaxon.setNull(6, 4);
                } else {
                    createTaxon.setInt(6, new Integer(left));
                }
                if (right.equals("NULL")) {
                    createTaxon.setNull(7, 4);
                } else {
                    createTaxon.setInt(7, new Integer(right));
                }
            } else {
                createTaxon = conn.prepareStatement("insert into taxon (ncbi_taxon_id, node_rank, genetic_code, mito_genetic_code, left_value, right_value) values (?, ?, ?, ?, ?, ?)");
                createTaxon.setInt(1, ncbi_taxon_id);
                if (rank.equals("NULL")) {
                    createTaxon.setNull(2, 12);
                } else {
                    createTaxon.setString(2, rank);
                }
                if (gencode.equals("NULL")) {
                    createTaxon.setNull(3, -6);
                } else {
                    createTaxon.setInt(3, new Integer(gencode));
                }
                if (mitocode.equals("NULL")) {
                    createTaxon.setNull(4, -6);
                } else {
                    createTaxon.setInt(4, new Integer(mitocode));
                }
                if (left.equals("NULL")) {
                    createTaxon.setNull(5, 4);
                } else {
                    createTaxon.setInt(5, new Integer(left));
                }
                if (right.equals("NULL")) {
                    createTaxon.setNull(6, 4);
                } else {
                    createTaxon.setInt(6, new Integer(right));
                }
            }
            createTaxon.executeUpdate();
            createTaxon.close();
            taxon_id = helper.getInsertID(conn, "taxon", "taxon_id");
            TaxonSQL.putTaxonNames(conn, (Map)taxon.getAnnotation().getProperty(EbiFormat.PROPERTY_TAXON_NAMES), taxon_id);
        }
        trs.close();
        selectTaxon.close();
        return taxon_id;
    }

    private static void putTaxonNames(Connection conn, Map names, int taxon_id) throws SQLException {
        if (names != null) {
            for (String nameClass : names.keySet()) {
                if (names.get(nameClass) instanceof Set) {
                    Set all_names = (Set)names.get(nameClass);
                    for (String name : all_names) {
                        PreparedStatement createTaxon = conn.prepareStatement("insert into taxon_name (taxon_id, name, name_class) values (?, ?, ?)");
                        createTaxon.setInt(1, taxon_id);
                        createTaxon.setString(2, name);
                        createTaxon.setString(3, nameClass);
                        createTaxon.executeUpdate();
                        createTaxon.close();
                    }
                    continue;
                }
                String name = (String)names.get(nameClass);
                PreparedStatement createTaxon = conn.prepareStatement("insert into taxon_name (taxon_id, name, name_class) values (?, ?, ?)");
                createTaxon.setInt(1, taxon_id);
                createTaxon.setString(2, name);
                createTaxon.setString(3, nameClass);
                createTaxon.executeUpdate();
                createTaxon.close();
            }
        }
    }

    public static void attemptClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public static void attemptClose(ResultSet resultset) {
        if (resultset != null) {
            try {
                resultset.close();
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Taxon getTaxon(Connection conn, String name) throws BioRuntimeException {
        Taxon taxon;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            int taxon_id = 0;
            statement = conn.prepareStatement("SELECT taxon.taxon_id FROM   taxon, taxon_name WHERE  taxon.taxon_id = taxon_name.taxon_id   AND  taxon_name.name LIKE ?");
            statement.setString(1, name);
            rs = statement.executeQuery();
            if (rs.next()) {
                taxon_id = rs.getInt(1);
                if (rs.wasNull()) {
                    taxon_id = 0;
                }
            }
            rs.close();
            statement.close();
            taxon = taxon_id != 0 ? TaxonSQL.getDBTaxon(conn, taxon_id) : null;
        }
        catch (ChangeVetoException ex) {
            try {
                throw new BioRuntimeException("Couldn't manipulate in-memory taxonomy", ex);
                catch (SQLException ex2) {
                    throw new BioRuntimeException("Error fetching taxonomy annotations", ex2);
                }
            }
            catch (Throwable throwable) {
                TaxonSQL.attemptClose(rs);
                TaxonSQL.attemptClose(statement);
                throw throwable;
            }
        }
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(statement);
        return taxon;
    }

    public static String[] getAllScientificNames(Connection conn) throws BioRuntimeException {
        String[] scientific_names = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            int taxa_counter = 0;
            int i = 0;
            statement = conn.prepareStatement("SELECT COUNT(distinct name) FROM   taxon_name WHERE  name_class LIKE 'scientific name' ");
            rs = statement.executeQuery();
            if (rs.next()) {
                taxa_counter = rs.getInt(1);
            }
            scientific_names = new String[taxa_counter];
            statement = conn.prepareStatement("SELECT distinct name FROM   taxon_name WHERE  name_class LIKE 'scientific name' ORDER BY name ASC");
            rs = statement.executeQuery();
            while (rs.next()) {
                scientific_names[i++] = rs.getString(1);
                if (!rs.wasNull()) continue;
                --i;
            }
            rs.close();
            statement.close();
            return taxa_counter != 0 ? scientific_names : null;
        }
        catch (SQLException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Taxon getProperties(Connection conn, Taxon taxon) throws BioRuntimeException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String rank = null;
            String gencode = null;
            String mitocode = null;
            String left = null;
            String right = null;
            ps = conn.prepareStatement("SELECT node_rank, genetic_code, mito_genetic_code, left_value, right_value FROM   taxon WHERE  taxon_id = ?");
            ps.setInt(1, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(taxon)));
            rs = ps.executeQuery();
            if (rs.next()) {
                rank = rs.getString(1);
                if (!rs.wasNull()) {
                    taxon.getAnnotation().setProperty("rank", rank);
                }
                gencode = rs.getString(2);
                if (!rs.wasNull()) {
                    taxon.getAnnotation().setProperty("genetic code id", gencode);
                }
                mitocode = rs.getString(3);
                if (!rs.wasNull()) {
                    taxon.getAnnotation().setProperty("mitochondrial genetic code id", mitocode);
                }
                left = String.valueOf(rs.getInt(4));
                if (!rs.wasNull()) {
                    taxon.getAnnotation().setProperty("left value", left);
                }
                right = String.valueOf(rs.getInt(5));
                if (!rs.wasNull()) {
                    taxon.getAnnotation().setProperty("right value", right);
                }
            }
            TaxonSQL.attemptClose(rs);
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
            catch (IllegalArgumentException exc2) {
                throw new BioRuntimeException(exc2);
            }
            catch (ChangeVetoException exc3) {
                throw new BioRuntimeException(exc3);
            }
            catch (BioException exc4) {
                exc4.printStackTrace();
                return taxon;
            }
        }
        TaxonSQL.attemptClose(ps);
        return taxon;
        finally {
            TaxonSQL.attemptClose(rs);
            TaxonSQL.attemptClose(ps);
        }
    }

    public static String getRealScientificName(Taxon t) {
        String tName = "root";
        if (t.getScientificName() != null) {
            tName = t.getScientificName();
        }
        if (tName.toLowerCase().equals("root") && t.getAnnotation() != null && t.getAnnotation().containsProperty(EbiFormat.PROPERTY_TAXON_NAMES) && ((Map)t.getAnnotation().getProperty(EbiFormat.PROPERTY_TAXON_NAMES)).containsKey("scientific name")) {
            tName = ((Map)t.getAnnotation().getProperty(EbiFormat.PROPERTY_TAXON_NAMES)).get("scientific name").toString();
        }
        return tName;
    }

    private static Set ids(Connection conn) throws SQLException {
        HashSet<Integer> ids = new HashSet<Integer>();
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery("SELECT taxon_id FROM taxon");
        while (rs.next()) {
            ids.add(new Integer(rs.getInt(1)));
        }
        TaxonSQL.attemptClose(rs);
        statement.close();
        return ids;
    }

    public static Set NCBIids(Connection conn) throws BioRuntimeException {
        HashSet<Integer> ids = new HashSet<Integer>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery("SELECT ncbi_taxon_id FROM taxon");
            while (rs.next()) {
                ids.add(new Integer(rs.getInt(1)));
            }
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            try {
                rs.close();
                statement.close();
            }
            catch (SQLException exc1) {
                throw new BioRuntimeException(exc1);
            }
        }
        return ids;
    }

    public static Taxon removeTaxon(Connection conn, DBHelper helper, String name) throws SQLException, BioException {
        return TaxonSQL.removeTaxon(conn, helper, TaxonSQL.getTaxonID(conn, name));
    }

    private static Taxon removeTaxon(Connection conn, DBHelper helper, int taxon_id) throws BioRuntimeException {
        Taxon taxon = TaxonSQL.getTaxon(conn, taxon_id);
        try {
            Stack children = TaxonSQL.getChildrenOf(conn, taxon);
            while (!children.isEmpty()) {
                try {
                    Taxon child = (Taxon)children.pop();
                    TaxonSQL.setParent(conn, child, child);
                }
                catch (BioRuntimeException exc) {
                    exc.printStackTrace();
                }
            }
        }
        catch (BioException exc) {
            exc.printStackTrace();
        }
        try {
            Statement delete = conn.createStatement();
            delete.executeUpdate("DELETE FROM taxon_name WHERE taxon_id = " + taxon_id);
            delete.close();
            delete = conn.createStatement();
            delete.executeUpdate("DELETE FROM bioentry WHERE taxon_id = " + taxon_id);
            delete.close();
            delete = conn.createStatement();
            delete.executeUpdate("DELETE FROM taxon WHERE taxon_id = " + taxon_id);
            delete.close();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException("Could not delete successfully", exc);
        }
        return taxon;
    }

    public static Taxon removeTaxon(Connection conn, int ncbi_id, DBHelper helper) throws BioRuntimeException, SQLException, BioException {
        return TaxonSQL.removeTaxon(conn, helper, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(TaxonSQL.getTaxon(conn, ncbi_id))));
    }

    public static Taxon setScientificName(Connection conn, Taxon taxon, String newName) throws SQLException {
        PreparedStatement updateName = conn.prepareStatement("UPDATE taxon_name SET name = ? WHERE  name LIKE ? AND        name_class LIKE ?");
        updateName.setString(1, newName);
        updateName.setString(2, taxon.getScientificName());
        updateName.setString(3, "scientific name");
        updateName.execute();
        TaxonSQL.attemptClose(updateName);
        return TaxonSQL.getTaxon(conn, newName);
    }

    public static Taxon setCommonName(Connection conn, Taxon taxon, String newName) throws BioException, SQLException {
        boolean noCommonName = false;
        String name_class = "common name";
        PreparedStatement question = conn.prepareStatement("SELECT COUNT(name) FROM   taxon_name WHERE  name_class LIKE ? AND        taxon_id = ?");
        question.setString(1, name_class);
        question.setInt(2, TaxonSQL.getTaxonID(conn, taxon.getScientificName()));
        ResultSet rs = question.executeQuery();
        if (rs.next()) {
            if (rs.getInt(1) > 0) {
                TaxonSQL.attemptClose(rs);
                TaxonSQL.attemptClose(question);
                PreparedStatement updateName = conn.prepareStatement("UPDATE taxon_name SET name = ? WHERE  name LIKE ? AND        name_class LIKE ?");
                updateName.setString(1, newName);
                updateName.setString(2, taxon.getScientificName());
                updateName.setString(3, name_class);
                updateName.execute();
                TaxonSQL.attemptClose(updateName);
            } else {
                noCommonName = true;
            }
        }
        if (noCommonName) {
            TaxonSQL.attemptClose(rs);
            TaxonSQL.attemptClose(question);
            PreparedStatement insert = conn.prepareStatement("INSERT INTO taxon_name (taxon_id, name, name_class) VALUES (?, ?, ?)");
            try {
                insert.setInt(1, TaxonSQL.getTaxonID(conn, taxon.getScientificName()));
                insert.setString(2, newName);
                insert.setString(3, name_class);
                insert.execute();
            }
            catch (BioException exc) {
                throw exc;
            }
            catch (SQLException exc) {
                throw exc;
            }
            finally {
                TaxonSQL.attemptClose(insert);
            }
        }
        return TaxonSQL.getTaxon(conn, taxon.getScientificName());
    }

    private static int getTaxonID(Connection conn, String scientificName) throws SQLException, BioException {
        int taxon_id = -1;
        PreparedStatement taxID = conn.prepareStatement("SELECT taxon_id FROM   taxon_name WHERE  name LIKE ? AND        name_class LIKE ?");
        taxID.setString(1, scientificName);
        taxID.setString(2, "scientific name");
        ResultSet rs = taxID.executeQuery();
        if (rs.next()) {
            taxon_id = rs.getInt(1);
            TaxonSQL.attemptClose(rs);
            TaxonSQL.attemptClose(taxID);
            return taxon_id;
        }
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(taxID);
        throw new BioException("The database does not contain a taxon named " + scientificName + ".");
    }

    public static Taxon addName(Connection conn, Taxon taxon, String nameClass, String newName) throws BioException, SQLException, BioRuntimeException {
        if (nameClass.equals("scientific name") || nameClass.equals("common name")) {
            throw new BioException("There can only be one " + nameClass + ".");
        }
        PreparedStatement insert = conn.prepareStatement("INSERT INTO taxon_name (taxon_id, name, name_class) VALUES (?, ?, ?)");
        try {
            insert.setInt(1, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(taxon)));
            insert.setString(2, newName);
            insert.setString(3, nameClass);
            insert.executeUpdate();
        }
        catch (BioException exc) {
            throw exc;
        }
        catch (SQLException exc) {
            throw exc;
        }
        finally {
            TaxonSQL.attemptClose(insert);
        }
        return TaxonSQL.getTaxon(conn, taxon.getScientificName());
    }

    public static Taxon removeName(Connection conn, DBHelper helper, Taxon taxon, String nameClass, String oldName) throws BioException, SQLException {
        if (nameClass.equals("scientific name")) {
            throw new BioException("You can't delete the " + nameClass);
        }
        PreparedStatement delete = conn.prepareStatement("DELETE FROM taxon_name WHERE  name_class LIKE ? AND        name LIKE ?");
        delete.setString(1, nameClass);
        delete.setString(2, oldName);
        delete.executeUpdate();
        TaxonSQL.attemptClose(delete);
        return TaxonSQL.getTaxon(conn, taxon.getScientificName());
    }

    public static Stack getChildrenOf(Connection conn, String scientificName) throws BioException {
        Stack<Taxon> children = new Stack<Taxon>();
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        try {
            ps = conn.prepareStatement("SELECT taxon.taxon_id FROM   taxon, taxon_name WHERE  taxon_name.taxon_id = taxon.taxon_id     AND       taxon_name.name_class LIKE 'scientific%' AND       parent_taxon_id = ? ORDER BY taxon_name.name DESC");
            ps.setInt(1, TaxonSQL.getTaxonID(conn, scientificName));
            rs = ps.executeQuery();
            while (rs.next()) {
                ps2 = conn.prepareStatement("SELECT name             FROM   taxon_name       WHERE  taxon_id = ? AND        name_class LIKE 'scientific%'");
                ps2.setInt(1, rs.getInt(1));
                rs2 = ps2.executeQuery();
                if (!rs2.next()) continue;
                children.push(TaxonSQL.getTaxon(conn, rs2.getString(1)));
                if (!rs2.wasNull()) continue;
                children.pop();
            }
        }
        catch (SQLException exc) {
            try {
                throw new BioException(exc);
            }
            catch (Throwable throwable) {
                TaxonSQL.attemptClose(ps);
                TaxonSQL.attemptClose(rs);
                TaxonSQL.attemptClose(ps2);
                TaxonSQL.attemptClose(rs2);
                throw throwable;
            }
        }
        TaxonSQL.attemptClose(ps);
        TaxonSQL.attemptClose(rs);
        TaxonSQL.attemptClose(ps2);
        TaxonSQL.attemptClose(rs2);
        return children;
    }

    public static Stack getChildrenOf(Connection conn, Taxon t) throws BioException {
        String tName = t.getScientificName();
        if (tName.toLowerCase().equals("root") && t.getAnnotation() != null && t.getAnnotation().containsProperty(EbiFormat.PROPERTY_TAXON_NAMES) && ((Map)t.getAnnotation().getProperty(EbiFormat.PROPERTY_TAXON_NAMES)).containsKey("scientific name")) {
            tName = ((Map)t.getAnnotation().getProperty(EbiFormat.PROPERTY_TAXON_NAMES)).get("scientific name").toString();
        }
        return TaxonSQL.getChildrenOf(conn, tName);
    }

    public static void setRank(Connection conn, Taxon tdb, String rank) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SET node_rank = ? WHERE taxon_id = ?");
            ps.setString(1, rank);
            ps.setInt(2, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void removeRank(Connection conn, DBHelper helper, Taxon tdb) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SET node_rank = NULL WHERE taxon_id = ?");
            ps.setInt(1, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void setGeneticCodeID(Connection conn, Taxon tdb, int id) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SET genetic_code = ? WHERE taxon_id = ?");
            ps.setInt(1, id);
            ps.setInt(2, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void removeGeneticCodeID(Connection conn, DBHelper helper, Taxon tdb) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SET genetic_code = NULL WHERE taxon_id = ?");
            ps.setInt(1, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void setMitochondrialGeneticCodeID(Connection conn, Taxon tdb, int id) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SET mito_genetic_code = ? WHERE taxon_id = ?");
            ps.setInt(1, id);
            ps.setInt(2, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void removeMitochondrialGeneticCodeID(Connection conn, DBHelper helper, Taxon tdb) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SET mito_genetic_code = NULL WHERE taxon_id = ?");
            ps.setInt(1, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void setLeftValue(Connection conn, Taxon tdb, int left) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SET left_value = ? WHERE taxon_id = ?");
            ps.setInt(1, left);
            ps.setInt(2, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void removeLeftValue(Connection conn, DBHelper helper, Taxon tdb) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SEQ left_value = NULL WHERE taxon_id = ?");
            ps.setInt(1, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void setRightValue(Connection conn, Taxon tdb, int right) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SET right_value = ? WHERE taxon_id = ?");
            ps.setInt(1, right);
            ps.setInt(2, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void removeRightValue(Connection conn, DBHelper helper, Taxon tdb) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SEQ right_value = NULL WHERE taxon_id = ?");
            ps.setInt(1, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(tdb)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    public static void setParent(Connection conn, Taxon child, Taxon parent) throws BioRuntimeException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("UPDATE taxon SET parent_taxon_id = ? WHERE taxon_id = ?");
            ps.setInt(1, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(parent)));
            ps.setInt(2, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(child)));
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            throw new BioRuntimeException(exc);
        }
        catch (BioException exc) {
            throw new BioRuntimeException(exc);
        }
        finally {
            TaxonSQL.attemptClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void automaticUpdate(Connection conn, DBHelper helper, TaxonFactory factory, File delnodes, File merged) throws IOException {
        String[] line;
        BufferedReader br = new BufferedReader(new FileReader(delnodes));
        Set ids = TaxonSQL.NCBIids(conn);
        while (br.ready()) {
            line = br.readLine().split("\t")[0];
            if (!ids.contains(line)) continue;
            try {
                TaxonSQL.removeTaxon(conn, Integer.parseInt((String)line), helper);
                ids.remove(line);
            }
            catch (NumberFormatException exc1) {
                exc1.printStackTrace();
            }
            catch (BioRuntimeException exc1) {
                exc1.printStackTrace();
            }
            catch (BioException exc1) {
                exc1.printStackTrace();
            }
            catch (SQLException exc) {
                exc.printStackTrace();
            }
        }
        br = new BufferedReader(new FileReader(merged));
        while (br.ready()) {
            line = br.readLine().split("\t");
            if (!ids.contains(line[0])) continue;
            if (ids.contains(line[2])) {
                try {
                    Taxon parent = TaxonSQL.getTaxon(conn, Integer.parseInt(line[2]));
                    Stack children = TaxonSQL.getChildrenOf(conn, TaxonSQL.getTaxon(conn, Integer.parseInt(line[0])));
                    while (!children.isEmpty()) {
                        TaxonSQL.setParent(conn, (Taxon)children.pop(), parent);
                    }
                    PreparedStatement ps = conn.prepareStatement("UPDATE bioentry SET taxon_id = ? WHERE taxon_id = ?");
                    ps.setInt(1, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(parent)));
                    ps.setInt(2, TaxonSQL.getTaxonID(conn, TaxonSQL.getRealScientificName(TaxonSQL.getTaxon(conn, Integer.parseInt(line[0])))));
                    ps.executeUpdate();
                    ps.close();
                }
                catch (NumberFormatException exc1) {
                    exc1.printStackTrace();
                }
                catch (BioRuntimeException exc1) {
                    exc1.printStackTrace();
                }
                catch (BioException exc1) {
                    exc1.printStackTrace();
                }
                catch (SQLException exc) {
                    exc.printStackTrace();
                }
            }
            try {
                TaxonSQL.removeTaxon(conn, Integer.parseInt(line[0]), helper);
            }
            catch (NumberFormatException exc2) {
                exc2.printStackTrace();
            }
            catch (BioRuntimeException exc2) {
                exc2.printStackTrace();
            }
            catch (BioException exc2) {
                exc2.printStackTrace();
            }
            catch (SQLException exc) {
                exc.printStackTrace();
            }
        }
        try {
            Iterator i = TaxonSQL.ids(conn).iterator();
            while (i.hasNext()) {
                String elem;
                Iterator k;
                String key;
                Taxon tDB = TaxonSQL.getTaxon(conn, (Integer)i.next());
                Taxon tFA = factory.search(TaxonSQL.getRealScientificName(tDB));
                boolean change = false;
                if (tFA == null && tDB.getAnnotation().containsProperty(EbiFormat.PROPERTY_NCBI_TAXON)) {
                    tFA = factory.search(tDB.getAnnotation().getProperty(EbiFormat.PROPERTY_NCBI_TAXON));
                }
                if (tFA == null) continue;
                if (tFA.getScientificName() != null && !tFA.getScientificName().equals(TaxonSQL.getRealScientificName(tDB))) {
                    try {
                        TaxonSQL.setScientificName(conn, tDB, tFA.getScientificName());
                    }
                    catch (SQLException exc2) {
                        exc2.printStackTrace();
                    }
                }
                if (tFA.getCommonName() != null) {
                    if (tDB.getCommonName() == null) {
                        change = true;
                    } else if (!tDB.getCommonName().equals(tFA.getCommonName())) {
                        change = true;
                    }
                    if (change) {
                        try {
                            TaxonSQL.setCommonName(conn, tDB, tFA.getCommonName());
                        }
                        catch (BioException exc1) {
                            exc1.printStackTrace();
                        }
                        catch (SQLException exc) {
                            exc.printStackTrace();
                        }
                        finally {
                            change = false;
                        }
                    }
                } else if (tDB.getCommonName() != null) {
                    try {
                        TaxonSQL.removeName(conn, helper, tDB, "common name", tDB.getCommonName());
                    }
                    catch (BioException exc1) {
                        exc1.printStackTrace();
                    }
                    catch (SQLException exc) {
                        exc.printStackTrace();
                    }
                }
                Annotation annoFA = tFA.getAnnotation();
                Annotation annoDB = tDB.getAnnotation();
                if (annoFA.containsProperty("rank")) {
                    if (!annoDB.containsProperty("rank")) {
                        change = true;
                    } else if (!annoDB.getProperty("rank").equals(annoFA.getProperty("rank"))) {
                        change = true;
                    }
                    if (change) {
                        TaxonSQL.setRank(conn, tDB, annoFA.getProperty("rank").toString());
                    }
                    change = false;
                } else if (annoDB.containsProperty("rank")) {
                    TaxonSQL.removeRank(conn, helper, tDB);
                }
                if (annoFA.containsProperty("genetic code id")) {
                    if (!annoDB.containsProperty("genetic code id")) {
                        change = true;
                    } else if (!annoDB.getProperty("genetic code id").equals(annoFA)) {
                        change = true;
                    }
                    if (change) {
                        TaxonSQL.setGeneticCodeID(conn, tDB, Integer.parseInt(annoFA.getProperty("genetic code id").toString()));
                    }
                    change = false;
                } else if (annoDB.containsProperty("genetic code id")) {
                    TaxonSQL.removeGeneticCodeID(conn, helper, tDB);
                }
                if (annoFA.containsProperty("mitochondrial genetic code id")) {
                    if (!annoDB.containsProperty("mitochondrial genetic code id")) {
                        change = true;
                    } else if (!annoDB.getProperty("mitochondrial genetic code id").equals(annoFA.getProperty("mitochondrial genetic code id"))) {
                        change = true;
                    }
                    if (change) {
                        TaxonSQL.setMitochondrialGeneticCodeID(conn, tDB, Integer.parseInt(annoFA.getProperty("mitochondrial genetic code id").toString()));
                    }
                    change = false;
                } else if (annoDB.containsProperty("mitochondrial genetic code id")) {
                    TaxonSQL.removeMitochondrialGeneticCodeID(conn, helper, tDB);
                }
                if (annoFA.containsProperty("left value")) {
                    if (!annoDB.containsProperty("left value")) {
                        change = true;
                    } else if (!annoDB.getProperty("left value").equals(annoFA.getProperty("left value"))) {
                        change = true;
                    }
                    if (change) {
                        TaxonSQL.setLeftValue(conn, tDB, Integer.parseInt(annoFA.getProperty("left value").toString()));
                    }
                    change = false;
                } else if (annoDB.containsProperty("left value")) {
                    TaxonSQL.removeLeftValue(conn, helper, tDB);
                }
                if (annoFA.containsProperty("right value")) {
                    if (!annoDB.containsProperty("right value")) {
                        change = true;
                    } else if (!annoDB.getProperty("right value").equals(annoFA.getProperty("right value"))) {
                        change = true;
                    }
                    if (change) {
                        TaxonSQL.setRightValue(conn, tDB, Integer.parseInt(annoFA.getProperty("right value").toString()));
                    }
                    change = false;
                } else if (annoDB.containsProperty("right value")) {
                    TaxonSQL.removeRightValue(conn, helper, tDB);
                }
                if (!annoFA.containsProperty(EbiFormat.PROPERTY_TAXON_NAMES) || !(annoFA.getProperty(EbiFormat.PROPERTY_TAXON_NAMES) instanceof Map)) continue;
                Map names = (Map)annoFA.getProperty(EbiFormat.PROPERTY_TAXON_NAMES);
                Map dbNames = (Map)annoDB.getProperty(EbiFormat.PROPERTY_TAXON_NAMES);
                Iterator j = dbNames.keySet().iterator();
                while (j.hasNext()) {
                    key = j.next().toString();
                    if (dbNames.get(key) instanceof Set) {
                        if (!names.containsKey(key)) {
                            k = ((Set)dbNames.get(key)).iterator();
                            while (k.hasNext()) {
                                try {
                                    elem = k.next().toString();
                                    TaxonSQL.removeName(conn, helper, tDB, key, elem);
                                }
                                catch (BioException exc2) {
                                    exc2.printStackTrace();
                                }
                                catch (SQLException exc) {
                                    exc.printStackTrace();
                                }
                            }
                            continue;
                        }
                        k = ((Set)dbNames.get(key)).iterator();
                        while (k.hasNext()) {
                            elem = k.next().toString();
                            if (names.get(key) instanceof Set) {
                                if (((Set)names.get(key)).contains(elem)) continue;
                                try {
                                    TaxonSQL.removeName(conn, helper, tDB, key, elem);
                                }
                                catch (BioException exc3) {
                                    exc3.printStackTrace();
                                }
                                catch (SQLException exc) {
                                    exc.printStackTrace();
                                }
                                continue;
                            }
                            if (names.get(key).equals(elem)) continue;
                            try {
                                TaxonSQL.removeName(conn, helper, tDB, key, elem);
                            }
                            catch (BioException exc2) {
                                exc2.printStackTrace();
                            }
                            catch (SQLException exc) {
                                exc.printStackTrace();
                            }
                        }
                        continue;
                    }
                    if (!names.containsKey(key)) {
                        change = true;
                    } else if (names.get(key) instanceof Set) {
                        if (!((Set)names.get(key)).contains(dbNames.get(key))) {
                            change = true;
                        }
                    } else if (!names.get(key).equals(dbNames.get(key))) {
                        change = true;
                    }
                    if (change) {
                        try {
                            TaxonSQL.removeName(conn, helper, tDB, key, dbNames.get(key).toString());
                        }
                        catch (BioException exc2) {
                            exc2.printStackTrace();
                        }
                    }
                    change = false;
                }
                dbNames = (Map)TaxonSQL.getTaxon(conn, TaxonSQL.getRealScientificName(tDB)).getAnnotation().getProperty(EbiFormat.PROPERTY_TAXON_NAMES);
                j = names.keySet().iterator();
                while (j.hasNext()) {
                    key = j.next().toString();
                    if (names.get(key) instanceof Set) {
                        k = ((Set)names.get(key)).iterator();
                        while (k.hasNext()) {
                            elem = k.next().toString();
                            if (!dbNames.containsKey(key)) {
                                change = true;
                            } else if (dbNames.get(key) instanceof Set) {
                                if (!((Set)dbNames.get(key)).contains(elem)) {
                                    change = true;
                                }
                            } else if (!dbNames.get(key).equals(elem)) {
                                change = true;
                            }
                            if (change) {
                                try {
                                    TaxonSQL.addName(conn, tDB, key, elem);
                                }
                                catch (BioRuntimeException exc3) {
                                    exc3.printStackTrace();
                                }
                                catch (BioException exc3) {
                                    exc3.printStackTrace();
                                }
                                catch (SQLException exc) {
                                    exc.printStackTrace();
                                }
                            }
                            change = false;
                        }
                        continue;
                    }
                    if (dbNames.containsKey(key)) continue;
                    try {
                        TaxonSQL.addName(conn, tDB, key, names.get(key).toString());
                    }
                    catch (BioRuntimeException exc2) {
                        exc2.printStackTrace();
                    }
                    catch (BioException exc2) {
                        exc2.printStackTrace();
                    }
                    catch (SQLException exc) {
                        exc.printStackTrace();
                    }
                }
            }
        }
        catch (NumberFormatException exc) {
            exc.printStackTrace();
        }
        catch (BioRuntimeException exc) {
            exc.printStackTrace();
        }
        catch (NoSuchElementException exc) {
            exc.printStackTrace();
        }
        catch (SQLException exc) {
            exc.printStackTrace();
        }
    }
}

