/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class NewAssembledSymbolList
extends AbstractSymbolList {
    private boolean autoLength = true;
    private int length = 0;
    private SortedMap components;
    private List componentList;
    private final Symbol noninformativeSymbol = DNATools.n();
    private Location lastLocation;
    private int NOTFOUND = -1;

    public NewAssembledSymbolList() {
        this.components = new TreeMap(Location.naturalOrder);
        this.componentList = new ArrayList();
        this.lastLocation = Location.empty;
    }

    public void setLength(int len) {
        this.autoLength = false;
        this.length = len;
    }

    public void putComponent(ComponentFeature f) {
        RangeLocation newLoc = new RangeLocation(f.getLocation().getMin(), f.getLocation().getMax());
        int startIdx = this.idxRightOfPoint(f.getLocation().getMin());
        if (startIdx == this.NOTFOUND) {
            this.components.put(f.getLocation(), new TranslatedSymbolList(f));
            this.recreateList();
            return;
        }
        for (int i = startIdx; i < this.componentList.size(); ++i) {
            Location thisLoc = (Location)this.componentList.get(i);
            if (newLoc.getMin() > thisLoc.getMax()) break;
            if (newLoc.contains(thisLoc)) {
                this.components.remove(thisLoc);
                continue;
            }
            if (thisLoc.contains(newLoc)) {
                return;
            }
            if (newLoc.overlaps(thisLoc)) {
                if (newLoc.getMin() < thisLoc.getMin()) {
                    newLoc = new RangeLocation(newLoc.getMin(), thisLoc.getMin() - 1);
                    continue;
                }
                newLoc = new RangeLocation(thisLoc.getMax() + 1, newLoc.getMax());
                continue;
            }
            this.components.put(newLoc, new TranslatedSymbolList(f));
            this.recreateList();
            return;
        }
        this.components.put(newLoc, new TranslatedSymbolList(f));
        this.recreateList();
    }

    private void recreateList() {
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    public void removeComponent(ComponentFeature f) {
        for (int i = 0; i < this.componentList.size(); ++i) {
            Object value;
            Location leftLoc;
            Location leftCFLoc;
            Location loc = (Location)this.componentList.get(i);
            TranslatedSymbolList sl = (TranslatedSymbolList)this.components.get(loc);
            if (sl.getFeature() != f) continue;
            this.componentList.remove(i);
            int minExtensionFromRight = loc.getMin();
            if (i != 0 && (leftCFLoc = (Location)this.components.get(leftLoc = (Location)this.componentList.get(i - 1))).getMax() > loc.getMin()) {
                int newRightLimitOnLeftRange = Math.min(leftCFLoc.getMax(), loc.getMax());
                RangeLocation newLeftLoc = new RangeLocation(leftLoc.getMin(), newRightLimitOnLeftRange);
                this.componentList.remove(i - 1);
                this.componentList.add(i - 1, newLeftLoc);
                value = this.components.remove(leftLoc);
                this.components.put(newLeftLoc, value);
                minExtensionFromRight = newRightLimitOnLeftRange + 1;
            }
            if (i == this.componentList.size()) continue;
            Location rightLoc = (Location)this.componentList.get(i);
            Location rightCFLoc = (Location)this.components.get(rightLoc);
            if (loc.getMax() <= rightCFLoc.getMin() || minExtensionFromRight >= rightLoc.getMin()) continue;
            int newLeftLimitOnRightRange = Math.max(minExtensionFromRight, rightCFLoc.getMin());
            RangeLocation newRightLoc = new RangeLocation(newLeftLimitOnRightRange, rightLoc.getMax());
            this.componentList.remove(i);
            this.componentList.add(i, newRightLoc);
            value = this.components.remove(rightLoc);
            this.components.put(newRightLoc, value);
        }
    }

    private SymbolList getComponentSymbols(Location loc) {
        return (SymbolList)this.components.get(loc);
    }

    public Set getComponentLocationSet() {
        TreeSet newSet = new TreeSet(Location.naturalOrder);
        newSet.addAll(this.componentList);
        return newSet;
    }

    private Location locationOfPoint(int p) {
        if (this.lastLocation.contains(p)) {
            return this.lastLocation;
        }
        int first = 0;
        int last = this.componentList.size() - 1;
        while (first <= last) {
            int check = (first + last) / 2;
            Location checkL = (Location)this.componentList.get(check);
            if (checkL.contains(p)) {
                this.lastLocation = checkL;
                return checkL;
            }
            if (p < checkL.getMin()) {
                last = check - 1;
                continue;
            }
            first = check + 1;
        }
        return null;
    }

    private int idxRightOfPoint(int p) {
        int first = 0;
        int last = this.componentList.size() - 1;
        int check = 0;
        Location checkL = null;
        while (first <= last) {
            check = (first + last) / 2;
            checkL = (Location)this.componentList.get(check);
            if (checkL.contains(p)) {
                return check;
            }
            if (p < checkL.getMin()) {
                last = check - 1;
                continue;
            }
            first = check + 1;
        }
        try {
            if (p < checkL.getMin()) {
                return check;
            }
            int nextIdx = check + 1;
            if (nextIdx < this.componentList.size() && p < ((Location)this.componentList.get(nextIdx)).getMin()) {
                return nextIdx;
            }
            return this.NOTFOUND;
        }
        catch (NullPointerException npe) {
            return this.NOTFOUND;
        }
    }

    public Alphabet getAlphabet() {
        return DNATools.getDNA();
    }

    public int length() {
        if (this.autoLength) {
            int componentCount = this.componentList.size();
            if (componentCount == 0) {
                return 0;
            }
            Location last = (Location)this.componentList.get(componentCount - 1);
            return last.getMax();
        }
        return this.length;
    }

    public Symbol symbolAt(int pos) {
        Location l = this.locationOfPoint(pos);
        if (l == null) {
            return this.noninformativeSymbol;
        }
        SymbolList syms = this.getComponentSymbols(l);
        return syms.symbolAt(pos);
    }

    public SymbolList subList(int start, int end) {
        Location l = this.locationOfPoint(start);
        if (l != null && l.contains(end)) {
            SymbolList symbols = this.getComponentSymbols(l);
            return symbols.subList(start, end);
        }
        return super.subList(start, end);
    }

    private class TranslatedSymbolList
    extends AbstractSymbolList {
        ComponentFeature cf;
        int translation;
        int length;
        SymbolList underlyingSymList;

        private TranslatedSymbolList(ComponentFeature cf) {
            this.cf = cf;
            this.translation = cf.getStrand() == StrandedFeature.POSITIVE ? cf.getLocation().getMin() - cf.getComponentLocation().getMin() : cf.getLocation().getMax() + cf.getComponentLocation().getMin();
            this.underlyingSymList = cf.getComponentSequence();
            this.length = this.underlyingSymList.length();
        }

        public Symbol symbolAt(int i) {
            try {
                if (this.cf.getStrand() == StrandedFeature.POSITIVE) {
                    int idx = i - this.translation;
                    if (idx < 1 || idx > this.length) {
                        return NewAssembledSymbolList.this.noninformativeSymbol;
                    }
                    return this.underlyingSymList.symbolAt(idx);
                }
                int idx = this.translation - i;
                if (idx < 1 || idx > this.length) {
                    return NewAssembledSymbolList.this.noninformativeSymbol;
                }
                return DNATools.complement(this.underlyingSymList.symbolAt(idx));
            }
            catch (IllegalSymbolException ise) {
                return NewAssembledSymbolList.this.noninformativeSymbol;
            }
        }

        public Alphabet getAlphabet() {
            return DNATools.getDNA();
        }

        public int length() {
            return this.cf.getLocation().getMax();
        }

        public ComponentFeature getFeature() {
            return this.cf;
        }
    }
}

