/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.FeatureTableParser;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;
import org.biojava.utils.ParseErrorEvent;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;

public class GenbankProcessor
extends SequenceBuilderFilter
implements ParseErrorSource {
    public static final String PROPERTY_GENBANK_ACCESSIONS = "genbank_accessions";
    private boolean mBadFeature = false;
    private Vector mListeners = new Vector();
    protected FeatureTableParser features;
    private List accessions = new ArrayList();

    public GenbankProcessor(SequenceBuilder theDelegate, String theSource) {
        super(theDelegate);
        this.features = new FeatureTableParser(this, theSource);
    }

    public GenbankProcessor(SequenceBuilder theDelegate) {
        super(theDelegate);
        this.features = new FeatureTableParser(this, "GenBank");
    }

    public void endSequence() throws ParseException {
        String uri = "";
        if (this.accessions.size() > 0) {
            uri = "urn:sequence/genbank:" + (String)this.accessions.get(0);
            this.getDelegate().addSequenceProperty(PROPERTY_GENBANK_ACCESSIONS, this.accessions);
        }
        this.getDelegate().setURI(uri);
        this.getDelegate().endSequence();
    }

    public void addSequenceProperty(Object key, Object value) throws ParseException {
        try {
            if (this.mBadFeature) {
                String featureLine = value.toString();
                if (key.equals("FT") && featureLine.charAt(0) != ' ') {
                    this.mBadFeature = false;
                    this.features.startFeature(featureLine.substring(0, 16).trim());
                    this.features.featureData(featureLine.substring(16));
                }
            } else {
                if (this.features.inFeature() && !key.equals("FT")) {
                    this.features.endFeature();
                }
                if (key.equals("FT")) {
                    String featureLine = value.toString();
                    if (featureLine.charAt(0) != ' ') {
                        if (this.features.inFeature()) {
                            this.features.endFeature();
                        }
                        this.features.startFeature(featureLine.substring(0, 16).trim());
                    }
                    this.features.featureData(featureLine.substring(16));
                } else {
                    this.getDelegate().addSequenceProperty(key, value);
                    if (key.equals("ACCESSION")) {
                        this.accessions.add(value);
                    } else if (key.equals("LOCUS")) {
                        this.getDelegate().setName((String)value);
                        this.features.setSeqID((String)value);
                    }
                }
            }
        }
        catch (BioException ex) {
            this.mBadFeature = true;
            ParseErrorEvent offendingLineEvent = new ParseErrorEvent(this, "This line could not be parsed: " + value.toString());
            this.notifyParseErrorEvent(offendingLineEvent);
        }
        catch (IndexOutOfBoundsException ex) {
            this.mBadFeature = true;
            ParseErrorEvent offendingLineEvent = new ParseErrorEvent(this, "From must be less than To: " + value.toString());
            this.notifyParseErrorEvent(offendingLineEvent);
        }
    }

    public synchronized void addParseErrorListener(ParseErrorListener theListener) {
        if (!this.mListeners.contains(theListener)) {
            this.mListeners.addElement(theListener);
        }
    }

    public synchronized void removeParseErrorListener(ParseErrorListener theListener) {
        if (this.mListeners.contains(theListener)) {
            this.mListeners.removeElement(theListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyParseErrorEvent(ParseErrorEvent theEvent) {
        Vector listeners;
        GenbankProcessor genbankProcessor = this;
        synchronized (genbankProcessor) {
            listeners = (Vector)this.mListeners.clone();
        }
        for (int index = 0; index < listeners.size(); ++index) {
            ParseErrorListener client = (ParseErrorListener)listeners.elementAt(index);
            client.BadLineParsed(theEvent);
        }
    }

    public static class Factory
    implements SequenceBuilderFactory,
    Serializable {
        private SequenceBuilderFactory delegateFactory;

        public Factory(SequenceBuilderFactory theDelegate) {
            this.delegateFactory = theDelegate;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new GenbankProcessor(this.delegateFactory.makeSequenceBuilder());
        }

        public SequenceBuilder makeSequenceBuilder(String theSource) {
            return new GenbankProcessor(this.delegateFactory.makeSequenceBuilder(), theSource);
        }
    }
}

