/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.biojava.bio.structure.PDBRecord;

public class PDBHeader
implements PDBRecord {
    String method;
    String title;
    String description;
    String idCode;
    String classification;
    Date depDate = new Date(0L);
    Date modDate = new Date(0L);
    String technique;
    float resolution = 99.0f;
    public static final float DEFAULT_RESOLUTION = 99.0f;
    private Long id;
    public static final String newline = System.getProperty("line.separator");
    DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            Class<?> c = Class.forName("org.biojava.bio.structure.PDBHeader");
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Object o;
                Method m = methods[i];
                String name = m.getName();
                if (!name.substring(0, 3).equals("get") || name.equals("getClass") || (o = m.invoke((Object)this, new Object[0])) == null) continue;
                buf.append(name.substring(3, name.length()));
                buf.append(": " + o + " ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public String toPDB() {
        StringBuffer buf = new StringBuffer();
        this.toPDB(buf);
        return buf.toString();
    }

    public void toPDB(StringBuffer buf) {
        this.printHeader(buf);
        this.printTitle(buf);
        this.printExpdata(buf);
        this.printResolution(buf);
    }

    private void printResolution(StringBuffer buf) {
        if (this.getResolution() == 99.0f) {
            return;
        }
        DecimalFormat d2 = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        d2.setMaximumIntegerDigits(2);
        d2.setMinimumFractionDigits(2);
        d2.setMaximumFractionDigits(2);
        buf.append("REMARK   2 RESOLUTION. ");
        String x = d2.format(this.resolution);
        buf.append(x);
        buf.append(" ANGSTROMS.");
        this.fillLine(buf, 34 + x.length());
        buf.append(newline);
    }

    private void printExpdata(StringBuffer buf) {
        String exp = this.getTechnique();
        if (exp == null || exp.length() == 0) {
            return;
        }
        buf.append("EXPDTA    ");
        buf.append(exp);
        int l = exp.length() + 10;
        this.fillLine(buf, l);
        buf.append(newline);
    }

    private void fillLine(StringBuffer buf, int currentPos) {
        for (int l = currentPos; l < 67; ++l) {
            buf.append(" ");
        }
    }

    private void printHeader(StringBuffer buf) {
        String classification = this.getClassification();
        if (classification == null || classification.length() == 0) {
            return;
        }
        buf.append("HEADER    ");
        buf.append(classification);
        buf.append(" ");
        for (int l = classification.length() + 10; l < 49; ++l) {
            buf.append(" ");
        }
        Date d = this.getDepDate();
        if (d != null) {
            buf.append(this.dateFormat.format(this.getDepDate()));
        } else {
            buf.append("         ");
        }
        buf.append("   ");
        String id = this.getIdCode();
        if (id != null) {
            buf.append(this.getIdCode());
            buf.append(" ");
        } else {
            buf.append("    ");
        }
        buf.append(newline);
    }

    private void printTitle(StringBuffer buf) {
        int l;
        String title = this.getTitle();
        if (title == null || title.trim().length() == 0) {
            return;
        }
        if (title.length() < 58) {
            buf.append("TITLE     ");
            buf.append(title);
            buf.append(newline);
            return;
        }
        String thisLine = "";
        int count = 1;
        while (title.length() > 57) {
            for (int i = 57; i > -1; --i) {
                char c = title.charAt(i);
                if (c != ' ') continue;
                thisLine = title.substring(0, i + 1);
                title = title.substring(i);
                break;
            }
            buf.append("TITLE    ");
            if (count > 1) {
                buf.append(count);
            } else {
                buf.append(" ");
            }
            buf.append(thisLine);
            for (l = thisLine.length() + 10; l < 67; ++l) {
                buf.append(" ");
            }
            buf.append(newline);
            ++count;
        }
        if (title.trim().length() > 0) {
            buf.append("TITLE    ");
            buf.append(count);
            buf.append(title);
            l = title.length() + 10;
            this.fillLine(buf, l);
            buf.append(newline);
        }
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public boolean equals(PDBHeader other) {
        try {
            Class<?> c = Class.forName("org.biojava.bio.structure.PDBHeader");
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                String name = m.getName();
                if (!name.substring(0, 3).equals("get") || name.equals("getClass")) continue;
                Object a = m.invoke((Object)this, new Object[0]);
                Object b = m.invoke((Object)other, new Object[0]);
                if (a == null) {
                    if (b == null) continue;
                    System.out.println(name + " a is null, where other is " + b);
                    return false;
                }
                if (b == null) {
                    System.out.println(name + " other is null, where a is " + a);
                    return false;
                }
                if (a.equals(b)) continue;
                System.out.println("mismatch with " + name + " >" + a + "< >" + b + "<");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getIdCode() {
        return this.idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public Date getDepDate() {
        return this.depDate;
    }

    public void setDepDate(Date depDate) {
        this.depDate = depDate;
    }

    public String getTechnique() {
        return this.technique;
    }

    public void setTechnique(String technique) {
        this.technique = technique;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void setResolution(float resolution) {
        this.resolution = resolution;
    }

    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date modDate) {
        this.modDate = modDate;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

