/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.jama.Matrix;
import org.biojava.bio.structure.jama.SingularValueDecomposition;

public class SVDSuperimposer {
    Matrix rot;
    Matrix tran;
    Matrix centroidA;
    Matrix centroidB;

    public SVDSuperimposer(Atom[] atomSet1, Atom[] atomSet2) throws StructureException {
        if (atomSet1.length != atomSet2.length) {
            throw new StructureException("The two atom sets are not of same length!");
        }
        Atom cena = Calc.getCentroid(atomSet1);
        Atom cenb = Calc.getCentroid(atomSet2);
        double[][] centAcoords = new double[][]{{cena.getX(), cena.getY(), cena.getZ()}};
        this.centroidA = new Matrix(centAcoords);
        double[][] centBcoords = new double[][]{{cenb.getX(), cenb.getY(), cenb.getZ()}};
        this.centroidB = new Matrix(centBcoords);
        Atom[] ats1 = Calc.centerAtoms(atomSet1);
        Atom[] ats2 = Calc.centerAtoms(atomSet2);
        double[][] coordSet1 = new double[ats1.length][3];
        double[][] coordSet2 = new double[ats2.length][3];
        for (int i = 0; i < ats1.length; ++i) {
            coordSet1[i] = ats1[i].getCoords();
            coordSet2[i] = ats2[i].getCoords();
        }
        this.calculate(coordSet1, coordSet2);
    }

    private void calculate(double[][] coordSet1, double[][] coordSet2) {
        Matrix a = new Matrix(coordSet1);
        Matrix b = new Matrix(coordSet2);
        Matrix b_trans = b.transpose();
        Matrix corr = b_trans.times(a);
        SingularValueDecomposition svd = corr.svd();
        Matrix u = svd.getU();
        Matrix vt = svd.getV();
        Matrix vt_orig = (Matrix)vt.clone();
        Matrix u_transp = u.transpose();
        Matrix rot_nottrans = vt.times(u_transp);
        this.rot = rot_nottrans.transpose();
        double det = this.rot.det();
        if (det < 0.0) {
            vt = vt_orig.transpose();
            vt.set(2, 0, 0.0 - vt.get(2, 0));
            vt.set(2, 1, 0.0 - vt.get(2, 1));
            vt.set(2, 2, 0.0 - vt.get(2, 2));
            Matrix nv_transp = vt.transpose();
            rot_nottrans = nv_transp.times(u_transp);
            this.rot = rot_nottrans.transpose();
        }
        Matrix cb_tmp = this.centroidB.times(this.rot);
        this.tran = this.centroidA.minus(cb_tmp);
    }

    public static double getRMS(Atom[] atomSet1, Atom[] atomSet2) throws StructureException {
        if (atomSet1.length != atomSet2.length) {
            throw new StructureException("The two atom sets are not of same length!");
        }
        double sum = 0.0;
        for (int i = 0; i < atomSet1.length; ++i) {
            double d = Calc.getDistance(atomSet1[i], atomSet2[i]);
            sum += d * d;
        }
        double avd = sum / (double)atomSet1.length;
        return Math.sqrt(avd);
    }

    public Matrix getRotation() {
        return this.rot;
    }

    public Atom getTranslation() {
        AtomImpl a = new AtomImpl();
        a.setX(this.tran.get(0, 0));
        a.setY(this.tran.get(0, 1));
        a.setZ(this.tran.get(0, 2));
        return a;
    }

    public void printMatrix(Matrix m) {
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                System.out.print("\t" + m.get(i, j) + " ");
            }
            System.out.println("");
        }
    }
}

