/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.gui;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.gui.ProgressThreadDrawer;
import org.biojava.bio.structure.gui.util.AlignmentCalc;
import org.biojava.bio.structure.gui.util.PDBDirPanel;
import org.biojava.bio.structure.gui.util.PDBServerPanel;
import org.biojava.bio.structure.gui.util.PDBUploadPanel;

public class AlignmentGui
extends JFrame {
    private static final long serialVersionUID = 0L;
    public static Logger logger = Logger.getLogger("org.biojava.spice");
    JButton abortB;
    PDBDirPanel tab1;
    PDBUploadPanel tab2;
    PDBServerPanel tab3;
    Thread thread = null;
    AlignmentCalc alicalc;
    JTabbedPane tabPane;
    JProgressBar progress;

    public static void main(String[] args) {
        new AlignmentGui();
    }

    public AlignmentGui() {
        this.setTitle("Pairwise Structure Alignment");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JFrame frame = (JFrame)evt.getSource();
                frame.setVisible(false);
                frame.dispose();
            }
        });
        this.tab3 = new PDBServerPanel();
        this.tab1 = new PDBDirPanel();
        this.tab2 = new PDBUploadPanel();
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Fetch files from FTP server", null, this.tab3, "fetch files from remote");
        this.tabPane.addTab("From local directory", null, this.tab1, "find files in a local directory");
        this.tabPane.addTab("Upload files", null, this.tab2, "Upload files manually");
        AbstractAction action1 = new AbstractAction("Submit"){
            public static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent evt) {
                AlignmentGui.this.calcAlignment();
            }
        };
        JButton submitB = new JButton(action1);
        AbstractAction action3 = new AbstractAction("Abort"){
            public static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent evt) {
                AlignmentGui.this.abortCalc();
            }
        };
        this.abortB = new JButton(action3);
        this.abortB.setEnabled(false);
        AbstractAction action2 = new AbstractAction("Close"){
            public static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent evt) {
                AlignmentGui.this.abortCalc();
                AlignmentGui.this.dispose();
            }
        };
        JButton closeB = new JButton(action2);
        Box vBox = Box.createVerticalBox();
        Box hBox42 = Box.createHorizontalBox();
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(false);
        hBox42.add(Box.createGlue());
        hBox42.add(this.progress);
        vBox.add(hBox42);
        vBox.add(this.tabPane);
        Box hBox = Box.createHorizontalBox();
        hBox.add(submitB);
        hBox.add(this.abortB);
        hBox.add(closeB);
        vBox.add(hBox);
        this.getContentPane().add(vBox);
        this.pack();
        this.setVisible(true);
    }

    public void cleanUp() {
        if (this.alicalc != null) {
            this.alicalc.cleanup();
        }
    }

    private void calcAlignment() {
        int pos = this.tabPane.getSelectedIndex();
        JPanel tab = null;
        if (pos == 0) {
            tab = this.tab3;
        } else if (pos == 1) {
            tab = this.tab1;
        } else if (pos == 2) {
            tab = this.tab2;
        }
        try {
            Structure s1 = tab.getStructure1();
            Structure s2 = tab.getStructure2();
            if (s1 == null) {
                System.err.println("please define structure 1");
                return;
            }
            if (s2 == null) {
                System.err.println("please define structure 2");
                return;
            }
            this.alicalc = new AlignmentCalc(this, s1, s2);
            this.thread = new Thread(this.alicalc);
            this.thread.start();
            this.abortB.setEnabled(true);
            this.progress.setIndeterminate(true);
            ProgressThreadDrawer drawer = new ProgressThreadDrawer(this.progress);
            drawer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifyCalcFinished() {
        this.abortB.setEnabled(false);
        this.thread = null;
        this.progress.setIndeterminate(false);
        this.repaint();
    }

    private void abortCalc() {
        if (this.alicalc != null) {
            this.alicalc.interrupt();
        }
    }
}

