/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.gui;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.align.StrucAligParameters;
import org.biojava.bio.structure.align.StructurePairAligner;
import org.biojava.bio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.bio.structure.align.pairwise.FragmentPair;
import org.biojava.bio.structure.gui.JMatrixPanel;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava.bio.structure.jama.Matrix;

public class ScaleableMatrixPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -8082261434322968652L;
    JMatrixPanel mPanel = new JMatrixPanel();
    JSlider slider;
    JScrollPane scroll;

    public static void main(String[] args) {
        PDBFileReader pdbr = new PDBFileReader();
        pdbr.setAutoFetch(true);
        pdbr.setPath("/Users/andreas/WORK/PDB/");
        String pdb1 = "1buz";
        String pdb2 = "1ali";
        StructurePairAligner sc = new StructurePairAligner();
        StrucAligParameters params = new StrucAligParameters();
        params.setMaxIter(1);
        sc.setParams(params);
        try {
            Structure s1 = pdbr.getStructureById(pdb1);
            Structure s2 = pdbr.getStructureById(pdb2);
            System.out.println("aligning " + pdb1 + " vs. " + pdb2);
            System.out.println(s1);
            System.out.println();
            System.out.println(s2);
            sc.align(s1, s2);
            ScaleableMatrixPanel smp = new ScaleableMatrixPanel();
            JFrame frame = new JFrame();
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    JFrame f = (JFrame)e.getSource();
                    f.setVisible(false);
                    f.dispose();
                }
            });
            smp.setMatrix(sc.getDistMat());
            smp.setFragmentPairs(sc.getFragmentPairs());
            smp.setAlternativeAligs(sc.getAlignments());
            for (int i = 0; i < sc.getAlignments().length; ++i) {
                AlternativeAlignment aa = sc.getAlignments()[i];
                System.out.println(aa);
            }
            frame.getContentPane().add(smp);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ScaleableMatrixPanel() {
        Box vBox = Box.createVerticalBox();
        int RES_MIN = 1;
        int RES_MAX = 8;
        int RES_INIT = 1;
        this.slider = new JSlider(0, RES_MIN, RES_MAX, RES_INIT);
        this.slider.setInverted(false);
        this.slider.setPaintTicks(false);
        this.slider.setPaintLabels(false);
        this.slider.addChangeListener(this);
        this.slider.setPreferredSize(new Dimension(100, 15));
        vBox.add(this.slider);
        this.scroll = new JScrollPane(this.mPanel);
        vBox.add(this.scroll);
        this.setPreferredSize(new Dimension(400, 400));
        this.add(vBox);
        this.mPanel.setLayout(new BoxLayout(this.mPanel, 1));
        this.setLayout(new BoxLayout(this, 1));
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (source.getValueIsAdjusting()) {
            return;
        }
        this.mPanel.setScale(source.getValue());
        this.scroll.repaint();
        this.scroll.updateUI();
    }

    public Matrix getMatrix() {
        return this.mPanel.getMatrix();
    }

    public void setMatrix(Matrix matrix) {
        this.mPanel.setMatrix(matrix);
    }

    public FragmentPair[] getFragmentPairs() {
        return this.mPanel.getFragmentPairs();
    }

    public void setFragmentPairs(FragmentPair[] pairs) {
        this.mPanel.setFragmentPairs(pairs);
    }

    public AlternativeAlignment[] getAlternativeAligs() {
        return this.mPanel.getAlternativeAligs();
    }

    public void setAlternativeAligs(AlternativeAlignment[] aligs) {
        this.mPanel.setAlternativeAligs(aligs);
    }
}

