/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.DBRef;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.SSBond;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.utils.xml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConvert {
    Structure structure;
    boolean printConnections;

    public FileConvert(Structure struc) {
        this.structure = struc;
        this.printConnections = true;
    }

    private String alignRight(String input, int length) {
        int n = input.length();
        if (n >= length) {
            return input;
        }
        String spaces = "                           ";
        int diff = length - n;
        StringBuffer s = new StringBuffer();
        s.append(spaces.substring(0, diff));
        s.append(input);
        return s.toString();
    }

    private String alignLeft(String input, int length) {
        if (input.length() >= length) {
            return input;
        }
        String spaces = "                           ";
        input = input + spaces.substring(0, length - input.length());
        return input;
    }

    public boolean doPrintConnections() {
        return this.printConnections;
    }

    public void setPrintConnections(boolean printConnections) {
        this.printConnections = printConnections;
    }

    private String printPDBConnections() {
        String newline = System.getProperty("line.separator");
        StringBuffer str = new StringBuffer();
        ArrayList cons = (ArrayList)this.structure.getConnections();
        for (int cnr = 0; cnr < cons.size(); ++cnr) {
            HashMap con = (HashMap)cons.get(cnr);
            Integer as = (Integer)con.get("atomserial");
            String atomserial = "";
            String bond1 = "";
            String bond2 = "";
            String bond3 = "";
            String bond4 = "";
            String hyd1 = "";
            String hyd2 = "";
            String salt1 = "";
            String hyd3 = "";
            String hyd4 = "";
            String salt2 = "";
            if (con.containsKey("bond1")) {
                bond1 = con.get("bond1").toString();
            }
            if (con.containsKey("bond2")) {
                bond2 = con.get("bond2").toString();
            }
            if (con.containsKey("bond3")) {
                bond3 = con.get("bond3").toString();
            }
            if (con.containsKey("bond4")) {
                bond4 = con.get("bond4").toString();
            }
            if (con.containsKey("hyd1")) {
                hyd1 = con.get("hyd1").toString();
            }
            if (con.containsKey("hyd2")) {
                hyd2 = con.get("hyd2").toString();
            }
            if (con.containsKey("salt1")) {
                salt1 = con.get("salt1").toString();
            }
            if (con.containsKey("hyd3")) {
                hyd3 = con.get("hyd3").toString();
            }
            if (con.containsKey("hyd4")) {
                hyd4 = con.get("hyd4").toString();
            }
            if (con.containsKey("salt2")) {
                salt2 = con.get("salt2").toString();
            }
            atomserial = this.alignRight("" + as, 5);
            bond1 = this.alignRight(bond1, 5);
            bond2 = this.alignRight(bond2, 5);
            bond3 = this.alignRight(bond3, 5);
            bond4 = this.alignRight(bond4, 5);
            hyd1 = this.alignRight(hyd1, 5);
            hyd2 = this.alignRight(hyd2, 5);
            salt1 = this.alignRight(salt1, 5);
            hyd3 = this.alignRight(hyd3, 5);
            hyd4 = this.alignRight(hyd4, 5);
            salt2 = this.alignRight(salt2, 5);
            String connectLine = "CONECT" + atomserial + bond1 + bond2 + bond3 + bond4 + hyd1 + hyd2 + salt1 + hyd3 + hyd4 + salt2;
            str.append(connectLine + newline);
        }
        return str.toString();
    }

    public String toPDB() {
        String newline = System.getProperty("line.separator");
        StringBuffer str = new StringBuffer();
        DecimalFormat d3 = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        d3.setMaximumIntegerDigits(3);
        d3.setMinimumFractionDigits(3);
        d3.setMaximumFractionDigits(3);
        DecimalFormat d2 = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        d2.setMaximumIntegerDigits(2);
        d2.setMinimumFractionDigits(2);
        d2.setMaximumFractionDigits(2);
        PDBHeader header = this.structure.getPDBHeader();
        header.toPDB(str);
        for (SSBond ssbond : this.structure.getSSBonds()) {
            ssbond.toPDB(str);
            str.append(newline);
        }
        for (DBRef dbref : this.structure.getDBRefs()) {
            dbref.toPDB(str);
            str.append(newline);
        }
        int nrModels = this.structure.nrModels();
        if (this.structure.isNmr()) {
            str.append("EXPDTA    NMR, " + nrModels + " STRUCTURES" + newline);
        }
        for (int m = 0; m < nrModels; ++m) {
            List<Chain> model = this.structure.getModel(m);
            if (this.structure.isNmr()) {
                str.append("MODEL      " + (m + 1) + newline);
            }
            int nrChains = model.size();
            for (int c = 0; c < nrChains; ++c) {
                Chain chain = model.get(c);
                String chainID = chain.getName();
                int nrGroups = chain.getAtomLength();
                for (int h = 0; h < nrGroups; ++h) {
                    Group g = chain.getAtomGroup(h);
                    String type = g.getType();
                    String record = "";
                    record = type.equals("hetatm") ? "HETATM" : "ATOM  ";
                    int groupsize = g.size();
                    String resName = g.getPDBName();
                    String pdbcode = g.getPDBCode();
                    String line = "";
                    for (int atompos = 0; atompos < groupsize; ++atompos) {
                        Atom a = null;
                        try {
                            a = g.getAtom(atompos);
                        }
                        catch (StructureException e) {
                            System.err.println(e);
                            continue;
                        }
                        int seri = a.getPDBserial();
                        String serial = this.alignRight("" + seri, 5);
                        String fullname = a.getFullName();
                        Character altLoc = a.getAltLoc();
                        String resseq = "";
                        resseq = this.hasInsertionCode(pdbcode) ? this.alignRight("" + pdbcode, 5) : this.alignRight("" + pdbcode, 4) + " ";
                        String x = this.alignRight("" + d3.format(a.getX()), 8);
                        String y = this.alignRight("" + d3.format(a.getY()), 8);
                        String z = this.alignRight("" + d3.format(a.getZ()), 8);
                        String occupancy = this.alignRight("" + d2.format(a.getOccupancy()), 6);
                        String tempfactor = this.alignRight("" + d2.format(a.getTempFactor()), 6);
                        String leftResName = this.alignLeft(resName, 3);
                        str.append(record);
                        str.append(serial);
                        str.append(" ");
                        str.append(fullname);
                        str.append(altLoc);
                        str.append(leftResName);
                        str.append(" ");
                        str.append(chainID);
                        str.append(resseq);
                        str.append("   ");
                        str.append(x);
                        str.append(y);
                        str.append(z);
                        str.append(occupancy);
                        str.append(tempfactor);
                        str.append(" ");
                        str.append(newline);
                    }
                }
            }
            if (!this.structure.isNmr()) continue;
            str.append("ENDMDL" + newline);
        }
        if (this.doPrintConnections()) {
            str.append(this.printPDBConnections());
        }
        return str.toString();
    }

    private boolean hasInsertionCode(String pdbserial) {
        try {
            Integer.parseInt(pdbserial);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public void toDASStructure(XMLWriter xw) throws IOException {
        if (this.structure == null) {
            System.err.println("can not convert structure null");
            return;
        }
        HashMap header = (HashMap)this.structure.getHeader();
        xw.openTag("object");
        xw.attribute("dbAccessionId", this.structure.getPDBCode());
        xw.attribute("intObjectId", this.structure.getPDBCode());
        String modificationDate = (String)header.get("modDate");
        xw.attribute("objectVersion", modificationDate);
        xw.attribute("type", "protein structure");
        xw.attribute("dbSource", "PDB");
        xw.attribute("dbVersion", "20070116");
        xw.attribute("dbCoordSys", "PDBresnum,Protein Structure");
        xw.closeTag("object");
        for (int modelnr = 0; modelnr < this.structure.nrModels(); ++modelnr) {
            for (int chainnr = 0; chainnr < this.structure.size(modelnr); ++chainnr) {
                Chain chain = this.structure.getChain(modelnr, chainnr);
                xw.openTag("chain");
                xw.attribute("id", chain.getName());
                xw.attribute("SwissprotId", chain.getSwissprotId());
                if (this.structure.isNmr()) {
                    xw.attribute("model", Integer.toString(modelnr + 1));
                }
                for (int groupnr = 0; groupnr < chain.getAtomLength(); ++groupnr) {
                    Group gr = chain.getAtomGroup(groupnr);
                    xw.openTag("group");
                    xw.attribute("name", gr.getPDBName());
                    xw.attribute("type", gr.getType());
                    xw.attribute("groupID", gr.getPDBCode());
                    ArrayList atoms = (ArrayList)gr.getAtoms();
                    for (int atomnr = 0; atomnr < atoms.size(); ++atomnr) {
                        Atom atom = (Atom)atoms.get(atomnr);
                        xw.openTag("atom");
                        xw.attribute("atomID", Integer.toString(atom.getPDBserial()));
                        xw.attribute("atomName", atom.getFullName());
                        xw.attribute("x", Double.toString(atom.getX()));
                        xw.attribute("y", Double.toString(atom.getY()));
                        xw.attribute("z", Double.toString(atom.getZ()));
                        xw.closeTag("atom");
                    }
                    xw.closeTag("group");
                }
                xw.closeTag("chain");
            }
        }
        if (this.doPrintConnections()) {
            List<Map<String, Integer>> cons = this.structure.getConnections();
            for (int cnr = 0; cnr < cons.size(); ++cnr) {
                Map<String, Integer> con = cons.get(cnr);
                Integer as = con.get("atomserial");
                int atomserial = as;
                ArrayList<Integer> atomids = new ArrayList<Integer>();
                if (con.containsKey("salt1")) {
                    atomids.add(con.get("salt1"));
                }
                if (con.containsKey("salt2")) {
                    atomids.add(con.get("salt2"));
                }
                if (atomids.size() != 0) {
                    this.addConnection(xw, "salt", atomserial, atomids);
                    atomids = new ArrayList();
                }
                if (con.containsKey("hydrogen1")) {
                    atomids.add(con.get("hydrogen1"));
                }
                if (con.containsKey("hydrogen2")) {
                    atomids.add(con.get("hydrogen2"));
                }
                if (con.containsKey("hydrogen3")) {
                    atomids.add(con.get("hydrogen3"));
                }
                if (con.containsKey("hydrogen4")) {
                    atomids.add(con.get("hydrogen4"));
                }
                if (atomids.size() != 0) {
                    this.addConnection(xw, "hydrogen", atomserial, atomids);
                    atomids = new ArrayList();
                }
                if (con.containsKey("bond1")) {
                    atomids.add(con.get("bond1"));
                }
                if (con.containsKey("bond2")) {
                    atomids.add(con.get("bond2"));
                }
                if (con.containsKey("bond3")) {
                    atomids.add(con.get("bond3"));
                }
                if (con.containsKey("bond4")) {
                    atomids.add(con.get("bond4"));
                }
                if (atomids.size() == 0) continue;
                this.addConnection(xw, "bond", atomserial, atomids);
            }
        }
    }

    private void addConnection(XMLWriter xw, String connType, int atomserial, List<Integer> atomids) {
        try {
            xw.openTag("connect");
            xw.attribute("atomSerial", Integer.toString(atomserial));
            xw.attribute("type", connType);
            for (int i = 0; i < atomids.size(); ++i) {
                Integer atomid = atomids.get(i);
                if (atomid == null) continue;
                int aid = atomid;
                xw.openTag("atomID");
                xw.attribute("atomID", Integer.toString(aid));
                xw.closeTag("atomID");
            }
            xw.closeTag("connect");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

