/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;

public class ChemicalComponentDictionary {
    private Map<String, ChemComp> dictionary = new HashMap<String, ChemComp>();
    private Map<String, String> replaces = new HashMap<String, String>();
    private Map<String, String> isreplacedby = new HashMap<String, String>();

    public boolean isReplaced(ChemComp c) {
        return this.isReplaced(c.getId());
    }

    public boolean isReplaced(String id) {
        return this.isreplacedby.containsKey(id);
    }

    public boolean isReplacer(ChemComp c) {
        return this.isReplacer(c.getId());
    }

    public boolean isReplacer(String id) {
        return this.replaces.containsKey(id);
    }

    public ChemComp getReplacer(ChemComp c) {
        return this.getReplacer(c.getId());
    }

    public ChemComp getReplacer(String id) {
        if (this.isReplaced(id)) {
            return this.dictionary.get(this.isreplacedby.get(id));
        }
        return this.dictionary.get(id);
    }

    public ChemComp getReplaced(ChemComp c) {
        return this.getReplaced(c.getId());
    }

    public ChemComp getReplaced(String id) {
        if (this.isReplacer(id)) {
            return this.dictionary.get(this.replaces.get(id));
        }
        return this.dictionary.get(id);
    }

    public ChemComp getParent(ChemComp c) {
        if (c.hasParent()) {
            return this.dictionary.get(c.getMon_nstd_parent_comp_id());
        }
        return null;
    }

    public void addChemComp(ChemComp comp) {
        String isrep;
        this.dictionary.put(comp.getId(), comp);
        String rep = comp.getPdbx_replaces();
        if (rep != null && !rep.equals("?")) {
            this.replaces.put(comp.getId(), rep);
        }
        if ((isrep = comp.getPdbx_replaced_by()) != null && !isrep.equals("?")) {
            this.isreplacedby.put(comp.getId(), isrep);
        }
    }
}

