/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.stats.svm.AbstractSVMClassifierModel;
import org.biojava.stats.svm.ItemValue;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleItemValue;

public class SimpleSVMClassifierModel
extends AbstractSVMClassifierModel {
    private SVMKernel kernel;
    private double threshold;
    private Set itemAlphaSet;
    private Map itemToItemAlpha;

    public SimpleSVMClassifierModel(SVMKernel kernel) {
        this.kernel = kernel;
        this.itemAlphaSet = new HashSet();
        this.itemToItemAlpha = new HashMap();
    }

    public SimpleSVMClassifierModel(SVMKernel kernel, Collection items) {
        this(kernel);
        Iterator i = items.iterator();
        while (i.hasNext()) {
            this.addItem(i.next());
        }
    }

    public SimpleSVMClassifierModel(SVMKernel kernel, SVMTarget target) {
        this(kernel, target.items());
    }

    public SVMKernel getKernel() {
        return this.kernel;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Set items() {
        return this.itemToItemAlpha.keySet();
    }

    public Set itemAlphas() {
        return this.itemAlphaSet;
    }

    public double getAlpha(Object item) {
        return ((ItemValue)this.itemToItemAlpha.get(item)).getValue();
    }

    public void setAlpha(Object item, double alpha) {
        ItemValue iv = (ItemValue)this.itemToItemAlpha.get(item);
        iv.setValue(alpha);
    }

    public void addItem(Object item) {
        SimpleItemValue iv = new SimpleItemValue(item, 0.0);
        this.itemToItemAlpha.put(item, iv);
        this.itemAlphaSet.add(iv);
    }

    public void addItemAlpha(Object item, double alpha) {
        SimpleItemValue iv = new SimpleItemValue(item, alpha);
        this.itemToItemAlpha.put(item, iv);
        this.itemAlphaSet.add(iv);
    }

    public void removeItem(Object item) {
        this.itemToItemAlpha.remove(item);
        this.itemAlphaSet.remove(item);
    }

    public void clear() {
        this.itemAlphaSet.clear();
        this.itemToItemAlpha.clear();
    }
}

