/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.PrintStream;
import java.util.EventListener;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeVetoException;

public interface ChangeListener
extends EventListener {
    public static final ChangeListener ALWAYS_VETO = new AlwaysVetoListener();
    public static final ChangeListener LOG_TO_OUT = new LoggingListener(System.out);

    public void preChange(ChangeEvent var1) throws ChangeVetoException;

    public void postChange(ChangeEvent var1);

    public static class LoggingListener
    implements ChangeListener {
        private PrintStream out;
        private String prefix;

        public LoggingListener(PrintStream out) {
            this.out = out;
            this.prefix = null;
        }

        public LoggingListener(PrintStream out, String prefix) {
            this.out = out;
            this.prefix = prefix;
        }

        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            if (this.prefix != null) {
                this.out.print(this.prefix);
            }
            this.out.println("preChange for event " + cev);
        }

        public void postChange(ChangeEvent cev) {
            if (this.prefix != null) {
                this.out.print(this.prefix);
            }
            this.out.println("postChange for event " + cev);
        }
    }

    public static class ChangeEventRecorder
    extends ChangeAdapter {
        private ChangeEvent event;

        public ChangeEvent getEvent() {
            return this.event;
        }

        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            this.event = cev;
        }
    }

    public static class AlwaysVetoListener
    implements ChangeListener {
        protected AlwaysVetoListener() {
        }

        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            throw new ChangeVetoException(cev, "This object has been locked");
        }

        public void postChange(ChangeEvent cev) {
            throw new AssertionFailure(new ChangeVetoException(cev, "This object has been locked"));
        }
    }
}

