/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db.biosql;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.bio.db.AbstractRichSequenceDB;
import org.biojavax.bio.db.HashRichSequenceDB;
import org.biojavax.bio.db.RichSequenceDB;
import org.biojavax.bio.db.biosql.BioSQLFeatureFilter;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.SimpleRichSequence;

public class BioSQLRichSequenceDB
extends AbstractRichSequenceDB {
    private Object session;
    private String name;
    private Method createCriteria;
    private Method addCriteria;
    private Method listCriteria;
    private Method createAlias;
    private Method createQuery;
    private Method setParameter;
    private Method list;
    private Method delete;
    private Method saveOrUpdate;
    private Method getIdentifier;
    private Method load;
    private Method evict;

    public BioSQLRichSequenceDB(Object session) {
        this(null, session);
    }

    public BioSQLRichSequenceDB(String name, Object session) {
        this.name = name;
        this.session = session;
        try {
            Class<?> hibernateSession = session.getClass();
            Class<?> realHibernateSession = Class.forName("org.hibernate.Session");
            if (!realHibernateSession.isAssignableFrom(hibernateSession)) {
                throw new IllegalArgumentException("Parameter must be a org.hibernate.Session object");
            }
            this.session = session;
            this.createQuery = hibernateSession.getMethod("createQuery", String.class);
            this.delete = hibernateSession.getMethod("delete", String.class, Object.class);
            this.saveOrUpdate = hibernateSession.getMethod("saveOrUpdate", String.class, Object.class);
            this.getIdentifier = hibernateSession.getMethod("getIdentifier", Object.class);
            this.evict = hibernateSession.getMethod("evict", Object.class);
            this.load = hibernateSession.getMethod("load", String.class, Serializable.class);
            Class<?> hibernateQuery = Class.forName("org.hibernate.Query");
            this.setParameter = hibernateQuery.getMethod("setParameter", Integer.TYPE, Object.class);
            this.list = hibernateQuery.getMethod("list", new Class[0]);
            Class<?> criteria = Class.forName("org.hibernate.Criteria");
            this.createCriteria = hibernateSession.getMethod("createCriteria", Class.class);
            this.addCriteria = criteria.getMethod("add", Class.forName("org.hibernate.criterion.Criterion"));
            this.listCriteria = criteria.getMethod("list", new Class[0]);
            this.createAlias = criteria.getMethod("createAlias", String.class, String.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getHibernateSession() {
        return this.session;
    }

    public FeatureHolder processFeatureFilter(FeatureFilter ff) {
        BioSQLFeatureFilter bff = BioSQLFeatureFilter.Tools.convert(ff);
        SimpleFeatureHolder results = new SimpleFeatureHolder();
        try {
            Object criteria = this.createCriteria.invoke(this.session, RichFeature.class);
            this.addCriteria.invoke(criteria, bff.asCriterion());
            Map aliases = bff.criterionAliasMap();
            for (String property : aliases.keySet()) {
                String alias = (String)aliases.get(property);
                this.createAlias.invoke(criteria, property, alias);
            }
            List cats = (List)this.listCriteria.invoke(criteria, (Object[])null);
            Iterator i = cats.iterator();
            while (i.hasNext()) {
                results.addFeature((Feature)i.next());
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Assertion failed: couldn't modify newly created SimpleFeatureHolder", cve);
        }
        return results;
    }

    public FeatureHolder filter(FeatureFilter ff) {
        FeatureHolder fh = this.processFeatureFilter(ff);
        if (!(ff instanceof BioSQLFeatureFilter)) {
            SimpleFeatureHolder sfh = new SimpleFeatureHolder();
            Iterator<Feature> i = fh.features();
            while (i.hasNext()) {
                Feature f = i.next();
                try {
                    if (!ff.accept(f)) continue;
                    sfh.addFeature(f);
                }
                catch (ChangeVetoException cve) {
                    throw new BioError("Assertion failed: couldn't modify newly created SimpleFeatureHolder", cve);
                }
            }
            fh = sfh;
        }
        return fh;
    }

    public Set ids() {
        try {
            String queryText = "select distinct name from Sequence";
            Object query = this.createQuery.invoke(this.session, queryText);
            List result = (List)this.list.invoke(query, (Object[])null);
            return new HashSet(result);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to load all names", e);
        }
    }

    public RichSequence fullyLoadRichSequence(RichSequence id) throws IllegalIDException, BioException {
        if (id instanceof SimpleRichSequence) {
            return id;
        }
        try {
            Serializable identifier = (Serializable)this.getIdentifier.invoke(this.session, id);
            this.evict.invoke(this.session, id);
            return (RichSequence)this.load.invoke(this.session, "Sequence", identifier);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to load by id: " + id, e);
        }
    }

    public RichSequence getRichSequence(String id) throws IllegalIDException, BioException {
        try {
            String queryText = "from Sequence where name = ?";
            Object query = this.createQuery.invoke(this.session, queryText);
            query = this.setParameter.invoke(query, new Integer(0), id);
            List result = (List)this.list.invoke(query, (Object[])null);
            if (result.size() == 0) {
                throw new IllegalIDException("Id not found: " + id);
            }
            if (result.size() > 1) {
                throw new IllegalIDException("Multiple records found with that id - use getRichSequences: " + id);
            }
            return (RichSequence)result.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to load by id: " + id, e);
        }
    }

    public RichSequenceDB getRichSequences(Set ids) throws BioException, IllegalIDException {
        return this.getRichSequences(ids, null);
    }

    public RichSequenceDB getRichSequences(Set ids, RichSequenceDB db) throws BioException, IllegalIDException {
        if (db == null) {
            db = new HashRichSequenceDB();
        }
        try {
            for (String id : ids) {
                String queryText = "from Sequence where name = ?";
                Object query = this.createQuery.invoke(this.session, queryText);
                List result = (List)this.list.invoke(query = this.setParameter.invoke(query, new Integer(0), id), (Object[])null);
                if (result.size() == 0) {
                    throw new IllegalIDException("Id not found: " + id);
                }
                Iterator j = result.iterator();
                while (j.hasNext()) {
                    db.addRichSequence((RichSequence)j.next());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to load by ids: " + ids, e);
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRichSequence(String id) throws IllegalIDException, BioException, ChangeVetoException {
        if (!this.hasListeners(RichSequenceDB.SEQUENCES)) {
            this._removeRichSequence(id);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RichSequenceDB.SEQUENCES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, RichSequenceDB.SEQUENCES, null, id);
                changeSupport.firePreChangeEvent(ce);
                this._removeRichSequence(id);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    private void _removeRichSequence(String id) throws IllegalIDException, BioException, ChangeVetoException {
        try {
            RichSequence be = this.getRichSequence(id);
            this.delete.invoke(this.session, "Sequence", be);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to delete by id: " + id, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRichSequence(RichSequence seq) throws IllegalIDException, BioException, ChangeVetoException {
        if (!this.hasListeners(RichSequenceDB.SEQUENCES)) {
            this._addRichSequence(seq);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RichSequenceDB.SEQUENCES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, RichSequenceDB.SEQUENCES, null, seq);
                changeSupport.firePreChangeEvent(ce);
                this._addRichSequence(seq);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    private void _addRichSequence(RichSequence seq) throws IllegalIDException, BioException, ChangeVetoException {
        try {
            this.saveOrUpdate.invoke(this.session, "Sequence", seq);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to save RichSequence with id: " + seq.getName(), e);
        }
    }
}

