/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo;

import java.util.List;
import java.util.Set;
import org.biojavax.bio.phylo.MultipleHitCorrection;
import org.biojavax.bio.phylo.io.nexus.CharactersBlock;
import org.biojavax.bio.phylo.io.nexus.TaxaBlock;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceBasedTreeMethod {
    public static WeightedGraph<String, DefaultWeightedEdge> Upgma(TaxaBlock t, CharactersBlock ch) {
        int index_x = 0;
        int index_y = 0;
        int p_index = 0;
        SimpleWeightedGraph jgrapht = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        int NTax = t.getDimensionsNTax();
        List labels = t.getTaxLabels();
        String[] seq = new String[NTax];
        double[][] distance = new double[NTax][];
        for (int i = 0; i < NTax; ++i) {
            seq[i] = "";
            distance[i] = new double[NTax];
        }
        for (String taxa : labels) {
            List matrix = ch.getMatrixData(taxa);
            for (Object elem : matrix) {
                Object data;
                if (elem instanceof Set) {
                    data = (Set)elem;
                    continue;
                }
                if (elem instanceof List) {
                    data = (List)elem;
                    continue;
                }
                data = elem.toString();
                if (data == null || data == " ") continue;
                int n = labels.indexOf(taxa);
                seq[n] = seq[n] + (String)data;
            }
        }
        for (int i = 0; i < NTax; ++i) {
            for (int j = 0; j < NTax; ++j) {
                distance[i][j] = i == j ? 0.0 : MultipleHitCorrection.JukesCantor(seq[i], seq[j]);
            }
        }
        do {
            int i;
            double min_d = distance[0][1];
            for (i = 0; i < NTax; ++i) {
                for (int j = i + 1; j < NTax; ++j) {
                    if (!(min_d >= distance[i][j])) continue;
                    min_d = distance[i][j];
                    index_x = i;
                    index_y = j;
                }
            }
            String v1 = (String)labels.get(index_x);
            String v2 = "p" + p_index;
            String v3 = (String)labels.get(index_y);
            jgrapht.addVertex((Object)v1);
            jgrapht.addVertex((Object)v2);
            jgrapht.addVertex((Object)v3);
            jgrapht.addEdge((Object)v1, (Object)v2);
            jgrapht.addEdge((Object)v2, (Object)v3);
            ++p_index;
            for (i = 0; i < NTax; ++i) {
                for (int j = i; j < NTax; ++j) {
                    int k;
                    if (i == j) {
                        distance[i][j] = 0.0;
                        continue;
                    }
                    if (i == index_x && j == index_y) {
                        for (k = j + 1; k < NTax; ++k) {
                            distance[i][j] = (distance[k][i] + distance[k][j]) / 2.0;
                            distance[j][i] = distance[i][j];
                            labels.set(i, v2);
                            labels.set(j, labels.get(k));
                        }
                        labels.set(NTax - 1, null);
                        continue;
                    }
                    if (j != index_x) continue;
                    for (k = j + 1; k < NTax; ++k) {
                        if (k != index_y) continue;
                        distance[i][j] = (distance[i][j] + distance[i][k]) / 2.0;
                        distance[j][i] = distance[i][j];
                        labels.set(index_x, v2);
                        labels.set(index_y, null);
                    }
                }
            }
        } while (--NTax > 1);
        return jgrapht;
    }

    public static WeightedGraph<String, DefaultWeightedEdge> NeighborJoining(TaxaBlock t, CharactersBlock ch) {
        int index_x = 0;
        int index_y = 0;
        int p_index = 0;
        SimpleWeightedGraph jgrapht = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        int NTax = t.getDimensionsNTax();
        List labels = t.getTaxLabels();
        String[] seq = new String[NTax];
        double[] net_divergence = new double[NTax];
        double[][] raw_distance = new double[NTax][];
        double[][] distance = new double[NTax][];
        for (int i = 0; i < NTax; ++i) {
            seq[i] = "";
            raw_distance[i] = new double[NTax];
            distance[i] = new double[NTax];
        }
        for (String taxa : labels) {
            List matrix = ch.getMatrixData(taxa);
            for (Object elem : matrix) {
                Object data;
                if (elem instanceof Set) {
                    data = (Set)elem;
                    continue;
                }
                if (elem instanceof List) {
                    data = (List)elem;
                    continue;
                }
                data = elem.toString();
                if (data == null || data == " ") continue;
                int n = labels.indexOf(taxa);
                seq[n] = seq[n] + (String)data;
            }
        }
        for (int i = 0; i < NTax; ++i) {
            for (int j = 0; j < NTax; ++j) {
                raw_distance[i][j] = i == j ? 0.0 : MultipleHitCorrection.JukesCantor(seq[i], seq[j]);
                net_divergence[i] = raw_distance[i][j];
            }
        }
        do {
            int i;
            for (int i2 = 0; i2 < NTax; ++i2) {
                for (int j = 0; j < NTax; ++j) {
                    distance[i2][j] = i2 == j ? 0.0 : raw_distance[i2][j] - (net_divergence[i2] + net_divergence[j]) / 2.0;
                }
            }
            double min_d = distance[0][1];
            for (i = 0; i < NTax; ++i) {
                for (int j = i + 1; j < NTax; ++j) {
                    if (!(min_d >= distance[i][j])) continue;
                    min_d = distance[i][j];
                    index_x = i;
                    index_y = j;
                }
            }
            String v1 = (String)labels.get(index_x);
            String v2 = "p" + p_index;
            String v3 = (String)labels.get(index_y);
            jgrapht.addVertex((Object)v1);
            jgrapht.addVertex((Object)v2);
            jgrapht.addVertex((Object)v3);
            jgrapht.addEdge((Object)v1, (Object)v2);
            jgrapht.addEdge((Object)v2, (Object)v3);
            jgrapht.setEdgeWeight(jgrapht.getEdge((Object)v1, (Object)v2), raw_distance[index_x][index_y] / 2.0 + (net_divergence[index_x] - net_divergence[index_y]) / (double)(2 * (NTax - 2)));
            jgrapht.setEdgeWeight(jgrapht.getEdge((Object)v2, (Object)v3), raw_distance[index_x][index_y] - (raw_distance[index_x][index_y] / 2.0 + (net_divergence[index_x] - net_divergence[index_y]) / (double)(2 * (NTax - 2))));
            ++p_index;
            for (i = 0; i < NTax; ++i) {
                for (int j = i; j < NTax; ++j) {
                    int k;
                    if (i == j) {
                        distance[i][j] = 0.0;
                        continue;
                    }
                    if (i == index_x && j == index_y) {
                        for (k = j + 1; k < NTax; ++k) {
                            raw_distance[i][j] = (raw_distance[k][i] + raw_distance[k][j] - raw_distance[index_x][index_y]) / 2.0;
                            raw_distance[j][i] = raw_distance[i][j];
                            labels.set(i, v2);
                            labels.set(j, labels.get(k));
                        }
                        labels.set(NTax - 1, null);
                        continue;
                    }
                    if (j != index_x) continue;
                    for (k = j + 1; k < NTax; ++k) {
                        if (k != index_y) continue;
                        raw_distance[i][j] = (raw_distance[i][j] + raw_distance[i][k] - raw_distance[index_x][index_y]) / 2.0;
                        raw_distance[j][i] = raw_distance[i][j];
                        labels.set(index_x, v2);
                        labels.set(index_y, null);
                    }
                }
            }
        } while (--NTax > 1);
        return jgrapht;
    }
}

