/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.biojavax.bio.phylo.io.nexus.NexusBlock;
import org.biojavax.bio.phylo.io.nexus.NexusComment;
import org.biojavax.bio.phylo.io.nexus.NexusFileFormat;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.graph.SimpleWeightedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreesBlock
extends NexusBlock.Abstract {
    public static final String TREES_BLOCK = "TREES";
    private Map translations = new LinkedHashMap();
    private List comments = new ArrayList();
    private Map trees = new LinkedHashMap();
    private UndirectedGraph<String, DefaultEdge> unweighted = new SimpleGraph(DefaultEdge.class);
    private WeightedGraph<String, DefaultWeightedEdge> weighted = new SimpleWeightedGraph(DefaultWeightedEdge.class);

    public TreesBlock() {
        super(TREES_BLOCK);
    }

    public void addTranslation(String label, String taxa) {
        this.translations.put(label, taxa);
    }

    public void removeTranslation(String label) {
        this.translations.remove(label);
    }

    public boolean containsTranslation(String label) {
        return this.translations.containsKey(label);
    }

    public Map getTranslations() {
        return this.translations;
    }

    public void addTree(String label, NewickTreeString tree) {
        this.trees.put(label, tree);
    }

    public void removeTree(String label) {
        this.trees.remove(label);
    }

    public boolean containsTree(String label) {
        return this.trees.containsKey(label);
    }

    public Map getTrees() {
        return this.trees;
    }

    public Object getTree(String label) {
        return this.trees.get(label);
    }

    public void addTree(String label, UndirectedGraph<String, DefaultEdge> treegraph) {
        NewickTreeString tree = new NewickTreeString();
        String temp = treegraph.toString();
        String[] tokens = null;
        tokens = temp.split("\\[");
        temp = tokens[2];
        tokens = temp.split("\\]");
        temp = tokens[0];
        temp = temp.replace("{", "");
        temp = temp.replace("}", "");
        temp = temp.replace(" ", "");
        tokens = temp.split(",");
        temp = "";
        for (int i = 0; i < tokens.length; i += 4) {
            if (tokens[i].matches("p[0-9]") || tokens[i + 3].matches("p[0-9]")) continue;
            temp = "(" + tokens[i] + ", " + tokens[i + 3] + ")";
            for (int j = i + 4; j < tokens.length; ++j) {
                if (!tokens[j].equals(tokens[i + 1]) || !tokens[j].equals(tokens[i + 2])) continue;
                tokens[j] = temp;
            }
        }
        tree.setTreeString(temp);
        this.trees.put(label, tree);
    }

    public void addTree(String label, WeightedGraph<String, DefaultWeightedEdge> treegraph) {
        NewickTreeString tree = new NewickTreeString();
        String temp = treegraph.toString();
        String[] tokens = null;
        tokens = temp.split("\\[");
        temp = tokens[2];
        tokens = temp.split("\\]");
        temp = tokens[0];
        temp = temp.replace("{", "");
        temp = temp.replace("}", "");
        temp = temp.replace(" ", "");
        tokens = temp.split(",");
        temp = "";
        for (int i = 0; i < tokens.length; i += 4) {
            if (tokens[i].matches("p[0-9]") || tokens[i + 3].matches("p[0-9]") || tokens[i].equals(tokens[i + 3])) continue;
            if (!tokens[i].startsWith("(") && !tokens[i + 3].startsWith("(")) {
                temp = "(" + tokens[i] + ":" + treegraph.getEdgeWeight(treegraph.getEdge((Object)tokens[i], (Object)tokens[i + 1])) + ", " + tokens[i + 3] + ":" + treegraph.getEdgeWeight(treegraph.getEdge((Object)tokens[i + 2], (Object)tokens[i + 3])) + ")";
            } else if (tokens[i].startsWith("(") && !tokens[i + 3].startsWith("(")) {
                temp = "(" + tokens[i] + ", " + tokens[i + 3] + ":" + treegraph.getEdgeWeight(treegraph.getEdge((Object)tokens[i + 2], (Object)tokens[i + 3])) + ")";
            } else if (!tokens[i].startsWith("(") && tokens[i + 3].startsWith("(")) {
                temp = "(" + tokens[i] + ":" + treegraph.getEdgeWeight(treegraph.getEdge((Object)tokens[i], (Object)tokens[i + 1])) + ", " + tokens[i + 3] + ")";
            } else if (tokens[i].startsWith("(") && tokens[i + 3].startsWith("(")) {
                temp = "(" + tokens[i] + ", " + tokens[i + 3] + ")";
            }
            for (int j = 0; j < tokens.length; ++j) {
                if (!tokens[j].matches(tokens[i + 1]) || !tokens[j].matches(tokens[i + 2]) || j == i + 1 || j == i + 2) continue;
                double weight = 0.0;
                if (j % 4 == 0) {
                    weight = treegraph.getEdgeWeight(treegraph.getEdge((Object)tokens[j], (Object)tokens[j + 1]));
                } else if (j % 4 == 3) {
                    weight = treegraph.getEdgeWeight(treegraph.getEdge((Object)tokens[j], (Object)tokens[j - 1]));
                }
                if (j > i + 3) {
                    tokens[j] = temp + ":" + weight;
                    continue;
                }
                if (j >= i) continue;
                temp = "(" + tokens[j - 3] + ":" + treegraph.getEdgeWeight(treegraph.getEdge((Object)tokens[j - 3], (Object)tokens[j - 2])) + ", " + temp + ":" + weight + ")";
            }
        }
        tree.setTreeString(temp);
        this.trees.put(label, tree);
    }

    public UndirectedGraph<String, DefaultEdge> getTreeAsJGraphT(String label) {
        int i;
        int len = 0;
        int p_index = 0;
        NewickTreeString t = new NewickTreeString();
        Stack<String> stack = new Stack<String>();
        t = (NewickTreeString)this.trees.get(label);
        String temp = t.getTreeString();
        len = temp.length();
        String[] tokens = temp.split("");
        temp = "";
        for (i = 0; i <= len; ++i) {
            if (!tokens[i].equals("(")) continue;
            ++p_index;
        }
        for (i = 0; i <= len; ++i) {
            if (tokens[i].equals(",")) {
                stack.push("p" + p_index);
                --p_index;
                continue;
            }
            if (tokens[i].equals("(") || tokens[i].equals(" ")) continue;
            if (tokens[i].equals(")")) {
                try {
                    Object s_temp3 = stack.pop();
                    String v3 = s_temp3.toString();
                    try {
                        Object s_temp2 = stack.pop();
                        String v2 = s_temp2.toString();
                        try {
                            Object s_temp1 = stack.pop();
                            String v1 = s_temp1.toString();
                            this.unweighted.addVertex((Object)v1);
                            this.unweighted.addVertex((Object)v2);
                            this.unweighted.addVertex((Object)v3);
                            this.unweighted.addEdge((Object)v1, (Object)v2);
                            this.unweighted.addEdge((Object)v2, (Object)v3);
                            stack.push(v2);
                        }
                        catch (EmptyStackException e) {}
                    }
                    catch (EmptyStackException e) {
                    }
                }
                catch (EmptyStackException e) {}
                continue;
            }
            if (tokens[i].equals(" ")) continue;
            if (tokens[i + 1].equals("(") || tokens[i + 1].equals(")") || tokens[i + 1].equals(",")) {
                temp = temp + tokens[i];
                stack.push(temp);
                temp = "";
                continue;
            }
            temp = temp + tokens[i];
        }
        return this.unweighted;
    }

    public WeightedGraph<String, DefaultWeightedEdge> getTreeAsWeightedJGraphT(String label) {
        int len = 0;
        int p_index = 0;
        Stack<String> stack = new Stack<String>();
        Stack<String> weight_stack = new Stack<String>();
        NewickTreeString t = new NewickTreeString();
        t = (NewickTreeString)this.trees.get(label);
        String temp = t.getTreeString();
        len = temp.length();
        String[] tokens = temp.split("");
        temp = "";
        for (int i = 0; i <= len; ++i) {
            if (tokens[i].equals(",")) {
                stack.push("p" + p_index);
                ++p_index;
                continue;
            }
            if (tokens[i].equals("(") || tokens[i].equals(" ")) continue;
            if (tokens[i].equals(")")) {
                try {
                    Object s_temp3 = stack.pop();
                    String v3 = s_temp3.toString();
                    Object weight3 = weight_stack.pop();
                    String w3 = weight3.toString();
                    try {
                        Object s_temp2 = stack.pop();
                        String v2 = s_temp2.toString();
                        try {
                            Object s_temp1 = stack.pop();
                            String v1 = s_temp1.toString();
                            Object weight1 = weight_stack.pop();
                            String w1 = weight1.toString();
                            this.weighted.addVertex((Object)v1);
                            this.weighted.addVertex((Object)v2);
                            this.weighted.addVertex((Object)v3);
                            this.weighted.addEdge((Object)v1, (Object)v2);
                            this.weighted.addEdge((Object)v2, (Object)v3);
                            this.weighted.setEdgeWeight(this.weighted.getEdge((Object)v1, (Object)v2), Double.parseDouble(w1));
                            this.weighted.setEdgeWeight(this.weighted.getEdge((Object)v2, (Object)v3), Double.parseDouble(w3));
                            stack.push(v2);
                        }
                        catch (EmptyStackException e) {}
                    }
                    catch (EmptyStackException e) {
                    }
                }
                catch (EmptyStackException e) {}
                continue;
            }
            if (tokens[i].equals(" ")) continue;
            if (tokens[i + 1].equals("(") || tokens[i + 1].equals(")") || tokens[i + 1].equals(",")) {
                if ((temp = temp + tokens[i]).startsWith(":")) {
                    temp = temp.replace(":", "");
                    weight_stack.push(temp);
                } else if (!temp.startsWith(":") && temp.contains(":")) {
                    String[] temp_token = temp.split(":");
                    stack.push(temp_token[0]);
                    weight_stack.push(temp_token[1]);
                }
                temp = "";
                continue;
            }
            temp = temp + tokens[i];
        }
        return this.weighted;
    }

    public void addComment(NexusComment comment) {
        this.comments.add(comment);
    }

    public void removeComment(NexusComment comment) {
        this.comments.remove(comment);
    }

    public List getComments() {
        return this.comments;
    }

    @Override
    protected void writeBlockContents(Writer writer) throws IOException {
        Iterator<Object> i = this.comments.iterator();
        while (i.hasNext()) {
            ((NexusComment)i.next()).writeObject(writer);
            writer.write(NexusFileFormat.NEW_LINE);
        }
        writer.write(" TRANSLATE" + NexusFileFormat.NEW_LINE);
        i = this.translations.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            writer.write(9);
            this.writeToken(writer, "" + entry.getKey());
            writer.write(9);
            this.writeToken(writer, "" + entry.getValue());
            if (i.hasNext()) {
                writer.write(44);
            } else {
                writer.write(59);
            }
            writer.write(NexusFileFormat.NEW_LINE);
        }
        for (Map.Entry entry : this.trees.entrySet()) {
            NewickTreeString treeStr = (NewickTreeString)entry.getValue();
            writer.write(" TREE ");
            if (treeStr.isStarred()) {
                writer.write("* ");
            }
            this.writeToken(writer, "" + entry.getKey());
            writer.write(61);
            if (treeStr.getRootType() != null) {
                writer.write("[" + treeStr.getRootType() + "]");
            }
            this.writeToken(writer, treeStr.getTreeString());
            writer.write(";" + NexusFileFormat.NEW_LINE);
        }
    }

    public static class NewickTreeString {
        private String rootType;
        private String treeString;
        private boolean starred;

        public void setRootType(String rootType) {
            this.rootType = rootType;
        }

        public void setTreeString(String treeString) {
            this.treeString = treeString;
        }

        public void setStarred(boolean starred) {
            this.starred = starred;
        }

        public boolean isStarred() {
            return this.starred;
        }

        public String getRootType() {
            return this.rootType;
        }

        public String getTreeString() {
            return this.treeString;
        }
    }
}

