/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.xml.PrettyXMLWriter;
import org.biojava.utils.xml.XMLWriter;
import org.biojavax.Comment;
import org.biojavax.CrossRef;
import org.biojavax.DocRef;
import org.biojavax.DocRefAuthor;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RankedCrossRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleCrossRef;
import org.biojavax.SimpleDocRef;
import org.biojavax.SimpleDocRefAuthor;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRankedCrossRef;
import org.biojavax.SimpleRankedDocRef;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.bio.seq.io.GenbankLocationParser;
import org.biojavax.bio.seq.io.RichSeqIOListener;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.bio.taxa.SimpleNCBITaxon;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.utils.StringTools;
import org.biojavax.utils.XMLTools;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class INSDseqFormat
extends RichSequenceFormat.BasicFormat {
    public static final String INSDSEQ_FORMAT = "INSDseq";
    protected static final String INSDSEQS_GROUP_TAG = "INSDSet";
    protected static final String INSDSEQ_TAG = "INSDSeq";
    protected static final String LOCUS_TAG = "INSDSeq_locus";
    protected static final String LENGTH_TAG = "INSDSeq_length";
    protected static final String TOPOLOGY_TAG = "INSDSeq_topology";
    protected static final String STRANDED_TAG = "INSDSeq_strandedness";
    protected static final String MOLTYPE_TAG = "INSDSeq_moltype";
    protected static final String DIVISION_TAG = "INSDSeq_division";
    protected static final String UPDATE_DATE_TAG = "INSDSeq_update-date";
    protected static final String CREATE_DATE_TAG = "INSDSeq_create-date";
    protected static final String UPDATE_REL_TAG = "INSDSeq_update-release";
    protected static final String CREATE_REL_TAG = "INSDSeq_create-release";
    protected static final String DEFINITION_TAG = "INSDSeq_definition";
    protected static final String DATABASE_XREF_TAG = "INSDSeq_database-reference";
    protected static final String XREF_TAG = "INSDXref";
    protected static final String ACCESSION_TAG = "INSDSeq_primary-accession";
    protected static final String ACC_VERSION_TAG = "INSDSeq_accession-version";
    protected static final String SECONDARY_ACCESSIONS_GROUP_TAG = "INSDSeq_secondary-accessions";
    protected static final String SECONDARY_ACCESSION_TAG = "INSDSecondary-accn";
    protected static final String OTHER_SEQIDS_GROUP_TAG = "INSDSeq_other-seqids";
    protected static final String OTHER_SEQID_TAG = "INSDSeqid";
    protected static final String KEYWORDS_GROUP_TAG = "INSDSeq_keywords";
    protected static final String KEYWORD_TAG = "INSDKeyword";
    protected static final String SOURCE_TAG = "INSDSeq_source";
    protected static final String ORGANISM_TAG = "INSDSeq_organism";
    protected static final String TAXONOMY_TAG = "INSDSeq_taxonomy";
    protected static final String REFERENCES_GROUP_TAG = "INSDSeq_references";
    protected static final String REFERENCE_TAG = "INSDReference";
    protected static final String REFERENCE_LOCATION_TAG = "INSDReference_reference";
    protected static final String REFERENCE_POSITION_TAG = "INSDReference_position";
    protected static final String TITLE_TAG = "INSDReference_title";
    protected static final String JOURNAL_TAG = "INSDReference_journal";
    protected static final String PUBMED_TAG = "INSDReference_pubmed";
    protected static final String XREF_DBNAME_TAG = "INSDXref_dbname";
    protected static final String XREF_ID_TAG = "INSDXref_id";
    protected static final String REMARK_TAG = "INSDReference_remark";
    protected static final String AUTHORS_GROUP_TAG = "INSDReference_authors";
    protected static final String AUTHOR_TAG = "INSDAuthor";
    protected static final String CONSORTIUM_TAG = "INSDReference_consortium";
    protected static final String COMMENT_TAG = "INSDSeq_comment";
    protected static final String FEATURES_GROUP_TAG = "INSDSeq_feature-table";
    protected static final String FEATURE_TAG = "INSDFeature";
    protected static final String FEATURE_KEY_TAG = "INSDFeature_key";
    protected static final String FEATURE_LOC_TAG = "INSDFeature_location";
    protected static final String FEATURE_INTERVALS_GROUP_TAG = "INSDFeature_intervals";
    protected static final String FEATURE_INTERVAL_TAG = "INSDInterval";
    protected static final String FEATURE_FROM_TAG = "INSDInterval_from";
    protected static final String FEATURE_TO_TAG = "INSDInterval_to";
    protected static final String FEATURE_POINT_TAG = "INSDInterval_point";
    protected static final String FEATURE_ISCOMP_TAG = "INSDInterval_iscomp";
    protected static final String FEATURE_INTERBP_TAG = "INSDInterval_interbp";
    protected static final String FEATURE_ACCESSION_TAG = "INSDInterval_accession";
    protected static final String FEATURE_OPERATOR_TAG = "INSDFeature_operator";
    protected static final String FEATURE_PARTIAL5_TAG = "INSDFeature_partial5";
    protected static final String FEATURE_PARTIAL3_TAG = "INSDFeature_partial3";
    protected static final String FEATUREQUALS_GROUP_TAG = "INSDFeature_quals";
    protected static final String FEATUREQUAL_TAG = "INSDQualifier";
    protected static final String FEATUREQUAL_NAME_TAG = "INSDQualifier_name";
    protected static final String FEATUREQUAL_VALUE_TAG = "INSDQualifier_value";
    protected static final String SEQUENCE_TAG = "INSDSeq_sequence";
    protected static final String CONTIG_TAG = "INSDSeq_contig";
    protected static final Pattern dbxp;
    protected static final Pattern xmlSchema;
    private PrintWriter pw;
    private XMLWriter xmlWriter;

    public boolean canRead(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        br.readLine();
        String secondLine = br.readLine();
        boolean readable = secondLine != null && xmlSchema.matcher(secondLine).matches();
        br.close();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(File file) throws IOException {
        return RichSequence.IOTools.getDNAParser();
    }

    public boolean canRead(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        br.readLine();
        String secondLine = br.readLine();
        boolean readable = secondLine != null && xmlSchema.matcher(secondLine).matches();
        stream.reset();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(BufferedInputStream stream) throws IOException {
        return RichSequence.IOTools.getDNAParser();
    }

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        if (!(listener instanceof RichSeqIOListener)) {
            throw new IllegalArgumentException("Only accepting RichSeqIOListeners today");
        }
        return this.readRichSequence(reader, symParser, (RichSeqIOListener)listener, null);
    }

    public boolean readRichSequence(BufferedReader reader, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) throws IllegalSymbolException, IOException, ParseException {
        try {
            INSDseqHandler m_handler = new INSDseqHandler(this, symParser, rlistener, ns);
            return XMLTools.readXMLChunk(reader, m_handler, INSDSEQ_TAG);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
    }

    private XMLWriter getXMLWriter() {
        if (this.xmlWriter == null) {
            this.pw = new PrintWriter(this.getPrintStream());
            this.xmlWriter = new PrettyXMLWriter(this.pw);
        }
        return this.xmlWriter;
    }

    public void beginWriting() throws IOException {
        XMLWriter xml = this.getXMLWriter();
        xml.printRaw("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        xml.printRaw("<!DOCTYPE INSDSeq PUBLIC \"-//EMBL-EBI//INSD INSDSeq/EN\" \"http://www.ebi.ac.uk/dtd/INSD_INSDSeq.dtd\">");
        xml.openTag(INSDSEQS_GROUP_TAG);
    }

    public void finishWriting() throws IOException {
        XMLWriter xml = this.getXMLWriter();
        xml.closeTag(INSDSEQS_GROUP_TAG);
        this.pw.flush();
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(this.getPrintStream());
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(this.getPrintStream());
        }
        if (!format.equals(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    /*
     * WARNING - void declaration
     */
    public void writeSequence(Sequence seq, Namespace ns) throws IOException {
        void var17_25;
        Iterator r;
        NCBITaxon tax;
        Iterator i;
        RichSequence rs;
        try {
            rs = seq instanceof RichSequence ? (RichSequence)seq : RichSequence.Tools.enrich(seq);
        }
        catch (ChangeVetoException e) {
            IOException e2 = new IOException("Unable to enrich sequence");
            e2.initCause(e);
            throw e2;
        }
        Set notes = rs.getNoteSet();
        ArrayList<String> accessions = new ArrayList<String>();
        ArrayList<String> otherSeqIDs = new ArrayList<String>();
        ArrayList<String> kws = new ArrayList<String>();
        String stranded = null;
        String udat = null;
        String cdat = null;
        String urel = null;
        String crel = null;
        String moltype = rs.getAlphabet().getName();
        for (Note n : notes) {
            if (n.getTerm().equals(Terms.getStrandedTerm())) {
                stranded = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDateCreatedTerm())) {
                cdat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getRelUpdatedTerm())) {
                urel = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getRelCreatedTerm())) {
                crel = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getMolTypeTerm())) {
                moltype = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getAdditionalAccessionTerm())) {
                accessions.add(n.getValue());
                continue;
            }
            if (n.getTerm().equals(Terms.getOtherSeqIdTerm())) {
                otherSeqIDs.add(n.getValue());
                continue;
            }
            if (!n.getTerm().equals(Terms.getKeywordTerm())) continue;
            kws.add(n.getValue());
        }
        XMLWriter xml = this.getXMLWriter();
        xml.openTag(INSDSEQ_TAG);
        xml.openTag(LOCUS_TAG);
        xml.print(rs.getName());
        xml.closeTag(LOCUS_TAG);
        xml.openTag(LENGTH_TAG);
        xml.print("" + rs.length());
        xml.closeTag(LENGTH_TAG);
        if (stranded != null) {
            xml.openTag(STRANDED_TAG);
            xml.print(stranded);
            xml.closeTag(STRANDED_TAG);
        }
        if (moltype != null) {
            xml.openTag(MOLTYPE_TAG);
            xml.print(moltype);
            xml.closeTag(MOLTYPE_TAG);
        }
        xml.openTag(TOPOLOGY_TAG);
        if (rs.getCircular()) {
            xml.print("circular");
        } else {
            xml.print("linear");
        }
        xml.closeTag(TOPOLOGY_TAG);
        if (rs.getDivision() != null) {
            xml.openTag(DIVISION_TAG);
            xml.print(rs.getDivision());
            xml.closeTag(DIVISION_TAG);
        }
        xml.openTag(UPDATE_DATE_TAG);
        xml.print(udat);
        xml.closeTag(UPDATE_DATE_TAG);
        if (cdat != null) {
            xml.openTag(CREATE_DATE_TAG);
            xml.print(cdat);
            xml.closeTag(CREATE_DATE_TAG);
        }
        if (urel != null) {
            xml.openTag(UPDATE_REL_TAG);
            xml.print(urel);
            xml.closeTag(UPDATE_REL_TAG);
        }
        if (crel != null) {
            xml.openTag(CREATE_REL_TAG);
            xml.print(crel);
            xml.closeTag(CREATE_REL_TAG);
        }
        if (rs.getDescription() != null) {
            xml.openTag(DEFINITION_TAG);
            xml.print(rs.getDescription());
            xml.closeTag(DEFINITION_TAG);
        }
        xml.openTag(ACC_VERSION_TAG);
        xml.print(rs.getAccession() + "." + rs.getVersion());
        xml.closeTag(ACC_VERSION_TAG);
        if (!otherSeqIDs.isEmpty()) {
            xml.openTag(OTHER_SEQIDS_GROUP_TAG);
            i = otherSeqIDs.iterator();
            while (i.hasNext()) {
                xml.openTag(OTHER_SEQID_TAG);
                xml.print((String)i.next());
                xml.closeTag(OTHER_SEQID_TAG);
            }
            xml.closeTag(OTHER_SEQIDS_GROUP_TAG);
        }
        if (!accessions.isEmpty()) {
            xml.openTag(SECONDARY_ACCESSIONS_GROUP_TAG);
            i = accessions.iterator();
            while (i.hasNext()) {
                xml.openTag(SECONDARY_ACCESSION_TAG);
                xml.print((String)i.next());
                xml.closeTag(SECONDARY_ACCESSION_TAG);
            }
            xml.closeTag(SECONDARY_ACCESSIONS_GROUP_TAG);
        }
        if (!kws.isEmpty()) {
            xml.openTag(KEYWORDS_GROUP_TAG);
            i = kws.iterator();
            while (i.hasNext()) {
                xml.openTag(KEYWORD_TAG);
                xml.print((String)i.next());
                xml.closeTag(KEYWORD_TAG);
            }
            xml.closeTag(KEYWORDS_GROUP_TAG);
        }
        if ((tax = rs.getTaxon()) != null) {
            xml.openTag(SOURCE_TAG);
            xml.print(tax.getDisplayName());
            xml.closeTag(SOURCE_TAG);
            xml.openTag(ORGANISM_TAG);
            xml.print(tax.getDisplayName().split("\\(")[0].trim());
            xml.closeTag(ORGANISM_TAG);
            xml.openTag(TAXONOMY_TAG);
            String h = tax.getNameHierarchy();
            xml.print(h.substring(0, h.length() - 1));
            xml.closeTag(TAXONOMY_TAG);
        }
        if (!rs.getRankedDocRefs().isEmpty()) {
            xml.openTag(REFERENCES_GROUP_TAG);
            r = rs.getRankedDocRefs().iterator();
            while (r.hasNext()) {
                xml.openTag(REFERENCE_TAG);
                RankedDocRef rankedDocRef = (RankedDocRef)r.next();
                DocRef d = rankedDocRef.getDocumentReference();
                xml.openTag(REFERENCE_LOCATION_TAG);
                xml.print(Integer.toString(rankedDocRef.getRank()));
                xml.closeTag(REFERENCE_LOCATION_TAG);
                RichLocation rdrl = rankedDocRef.getLocation();
                if (!rdrl.equals(RichLocation.EMPTY_LOCATION)) {
                    xml.openTag(REFERENCE_POSITION_TAG);
                    Iterator i2 = rdrl.blockIterator();
                    while (i2.hasNext()) {
                        RichLocation l = (RichLocation)i2.next();
                        xml.print(l.getMin() + ".." + l.getMax());
                        if (!i2.hasNext()) continue;
                        xml.print("; ");
                    }
                    xml.closeTag(REFERENCE_POSITION_TAG);
                }
                xml.openTag(AUTHORS_GROUP_TAG);
                List auths = d.getAuthorList();
                Iterator i3 = auths.iterator();
                while (i3.hasNext()) {
                    DocRefAuthor a = (DocRefAuthor)i3.next();
                    if (a.isConsortium()) continue;
                    xml.openTag(AUTHOR_TAG);
                    xml.print(a.getName());
                    xml.closeTag(AUTHOR_TAG);
                    i3.remove();
                }
                xml.closeTag(AUTHORS_GROUP_TAG);
                if (!auths.isEmpty()) {
                    DocRefAuthor a = (DocRefAuthor)auths.iterator().next();
                    xml.openTag(CONSORTIUM_TAG);
                    xml.print(a.getName());
                    xml.closeTag(CONSORTIUM_TAG);
                }
                if (d.getTitle() != null) {
                    xml.openTag(TITLE_TAG);
                    xml.print(d.getTitle());
                    xml.closeTag(TITLE_TAG);
                }
                xml.openTag(JOURNAL_TAG);
                xml.print(d.getLocation());
                xml.closeTag(JOURNAL_TAG);
                CrossRef c = d.getCrossref();
                if (c != null) {
                    if (c.getDbname().equals("PUBMED")) {
                        xml.openTag(PUBMED_TAG);
                        xml.print(c.getAccession());
                        xml.closeTag(PUBMED_TAG);
                    } else {
                        xml.openTag(XREF_TAG);
                        xml.openTag(XREF_DBNAME_TAG);
                        xml.print(c.getDbname());
                        xml.closeTag(XREF_DBNAME_TAG);
                        xml.openTag(XREF_ID_TAG);
                        xml.print(c.getAccession());
                        xml.closeTag(XREF_ID_TAG);
                        xml.closeTag(XREF_TAG);
                    }
                }
                if (d.getRemark() != null) {
                    xml.openTag(REMARK_TAG);
                    xml.print(d.getRemark());
                    xml.closeTag(REMARK_TAG);
                }
                xml.closeTag(REFERENCE_TAG);
            }
            xml.closeTag(REFERENCES_GROUP_TAG);
        }
        if (!rs.getComments().isEmpty()) {
            xml.openTag(COMMENT_TAG);
            Iterator i4 = rs.getComments().iterator();
            while (i4.hasNext()) {
                xml.println(((Comment)i4.next()).getComment());
            }
            xml.closeTag(COMMENT_TAG);
        }
        if (!rs.getRankedCrossRefs().isEmpty()) {
            r = rs.getRankedCrossRefs().iterator();
            RankedCrossRef rankedCrossRef = (RankedCrossRef)r.next();
            CrossRef c = rankedCrossRef.getCrossRef();
            Set noteset = c.getNoteSet();
            StringBuffer sb = new StringBuffer();
            sb.append(c.getDbname().toUpperCase());
            sb.append("; ");
            sb.append(c.getAccession());
            boolean hasSecondary = false;
            for (Note n : noteset) {
                if (!n.getTerm().equals(Terms.getAdditionalAccessionTerm())) continue;
                sb.append("; ");
                sb.append(n.getValue());
                hasSecondary = true;
            }
            xml.openTag(DATABASE_XREF_TAG);
            xml.print(sb.toString());
            xml.closeTag(DATABASE_XREF_TAG);
        }
        if (!rs.getFeatureSet().isEmpty()) {
            xml.openTag(FEATURES_GROUP_TAG);
            for (RichFeature richFeature : rs.getFeatureSet()) {
                xml.openTag(FEATURE_TAG);
                xml.openTag(FEATURE_KEY_TAG);
                xml.print(richFeature.getTypeTerm().getName());
                xml.closeTag(FEATURE_KEY_TAG);
                xml.openTag(FEATURE_LOC_TAG);
                xml.print(GenbankLocationParser.writeLocation((RichLocation)richFeature.getLocation()));
                xml.closeTag(FEATURE_LOC_TAG);
                xml.openTag(FEATURE_INTERVALS_GROUP_TAG);
                RichLocation loc = (RichLocation)richFeature.getLocation();
                boolean first = true;
                boolean partial5 = false;
                boolean partial3 = false;
                ComparableTerm operator = loc.getTerm();
                Iterator j = loc.blockIterator();
                while (j.hasNext()) {
                    boolean interbp;
                    xml.openTag(FEATURE_INTERVAL_TAG);
                    RichLocation rl = (RichLocation)j.next();
                    if (rl.getMin() == rl.getMax()) {
                        xml.openTag(FEATURE_POINT_TAG);
                        xml.print("" + rl.getMin());
                        xml.closeTag(FEATURE_POINT_TAG);
                    } else {
                        xml.openTag(FEATURE_FROM_TAG);
                        xml.print("" + rl.getMin());
                        xml.closeTag(FEATURE_FROM_TAG);
                        xml.openTag(FEATURE_TO_TAG);
                        xml.print("" + rl.getMax());
                        xml.closeTag(FEATURE_TO_TAG);
                    }
                    boolean iscomp = rl.getStrand().equals(RichLocation.Strand.NEGATIVE_STRAND);
                    boolean bl = interbp = rl.getMinPosition().getType() != null && rl.getMinPosition().getType().equals("^") || rl.getMaxPosition().getType() != null && rl.getMaxPosition().getType().equals("^");
                    if (first && rl.getMinPosition().getFuzzyStart()) {
                        partial5 = true;
                    }
                    if (!j.hasNext() && rl.getMaxPosition().getFuzzyEnd()) {
                        partial3 = true;
                    }
                    first = false;
                    xml.openTag(FEATURE_ISCOMP_TAG);
                    xml.print("" + iscomp);
                    xml.closeTag(FEATURE_ISCOMP_TAG);
                    xml.openTag(FEATURE_INTERBP_TAG);
                    xml.print("" + interbp);
                    xml.closeTag(FEATURE_INTERBP_TAG);
                    xml.openTag(FEATURE_ACCESSION_TAG);
                    xml.print(((RichSequence)richFeature.getSequence()).getAccession());
                    xml.closeTag(FEATURE_ACCESSION_TAG);
                    xml.closeTag(FEATURE_INTERVAL_TAG);
                }
                if (operator != null) {
                    xml.openTag(FEATURE_OPERATOR_TAG);
                    xml.print(operator.getName());
                    xml.closeTag(FEATURE_OPERATOR_TAG);
                }
                xml.openTag(FEATURE_PARTIAL5_TAG);
                xml.print("" + partial5);
                xml.closeTag(FEATURE_PARTIAL5_TAG);
                xml.openTag(FEATURE_PARTIAL3_TAG);
                xml.print("" + partial3);
                xml.closeTag(FEATURE_PARTIAL3_TAG);
                xml.closeTag(FEATURE_INTERVALS_GROUP_TAG);
                xml.openTag(FEATUREQUALS_GROUP_TAG);
                for (Note n : richFeature.getNoteSet()) {
                    xml.openTag(FEATUREQUAL_TAG);
                    xml.openTag(FEATUREQUAL_NAME_TAG);
                    xml.print("" + n.getTerm().getName());
                    xml.closeTag(FEATUREQUAL_NAME_TAG);
                    xml.openTag(FEATUREQUAL_VALUE_TAG);
                    if (n.getValue() != null && !n.getValue().equals("")) {
                        if (n.getTerm().getName().equalsIgnoreCase("translation")) {
                            String[] lines = StringTools.wordWrap(n.getValue(), "\\s+", this.getLineWidth());
                            for (int k = 0; k < lines.length; ++k) {
                                xml.println(lines[k]);
                            }
                        } else {
                            xml.print(n.getValue());
                        }
                    }
                    xml.closeTag(FEATUREQUAL_VALUE_TAG);
                    xml.closeTag(FEATUREQUAL_TAG);
                }
                if (richFeature.getType().equalsIgnoreCase("source") && tax != null) {
                    xml.openTag(FEATUREQUAL_TAG);
                    xml.openTag(FEATUREQUAL_NAME_TAG);
                    xml.print("db_xref");
                    xml.closeTag(FEATUREQUAL_NAME_TAG);
                    xml.openTag(FEATUREQUAL_VALUE_TAG);
                    xml.print("taxon:" + tax.getNCBITaxID());
                    xml.closeTag(FEATUREQUAL_VALUE_TAG);
                    xml.closeTag(FEATUREQUAL_TAG);
                    String displayName = tax.getDisplayName();
                    if (displayName.indexOf(40) > -1) {
                        displayName = displayName.substring(0, displayName.indexOf(40)).trim();
                    }
                    xml.openTag(FEATUREQUAL_TAG);
                    xml.openTag(FEATUREQUAL_NAME_TAG);
                    xml.print("organism");
                    xml.closeTag(FEATUREQUAL_NAME_TAG);
                    xml.openTag(FEATUREQUAL_VALUE_TAG);
                    xml.print(displayName);
                    xml.closeTag(FEATUREQUAL_VALUE_TAG);
                    xml.closeTag(FEATUREQUAL_TAG);
                }
                for (RankedCrossRef rcr : richFeature.getRankedCrossRefs()) {
                    CrossRef cr = rcr.getCrossRef();
                    xml.openTag(FEATUREQUAL_TAG);
                    xml.openTag(FEATUREQUAL_NAME_TAG);
                    xml.print("db_xref");
                    xml.closeTag(FEATUREQUAL_NAME_TAG);
                    xml.openTag(FEATUREQUAL_VALUE_TAG);
                    xml.print(cr.getDbname() + ":" + cr.getAccession());
                    xml.closeTag(FEATUREQUAL_VALUE_TAG);
                    xml.closeTag(FEATUREQUAL_TAG);
                }
                xml.closeTag(FEATUREQUALS_GROUP_TAG);
                xml.closeTag(FEATURE_TAG);
            }
            xml.closeTag(FEATURES_GROUP_TAG);
        }
        xml.openTag(SEQUENCE_TAG);
        String[] lines = StringTools.wordWrap(rs.seqString(), "\\s+", this.getLineWidth());
        boolean bl = false;
        while (var17_25 < lines.length) {
            xml.println(lines[var17_25]);
            ++var17_25;
        }
        xml.closeTag(SEQUENCE_TAG);
        xml.closeTag(INSDSEQ_TAG);
        this.pw.flush();
    }

    public String getDefaultFormat() {
        return INSDSEQ_FORMAT;
    }

    static {
        RichSequence.IOTools.registerFormat(INSDseqFormat.class);
        dbxp = Pattern.compile("^([^:]+):(\\S+)$");
        xmlSchema = Pattern.compile(".*http://www\\.ebi\\.ac\\.uk/dtd/INSD_INSDSeq\\.dtd.*");
    }

    private class INSDseqHandler
    extends DefaultHandler {
        private RichSequenceFormat parent;
        private SymbolTokenization symParser;
        private RichSeqIOListener rlistener;
        private Namespace ns;
        private StringBuffer m_currentString;
        private NCBITaxon tax;
        private String organism;
        private String accession;
        private RichFeature.Template templ;
        private String currFeatQual;
        private String currRefLocation;
        private List currRefAuthors;
        private String currRefTitle;
        private String currRefJournal;
        private String currRefPubmed;
        private String currRefRemark;
        private String currRefPosition;
        private String currRefXrefDBName;
        private String currRefXrefID;
        private List currRefXrefs;
        private int rcrossrefCount;

        private INSDseqHandler(RichSequenceFormat parent, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) {
            this.parent = parent;
            this.symParser = symParser;
            this.rlistener = rlistener;
            this.ns = ns;
            this.m_currentString = new StringBuffer();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(INSDseqFormat.INSDSEQ_TAG)) {
                try {
                    this.rlistener.startSequence();
                    if (this.ns == null) {
                        this.ns = RichObjectFactory.getDefaultNamespace();
                    }
                    this.rlistener.setNamespace(this.ns);
                }
                catch (ParseException e) {
                    throw new SAXException(e);
                }
            } else if (qName.equals(INSDseqFormat.REFERENCE_TAG) && !this.parent.getElideReferences()) {
                this.currRefLocation = null;
                this.currRefPosition = null;
                this.currRefAuthors = new ArrayList();
                this.currRefTitle = null;
                this.currRefJournal = null;
                this.currRefPubmed = null;
                this.currRefRemark = null;
                this.currRefXrefs = new ArrayList();
            } else if (qName.equals(INSDseqFormat.XREF_TAG) && !this.parent.getElideReferences()) {
                this.currRefXrefDBName = null;
                this.currRefXrefID = null;
            } else if (qName.equals(INSDseqFormat.FEATURE_TAG) && !this.parent.getElideFeatures()) {
                this.templ = new RichFeature.Template();
                this.templ.annotation = new SimpleRichAnnotation();
                this.templ.sourceTerm = Terms.getINSDseqTerm();
                this.templ.featureRelationshipSet = new TreeSet();
                this.templ.rankedCrossRefs = new TreeSet();
            }
        }

        /*
         * Unable to fully structure code
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            block74: {
                val = this.m_currentString.toString().trim();
                try {
                    block75: {
                        if (qName.equals("INSDSeq_locus")) {
                            this.rlistener.setName(val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_primary-accession")) {
                            this.accession = val;
                            this.rlistener.setAccession(this.accession);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_accession-version")) {
                            parts = val.split("\\.");
                            this.accession = parts[0];
                            this.rlistener.setAccession(this.accession);
                            if (parts.length > 1) {
                                this.rlistener.setVersion(Integer.parseInt(parts[1]));
                            }
                            break block74;
                        }
                        if (qName.equals("INSDSecondary-accn")) {
                            this.rlistener.addSequenceProperty(Terms.getAdditionalAccessionTerm(), val);
                            break block74;
                        }
                        if (qName.equals("INSDSeqid")) {
                            this.rlistener.addSequenceProperty(Terms.getOtherSeqIdTerm(), val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_division")) {
                            this.rlistener.setDivision(val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_moltype")) {
                            this.rlistener.addSequenceProperty(Terms.getMolTypeTerm(), val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_update-date")) {
                            this.rlistener.addSequenceProperty(Terms.getDateUpdatedTerm(), val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_update-release")) {
                            this.rlistener.addSequenceProperty(Terms.getRelUpdatedTerm(), val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_create-date")) {
                            this.rlistener.addSequenceProperty(Terms.getDateCreatedTerm(), val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_create-release")) {
                            this.rlistener.addSequenceProperty(Terms.getRelCreatedTerm(), val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_strandedness")) {
                            this.rlistener.addSequenceProperty(Terms.getStrandedTerm(), val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_topology")) {
                            if ("circular".equals(val)) {
                                this.rlistener.setCircular(true);
                            }
                            break block74;
                        }
                        if (qName.equals("INSDSeq_definition")) {
                            this.rlistener.setDescription(val);
                            break block74;
                        }
                        if (qName.equals("INSDKeyword")) {
                            this.rlistener.addSequenceProperty(Terms.getKeywordTerm(), val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_comment") && !this.parent.getElideComments()) {
                            this.rlistener.setComment(val);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_database-reference")) {
                            parts = val.split(";");
                            crossRef = (CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{parts[0].trim(), parts[1].trim(), new Integer(0)});
                            for (j = 2; j < parts.length; ++j) {
                                note = new SimpleNote(Terms.getAdditionalAccessionTerm(), parts[j].trim(), j - 1);
                                try {
                                    crossRef.getRichAnnotation().addNote(note);
                                    continue;
                                }
                                catch (ChangeVetoException ce) {
                                    pe = new ParseException("Could not annotate identifier terms");
                                    pe.initCause(ce);
                                    throw pe;
                                }
                            }
                            rcrossRef = new SimpleRankedCrossRef(crossRef, 0);
                            this.rlistener.setRankedCrossRef(rcrossRef);
                            break block74;
                        }
                        if (qName.equals("INSDSeq_sequence") && !this.parent.getElideSymbols()) {
                            try {
                                sl = new SimpleSymbolList(this.symParser, val.replaceAll("\\s+", "").replaceAll("[\\.|~]", "-"));
                                this.rlistener.addSymbols(this.symParser.getAlphabet(), sl.toList().toArray(new Symbol[0]), 0, sl.length());
                                break block74;
                            }
                            catch (Exception e) {
                                throw new ParseException(e);
                            }
                        }
                        if (qName.equals("INSDSeq_contig")) {
                            throw new SAXException("Cannot handle contigs yet");
                        }
                        if (qName.equals("INSDReference_reference") && !this.parent.getElideReferences()) {
                            this.currRefLocation = val;
                            break block74;
                        }
                        if (qName.equals("INSDReference_position") && !this.parent.getElideReferences()) {
                            this.currRefPosition = val;
                            break block74;
                        }
                        if (qName.equals("INSDAuthor") && !this.parent.getElideReferences()) {
                            this.currRefAuthors.add(new SimpleDocRefAuthor(val, false, false));
                            break block74;
                        }
                        if (qName.equals("INSDReference_consortium") && !this.parent.getElideReferences()) {
                            this.currRefAuthors.add(new SimpleDocRefAuthor(val, true, false));
                            break block74;
                        }
                        if (qName.equals("INSDReference_title") && !this.parent.getElideReferences()) {
                            this.currRefTitle = val;
                            break block74;
                        }
                        if (qName.equals("INSDReference_journal") && !this.parent.getElideReferences()) {
                            this.currRefJournal = val;
                            break block74;
                        }
                        if (qName.equals("INSDXref_dbname") && !this.parent.getElideReferences()) {
                            this.currRefXrefDBName = val;
                            break block74;
                        }
                        if (qName.equals("INSDXref_id") && !this.parent.getElideReferences()) {
                            this.currRefXrefID = val;
                            break block74;
                        }
                        if (qName.equals("INSDXref") && !this.parent.getElideReferences()) {
                            xr = (CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{this.currRefXrefDBName, this.currRefXrefID, new Integer(0)});
                            this.currRefXrefs.add(xr);
                            break block74;
                        }
                        if (qName.equals("INSDReference_pubmed") && !this.parent.getElideReferences()) {
                            this.currRefPubmed = val;
                            break block74;
                        }
                        if (qName.equals("INSDReference_remark") && !this.parent.getElideReferences() && !this.parent.getElideComments()) {
                            this.currRefRemark = val;
                            break block74;
                        }
                        if (qName.equals("INSDReference") && !this.parent.getElideReferences()) {
                            dcr = null;
                            if (this.currRefPubmed != null) {
                                dcr = (CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{"PUBMED", this.currRefPubmed, new Integer(0)});
                            } else {
                                pubmed = null;
                                doi = null;
                                other = null;
                                for (i = 0; i < this.currRefXrefs.size(); ++i) {
                                    cr = (CrossRef)this.currRefXrefs.get(i);
                                    if (cr.getDbname().equals("pubmed")) {
                                        pubmed = cr;
                                        continue;
                                    }
                                    if (cr.getDbname().equals("doi")) {
                                        doi = cr;
                                        continue;
                                    }
                                    other = cr;
                                }
                                dcr = pubmed != null ? pubmed : (doi != null ? doi : other);
                            }
                            try {
                                dr = (DocRef)RichObjectFactory.getObject(SimpleDocRef.class, new Object[]{this.currRefAuthors, this.currRefJournal, this.currRefTitle});
                                if (dcr != null) {
                                    dr.setCrossref(dcr);
                                }
                                dr.setRemark(this.currRefRemark);
                                if (this.currRefPosition != null) {
                                    if (this.currRefPosition.equals("") || this.currRefPosition.equals("sites")) {
                                        loc = RichLocation.EMPTY_LOCATION;
                                    } else {
                                        members = new ArrayList<Location>();
                                        parts = this.currRefPosition.split(";\\s+");
                                        for (i = 0; i < parts.length; ++i) {
                                            parts2 = parts[i].split("\\.\\.");
                                            if (parts2.length > 1) {
                                                newLoc = new SimpleRichLocation((Position)new SimplePosition(Integer.parseInt(parts2[0])), new SimplePosition(Integer.parseInt(parts2[1])), i);
                                                members.add(newLoc);
                                                continue;
                                            }
                                            newLoc = new SimpleRichLocation(new SimplePosition(Integer.parseInt(parts2[0])), i);
                                            members.add(newLoc);
                                        }
                                        loc = RichLocation.Tools.construct(members);
                                    }
                                    rdr = new SimpleRankedDocRef(dr, loc, 0);
                                    this.rlistener.setRankedDocRef(rdr);
                                } else {
                                    rdr = new SimpleRankedDocRef(dr, new Integer(1), new Integer(1), 0);
                                    this.rlistener.setRankedDocRef(rdr);
                                }
                                break block74;
                            }
                            catch (ChangeVetoException e) {
                                throw new ParseException(e);
                            }
                        }
                        if (qName.equals("INSDFeature_key") && !this.parent.getElideFeatures()) {
                            this.templ.typeTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm(val);
                            break block74;
                        }
                        if (qName.equals("INSDFeature_location") && !this.parent.getElideFeatures()) {
                            tidyLocStr = val.replaceAll("\\s+", "");
                            this.templ.location = GenbankLocationParser.parseLocation(this.ns, this.accession, tidyLocStr);
                            this.rlistener.startFeature(this.templ);
                            this.rcrossrefCount = 0;
                            break block74;
                        }
                        if (qName.equals("INSDQualifier_name") && !this.parent.getElideFeatures()) {
                            if (this.currFeatQual != null) {
                                this.rlistener.addFeatureProperty(RichObjectFactory.getDefaultOntology().getOrCreateTerm(this.currFeatQual), null);
                            }
                            this.currFeatQual = val;
                            break block74;
                        }
                        if (!qName.equals("INSDQualifier_value") || this.parent.getElideFeatures()) break block75;
                        if (!this.currFeatQual.equalsIgnoreCase("db_xref")) ** GOTO lbl206
                        m = INSDseqFormat.dbxp.matcher(val);
                        if (m.matches()) {
                            dbname = m.group(1);
                            raccession = m.group(2);
                            if (dbname.equalsIgnoreCase("taxon")) {
                                this.tax = (NCBITaxon)RichObjectFactory.getObject(SimpleNCBITaxon.class, new Object[]{Integer.valueOf(raccession)});
                                this.rlistener.setTaxon(this.tax);
                                try {
                                    if (this.organism == null) ** GOTO lbl217
                                    this.tax.addName("scientific name", this.organism);
                                }
                                catch (ChangeVetoException e) {
                                    throw new ParseException(e);
                                }
                            } else {
                                try {
                                    cr = (CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{dbname, raccession, new Integer(0)});
                                    rcr = new SimpleRankedCrossRef(cr, ++this.rcrossrefCount);
                                    this.rlistener.getCurrentFeature().addRankedCrossRef(rcr);
                                }
                                catch (ChangeVetoException e) {
                                    throw new ParseException(e);
                                }
                            }
                        } else {
                            throw new ParseException("Bad dbxref found: " + val);
lbl206:
                            // 1 sources

                            if (this.currFeatQual.equalsIgnoreCase("organism")) {
                                try {
                                    this.organism = val;
                                    if (this.tax == null) ** GOTO lbl217
                                    this.tax.addName("scientific name", this.organism);
                                }
                                catch (ChangeVetoException e) {
                                    throw new ParseException(e);
                                }
                            } else {
                                if (this.currFeatQual.equalsIgnoreCase("translation")) {
                                    val = val.replaceAll("\\s+", "");
                                }
                                this.rlistener.addFeatureProperty(RichObjectFactory.getDefaultOntology().getOrCreateTerm(this.currFeatQual), val);
                            }
                        }
lbl217:
                        // 6 sources

                        this.currFeatQual = null;
                        break block74;
                    }
                    if (qName.equals("INSDFeature") && !this.parent.getElideFeatures()) {
                        this.rlistener.endFeature();
                    } else if (qName.equals("INSDSeq")) {
                        this.rlistener.endSequence();
                    }
                }
                catch (ParseException e) {
                    throw new SAXException(e);
                }
            }
            this.m_currentString.setLength(0);
        }

        public void characters(char[] ch, int start, int length) {
            this.m_currentString.append(ch, start, length);
        }
    }

    public static class Terms
    extends RichSequence.Terms {
        public static ComparableTerm getOtherSeqIdTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("OtherSeqID");
        }

        public static ComparableTerm getINSDseqTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm(INSDseqFormat.INSDSEQ_FORMAT);
        }
    }
}

