/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.util.Algebra;

public class Bond
extends StructureComponent
implements Cloneable {
    public static final String TYPE_COVALENT = "Covalent";
    public static final String TYPE_HYDROGEN = "Hydrogen";
    public static final String TYPE_IONIC = "Ionic";
    private Atom[] atoms;
    private float order = 0.0f;
    private static String className = null;

    public Bond(Atom atom, Atom atom2) {
        this.structure = atom.structure;
        this.atoms = new Atom[2];
        this.setAtom(0, atom);
        this.setAtom(1, atom2);
    }

    public void copy(StructureComponent structureComponent) {
        this.structure = structureComponent.structure;
        Bond bond = (Bond)structureComponent;
        this.atoms[0] = bond.getAtom(0);
        this.atoms[1] = bond.getAtom(1);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Bond)) {
            return false;
        }
        Bond bond = (Bond)object;
        Atom[] atomArray = new Atom[]{bond.getAtom(0), bond.getAtom(1)};
        if (atomArray[0] == this.atoms[0] && atomArray[1] == this.atoms[1]) {
            return true;
        }
        return atomArray[0] == this.atoms[1] && atomArray[1] == this.atoms[0];
    }

    public static String getClassName() {
        if (className == null) {
            className = new Throwable().getStackTrace()[0].getClassName();
        }
        return className;
    }

    public String getStructureComponentType() {
        return className;
    }

    public String getBondType() {
        if (this.atoms == null) {
            return null;
        }
        if (this.atoms[0] == null) {
            return null;
        }
        if (this.atoms[1] == null) {
            return null;
        }
        boolean bl = this.atoms[0].element.equals("H");
        boolean bl2 = this.atoms[1].element.equals("H");
        if (bl && bl2) {
            return TYPE_HYDROGEN;
        }
        if (!bl && !bl2) {
            return TYPE_COVALENT;
        }
        if (this.atoms[0].residue_id == this.atoms[1].residue_id) {
            return TYPE_COVALENT;
        }
        return TYPE_HYDROGEN;
    }

    public float getOrder() {
        return this.order;
    }

    public void setOrder(float f) {
        if (f < 0.0f || f > 6.0f) {
            throw new IllegalArgumentException("Invalid order " + f);
        }
        this.order = f;
    }

    public double getDistance() {
        if (this.atoms == null) {
            return 0.0;
        }
        if (this.atoms[0] == null) {
            return 0.0;
        }
        if (this.atoms[1] == null) {
            return 0.0;
        }
        return Algebra.distance(this.atoms[0].coordinate, this.atoms[1].coordinate);
    }

    public static final double getDistance(Atom atom, Atom atom2) {
        return Algebra.distance(atom.coordinate, atom2.coordinate);
    }

    public Atom getAtom(int n) {
        return this.atoms[n];
    }

    public void setAtom(int n, Atom atom) {
        if (atom == null) {
            throw new IllegalArgumentException("null atom");
        }
        int n2 = n == 0 ? 1 : 0;
        if (this.atoms[n2] == atom) {
            throw new IllegalArgumentException("duplicate atom");
        }
        this.atoms[n] = atom;
    }
}

