/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Fragment;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.util.RangeMap;
import java.util.Hashtable;
import java.util.Vector;

public class Chain
extends StructureComponent
implements Cloneable {
    private Vector residues = null;
    private Hashtable residueToIndexHash = null;
    private static final String defaultChainId = "-";
    private RangeMap fragments = null;
    private Vector fragmentObjects = null;
    private static String className = null;

    public void copy(StructureComponent structureComponent) {
        this.structure = structureComponent.structure;
        Chain chain = (Chain)structureComponent;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getClassName() {
        if (className == null) {
            className = new Throwable().getStackTrace()[0].getClassName();
        }
        return className;
    }

    public String getStructureComponentType() {
        return className;
    }

    public String getClassification() {
        int n;
        if (this.residues == null) {
            return null;
        }
        int n2 = this.residues.size();
        if (n2 <= 0) {
            return null;
        }
        int n3 = Residue.COMPOUND_CLASSIFICATIONS.length;
        int[] nArray = new int[n3];
        block0: for (n = 0; n < n2; ++n) {
            Residue residue = (Residue)this.residues.elementAt(n);
            String string = residue.getClassification();
            for (int i = 0; i < n3; ++i) {
                if (string != Residue.COMPOUND_CLASSIFICATIONS[i]) continue;
                int n4 = i;
                nArray[n4] = nArray[n4] + 1;
                continue block0;
            }
        }
        n = -1;
        int n5 = -1;
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
            n5 = i;
        }
        if (n5 < 0) {
            return null;
        }
        return Residue.COMPOUND_CLASSIFICATIONS[n5];
    }

    public String getChainId() {
        if (this.residues == null) {
            return defaultChainId;
        }
        Residue residue = this.getResidue(0);
        if (residue == null) {
            return defaultChainId;
        }
        int n = residue.getAtomCount();
        if (n <= 0) {
            return defaultChainId;
        }
        Atom atom = residue.getAtom(0);
        if (atom == null) {
            return defaultChainId;
        }
        return atom.chain_id;
    }

    public int getAtomCount() {
        int n = 0;
        int n2 = this.getResidueCount();
        for (int i = 0; i < n2; ++i) {
            Residue residue = (Residue)this.residues.elementAt(i);
            if (residue == null) continue;
            n += residue.getAtomCount();
        }
        return n;
    }

    public int getResidueCount() {
        if (this.residues == null) {
            return 0;
        }
        return this.residues.size();
    }

    public Residue getResidue(int n) {
        if (this.residues == null) {
            throw new IndexOutOfBoundsException("chain has no residues");
        }
        return (Residue)this.residues.elementAt(n);
    }

    public int getResidueIndex(Residue residue) {
        if (this.residues == null) {
            throw new IndexOutOfBoundsException("chain has no residues");
        }
        Integer n = (Integer)this.residueToIndexHash.get(residue);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void addResidue(Residue residue) {
        if (residue == null) {
            throw new IllegalArgumentException("null residue");
        }
        if (this.residues == null) {
            this.residues = new Vector();
            this.residueToIndexHash = new Hashtable();
        }
        this.residueToIndexHash.put(residue, new Integer(this.residues.size()));
        this.residues.add(residue);
        if (this.fragments == null) {
            this.fragments = new RangeMap(0, 0, "UNDEFINED_CONFORMATION");
            this.fragments.setCollapseOn(false);
            this.fragments.setValue(0, residue.getConformationType());
        } else {
            this.fragments.append(residue.getConformationType());
        }
        this.fragmentObjects = null;
    }

    public void removeAllResidues() {
        if (this.residues == null) {
            return;
        }
        this.residues.removeAllElements();
        this.residues = null;
        this.residueToIndexHash = null;
        this.fragments = null;
        this.fragmentObjects = null;
    }

    public void removeResidue(int n) {
        if (this.residues == null) {
            throw new IndexOutOfBoundsException("chain has no residues");
        }
        Residue residue = (Residue)this.residues.elementAt(n);
        this.residueToIndexHash.remove(residue);
        this.residues.remove(n);
        this.fragments.remove(n);
        if (this.getResidueCount() == 0) {
            this.fragments = null;
        }
        this.fragmentObjects = null;
    }

    public void setFragment(int n, int n2, String string) {
        if (this.residues == null) {
            throw new IndexOutOfBoundsException("chain has no residues");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("start index < 0");
        }
        if (n2 >= this.getResidueCount()) {
            throw new IndexOutOfBoundsException("end index >= residue count");
        }
        if (n > n2) {
            throw new IllegalArgumentException("start > end (" + n + ">" + n2 + ")");
        }
        this.fragmentObjects = null;
        this.fragments.setRange(n, n2, string);
        for (int i = n; i <= n2; ++i) {
            Residue residue = this.getResidue(i);
            residue.setConformationType(string);
        }
    }

    public int getFragmentCount() {
        if (this.residues == null) {
            return 0;
        }
        if (this.fragments == null) {
            return 0;
        }
        return this.fragments.getRangeCount();
    }

    public String getFragmentType(int n) {
        if (this.fragments == null) {
            throw new IndexOutOfBoundsException("chain has no fragments");
        }
        return (String)this.fragments.getRangeValue(n);
    }

    public int getFragmentStartResidue(int n) {
        if (this.fragments == null) {
            throw new IndexOutOfBoundsException("chain has no fragments");
        }
        return this.fragments.getRangeStart(n);
    }

    public int getFragmentEndResidue(int n) {
        if (this.fragments == null) {
            throw new IndexOutOfBoundsException("chain has no fragments");
        }
        return this.fragments.getRangeEnd(n);
    }

    public void generateFragments() {
        if (this.fragments == null) {
            return;
        }
        if (this.fragmentObjects != null) {
            this.fragmentObjects.clear();
        }
        int n = this.getFragmentCount();
        this.fragmentObjects = new Vector(n);
        for (int i = 0; i < n; ++i) {
            String string = (String)this.fragments.getRangeValue(i);
            int[] nArray = this.fragments.getRange(i);
            Fragment fragment = new Fragment(nArray[0], nArray[1], string);
            fragment.setChain(this);
            fragment.structure = this.structure;
            for (int j = nArray[0]; j <= nArray[1]; ++j) {
                Residue residue = this.getResidue(j);
                residue.setFragment(fragment);
            }
            this.fragmentObjects.add(fragment);
        }
    }

    public Fragment getFragment(int n) {
        if (this.fragmentObjects == null) {
            this.generateFragments();
        }
        return (Fragment)this.fragmentObjects.elementAt(n);
    }
}

