/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt;

import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.StructureComponent;

public class Fragment
extends StructureComponent
implements Cloneable {
    private Chain chain = null;
    private int startResidueIndex = -1;
    private int endResidueIndex = -1;
    private String conformationType = "UNDEFINED_CONFORMATION";
    private static String className = null;

    protected Fragment(int n, int n2, String string) {
        this.startResidueIndex = n;
        this.endResidueIndex = n2;
        this.conformationType = string;
    }

    protected Fragment() {
        this.startResidueIndex = -1;
        this.endResidueIndex = -1;
        this.conformationType = "UNDEFINED_CONFORMATION";
    }

    protected void setChain(Chain chain) {
        this.chain = chain;
    }

    public Chain getChain() {
        return this.chain;
    }

    public void copy(StructureComponent structureComponent) {
        this.structure = structureComponent.structure;
        Fragment fragment = (Fragment)structureComponent;
        this.startResidueIndex = fragment.startResidueIndex;
        this.endResidueIndex = fragment.endResidueIndex;
        this.conformationType = fragment.conformationType;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getClassName() {
        if (className == null) {
            className = new Throwable().getStackTrace()[0].getClassName();
        }
        return className;
    }

    public String getStructureComponentType() {
        return className;
    }

    public void setStartResidueIndex(int n) {
        if (this.chain == null) {
            throw new NullPointerException("Fragment has no chain");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("index < 0");
        }
        if (n >= this.chain.getResidueCount()) {
            throw new IndexOutOfBoundsException("index >= count");
        }
        this.startResidueIndex = n;
    }

    public int getStartResidueIndex() {
        return this.startResidueIndex;
    }

    public void setEndResidueIndex(int n) {
        if (this.chain == null) {
            throw new NullPointerException("Fragment has no chain");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("index < 0");
        }
        if (n >= this.chain.getResidueCount()) {
            throw new IndexOutOfBoundsException("index >= count");
        }
        this.endResidueIndex = n;
    }

    public int getEndResidueIndex() {
        return this.endResidueIndex;
    }

    public int getResidueCount() {
        return this.endResidueIndex - this.startResidueIndex + 1;
    }

    public Residue getResidue(int n) {
        if (this.chain == null) {
            throw new NullPointerException("Fragment has no chain");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("index < 0");
        }
        if (n >= this.getResidueCount()) {
            throw new IndexOutOfBoundsException("index " + n + " >= " + this.getResidueCount());
        }
        return this.chain.getResidue(n + this.startResidueIndex);
    }

    public void setConformationType(String string) {
        this.conformationType = string;
    }

    public String getConformationType() {
        return this.conformationType;
    }
}

