/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Fragment;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.util.AminoAcidInfo;
import edu.sdsc.mbt.util.NucleicAcidInfo;
import java.util.Vector;

public class Residue
extends StructureComponent
implements Cloneable {
    public static final String COMPOUND_AMINO_ACID = "Amino Acid";
    public static final String COMPOUND_NUCLEIC_ACID = "Nucleic Acid";
    public static final String COMPOUND_LIGAND = "Ligand";
    public static final String[] COMPOUND_CLASSIFICATIONS = new String[]{"Amino Acid", "Nucleic Acid", "Ligand"};
    private int alphaAtomIndex = -1;
    private static final String aaAlphaAtomName = "CA";
    private static final String naAlphaAtomName = "P";
    private Vector atoms = null;
    private Fragment parentFragment = null;
    private String compoundCode = "UNK";
    private String classification = "Ligand";
    private String conformationType = "UNDEFINED_CONFORMATION";
    private Atom polymerHeadAtom = null;
    private Atom polymerTailAtom = null;
    private static final String aaHeadAtomName = "N";
    private static final String aaTailAtomName = "C";
    private static final String naHeadAtomName = "P";
    private static final String naTailAtomName = "O3'";
    private static String className = null;

    public Residue(String string) {
        this.compoundCode = string;
    }

    public Residue() {
    }

    public void copy(StructureComponent structureComponent) {
        this.structure = structureComponent.structure;
        Residue residue = (Residue)structureComponent;
        this.compoundCode = residue.compoundCode;
        this.alphaAtomIndex = residue.alphaAtomIndex;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getClassName() {
        if (className == null) {
            className = new Throwable().getStackTrace()[0].getClassName();
        }
        return className;
    }

    public String getStructureComponentType() {
        return className;
    }

    protected void setFragment(Fragment fragment) {
        this.parentFragment = fragment;
    }

    public Fragment getFragment() {
        return this.parentFragment;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setCompoundCode(String string) {
        this.compoundCode = string;
        this.classification = AminoAcidInfo.getNameFromCode(string) != null ? COMPOUND_AMINO_ACID : (NucleicAcidInfo.getNameFromLetter(string) != null ? COMPOUND_NUCLEIC_ACID : COMPOUND_LIGAND);
    }

    public String getCompoundCode() {
        return this.compoundCode;
    }

    public int getAtomCount() {
        if (this.atoms == null) {
            return 0;
        }
        return this.atoms.size();
    }

    public Atom getAtom(int n) {
        if (this.atoms == null) {
            throw new IndexOutOfBoundsException("residue has no atoms");
        }
        return (Atom)this.atoms.elementAt(n);
    }

    public Vector getAtoms() {
        return this.atoms;
    }

    public void addAtom(Atom atom) {
        if (atom == null) {
            throw new IllegalArgumentException("null atom");
        }
        if (this.atoms == null) {
            this.atoms = new Vector();
            this.setCompoundCode(atom.compound);
        }
        int n = 0;
        int n2 = this.atoms.size();
        int n3 = n2 - 1;
        int n4 = 0;
        int n5 = atom.number;
        while (n <= n3) {
            n4 = (n + n3) / 2;
            Atom atom2 = (Atom)this.atoms.elementAt(n4);
            int n6 = atom2.number;
            if (n5 < n6) {
                n3 = n4 - 1;
                continue;
            }
            n = n4 + 1;
        }
        n4 = (n + n3) / 2;
        n4 = n4 < 0 ? 0 : (n4 >= n2 ? n2 : ++n4);
        this.atoms.add(n4, atom);
        if (this.classification == COMPOUND_AMINO_ACID) {
            if (atom.name.equals(aaAlphaAtomName) && this.alphaAtomIndex < 0) {
                this.alphaAtomIndex = n4;
            }
            if (atom.name.equals(aaHeadAtomName)) {
                this.polymerHeadAtom = atom;
            }
            if (atom.name.equals(aaTailAtomName)) {
                this.polymerTailAtom = atom;
            }
        } else if (this.classification == COMPOUND_NUCLEIC_ACID) {
            if (atom.name.equals("P") && this.alphaAtomIndex < 0) {
                this.alphaAtomIndex = n4;
            }
            if (atom.name.equals("P")) {
                this.polymerHeadAtom = atom;
            }
            if (atom.name.equals(naTailAtomName)) {
                this.polymerTailAtom = atom;
            }
        }
    }

    public void removeAllAtoms() {
        if (this.atoms != null) {
            this.atoms.removeAllElements();
        }
        this.atoms = null;
        this.setCompoundCode("UNK");
        this.alphaAtomIndex = -1;
        this.polymerHeadAtom = null;
        this.polymerTailAtom = null;
    }

    public void removeAtom(int n) {
        if (this.atoms == null) {
            throw new IndexOutOfBoundsException("residue has no atoms");
        }
        Atom atom = this.getAtom(n);
        this.atoms.remove(n);
        if (n == this.alphaAtomIndex) {
            this.alphaAtomIndex = -1;
        }
        if (n < this.alphaAtomIndex) {
            --this.alphaAtomIndex;
        }
        if (this.alphaAtomIndex < 0) {
            this.alphaAtomIndex = -1;
        }
        if (this.atoms.size() <= 0) {
            this.removeAllAtoms();
        }
        if (this.classification == COMPOUND_AMINO_ACID) {
            if (atom.name.equals(aaHeadAtomName)) {
                this.polymerHeadAtom = null;
            } else if (atom.name.equals(aaTailAtomName)) {
                this.polymerTailAtom = null;
            }
        } else if (this.classification == COMPOUND_NUCLEIC_ACID) {
            if (atom.name.equals("P")) {
                this.polymerHeadAtom = null;
            } else if (atom.name.equals(naTailAtomName)) {
                this.polymerTailAtom = null;
            }
        }
    }

    public int getAlphaAtomIndex() {
        return this.alphaAtomIndex;
    }

    public void setAlphaAtomIndex(int n) {
        this.alphaAtomIndex = n;
    }

    public Atom getAlphaAtom() {
        if (this.atoms == null) {
            return null;
        }
        if (this.alphaAtomIndex < 0) {
            return null;
        }
        if (this.alphaAtomIndex >= this.atoms.size()) {
            return null;
        }
        return (Atom)this.atoms.elementAt(this.alphaAtomIndex);
    }

    public Atom getPolymerHeadAtom() {
        return this.polymerHeadAtom;
    }

    public Atom getPolymerTailAtom() {
        return this.polymerTailAtom;
    }

    public float getHydrophobicity() {
        return AminoAcidInfo.getHydrophobicityFromCode(this.compoundCode);
    }

    public void setConformationType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null type");
        }
        this.conformationType = string;
    }

    public String getConformationType() {
        return this.conformationType;
    }

    public String getChainId() {
        if (this.atoms == null) {
            return null;
        }
        Atom atom = (Atom)this.atoms.elementAt(0);
        if (atom == null) {
            return null;
        }
        return atom.chain_id;
    }

    public int getResidueId() {
        if (this.atoms == null) {
            return -1;
        }
        Atom atom = (Atom)this.atoms.elementAt(0);
        if (atom == null) {
            return -1;
        }
        return atom.residue_id;
    }
}

