/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt;

import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentIterator;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureComponentRelation;
import edu.sdsc.mbt.StructureInfo;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.filters.RelationFilter;
import edu.sdsc.mbt.filters.StructureComponentFilter;
import edu.sdsc.mbt.util.Status;

public abstract class Structure {
    private StructureMap structureMap = null;
    private StructureInfo structureInfo = null;

    public abstract String getUrlString();

    public abstract int getStructureComponentCount(String var1);

    public StructureComponentIterator createStructureComponentIterator(StructureComponentFilter structureComponentFilter) {
        try {
            return new StructureComponentIterator(this, structureComponentFilter);
        }
        catch (Exception exception) {
            Status.output(1, "Structure.createStructureComponentIterator: exception = " + exception + " (perhaps a bad filter?)");
            return null;
        }
    }

    public StructureComponentIterator getStructureComponentRelations(String string, StructureComponent structureComponent) throws IllegalArgumentException {
        StructureComponentRelation structureComponentRelation = StructureComponentRegistry.getRelation(string);
        RelationFilter relationFilter = new RelationFilter(structureComponentRelation, structureComponent);
        return this.createStructureComponentIterator(relationFilter);
    }

    public abstract StructureComponent getStructureComponentByIndex(String var1, int var2) throws IndexOutOfBoundsException, IllegalArgumentException;

    public StructureMap getStructureMap() {
        if (this.structureMap == null) {
            this.structureMap = new StructureMap(this);
        }
        return this.structureMap;
    }

    public void setStructureInfo(StructureInfo structureInfo) {
        this.structureInfo = structureInfo;
    }

    public StructureInfo getStructureInfo() {
        return this.structureInfo;
    }
}

