/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt;

import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.filters.StructureComponentFilter;
import java.util.NoSuchElementException;

public class StructureComponentIterator {
    private Structure structure;
    private StructureComponentFilter filter;
    private String type;
    private int count;
    private int index;
    private boolean foundNext;
    private StructureComponent tmpStructureComponent;

    public StructureComponentIterator(Structure structure, StructureComponentFilter structureComponentFilter) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.structure = structure;
        this.filter = structureComponentFilter;
        this.type = structureComponentFilter.type();
        this.count = structure.getStructureComponentCount(this.type);
        this.index = 0;
        this.foundNext = false;
    }

    public boolean hasMore() {
        if (this.foundNext) {
            return true;
        }
        while (this.index < this.count) {
            this.tmpStructureComponent = this.structure.getStructureComponentByIndex(this.type, this.index);
            if (this.filter.accept(this.tmpStructureComponent)) {
                this.foundNext = true;
                return true;
            }
            ++this.index;
        }
        this.foundNext = false;
        return false;
    }

    public int nextIndex() {
        if (this.hasMore()) {
            return this.index;
        }
        return -1;
    }

    public void next(StructureComponent structureComponent) throws NoSuchElementException {
        if (this.type != structureComponent.getStructureComponentType()) {
            throw new NoSuchElementException("StructureComponentIterator.next: type mismatch");
        }
        if (this.hasMore()) {
            structureComponent.copy(this.tmpStructureComponent);
            ++this.index;
            this.foundNext = false;
            return;
        }
    }
}

