/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Coil;
import edu.sdsc.mbt.Fragment;
import edu.sdsc.mbt.Helix;
import edu.sdsc.mbt.Relation_Conformation_Atom;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Strand;
import edu.sdsc.mbt.StructureComponentRelation;
import edu.sdsc.mbt.Turn;
import java.util.Enumeration;
import java.util.Hashtable;

public class StructureComponentRegistry {
    private static Hashtable types = new Hashtable();
    private static Hashtable relations = new Hashtable();
    public static final String TYPE_STRUCTURE = null;
    public static final String TYPE_CHAIN;
    public static final String TYPE_COIL;
    public static final String TYPE_HELIX;
    public static final String TYPE_STRAND;
    public static final String TYPE_TURN;
    public static final String TYPE_RESIDUE;
    public static final String TYPE_FRAGMENT;
    public static final String TYPE_ATOM;
    public static final String TYPE_BOND;
    public static final String TYPE_MODEL;
    public static final String TYPE_ACTIVE_SITE;
    public static final String TYPE_POLYMER;
    public static final String TYPE_NONPOLYMER;
    public static final String TYPE_DISULPHIDE;
    public static final String TYPE_SALT_BRIDGE;
    public static final String RELATION_CONFORMATION_ATOMS;

    public static int getTypeCount() {
        return types.size();
    }

    public static void addType(String string) {
        types.put(string, string);
    }

    public static void removeType(String string) {
        types.remove(string);
    }

    public static String getTypeName(String string) {
        return (String)types.get(string);
    }

    public static Enumeration getTypeNames() {
        return types.keys();
    }

    public static int getRelationCount() {
        return relations.size();
    }

    public static void addRelation(StructureComponentRelation structureComponentRelation) {
        relations.put(structureComponentRelation.getName(), structureComponentRelation);
    }

    public static StructureComponentRelation getRelation(String string) {
        return (StructureComponentRelation)relations.get(string);
    }

    public static void removeRelation(String string) {
        relations.remove(string);
    }

    public static Enumeration getRelationNames() {
        return relations.keys();
    }

    static {
        TYPE_MODEL = null;
        TYPE_ACTIVE_SITE = null;
        TYPE_POLYMER = null;
        TYPE_NONPOLYMER = null;
        TYPE_DISULPHIDE = null;
        TYPE_SALT_BRIDGE = null;
        TYPE_ATOM = Atom.getClassName();
        StructureComponentRegistry.addType(TYPE_ATOM);
        TYPE_BOND = Bond.getClassName();
        StructureComponentRegistry.addType(TYPE_BOND);
        TYPE_RESIDUE = Residue.getClassName();
        StructureComponentRegistry.addType(TYPE_RESIDUE);
        TYPE_FRAGMENT = Fragment.getClassName();
        StructureComponentRegistry.addType(TYPE_FRAGMENT);
        TYPE_CHAIN = Chain.getClassName();
        StructureComponentRegistry.addType(TYPE_CHAIN);
        TYPE_COIL = Coil.getClassName();
        StructureComponentRegistry.addType(TYPE_COIL);
        TYPE_HELIX = Helix.getClassName();
        StructureComponentRegistry.addType(TYPE_HELIX);
        TYPE_STRAND = Strand.getClassName();
        StructureComponentRegistry.addType(TYPE_STRAND);
        TYPE_TURN = Turn.getClassName();
        StructureComponentRegistry.addType(TYPE_TURN);
        Relation_Conformation_Atom relation_Conformation_Atom = new Relation_Conformation_Atom();
        StructureComponentRegistry.addRelation(relation_Conformation_Atom);
        RELATION_CONFORMATION_ATOMS = relation_Conformation_Atom.getName();
    }
}

