/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Coil;
import edu.sdsc.mbt.Conformation;
import edu.sdsc.mbt.Fragment;
import edu.sdsc.mbt.Helix;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Strand;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.Turn;
import edu.sdsc.mbt.util.AtomStats;
import edu.sdsc.mbt.util.BondFactory;
import edu.sdsc.mbt.util.DerivedInformation;
import edu.sdsc.mbt.util.Status;
import edu.sdsc.mbt.viewables.StructureStyles;
import java.util.Hashtable;
import java.util.Vector;

public class StructureMap {
    private Structure structure;
    private Vector atoms = null;
    private Vector residues = null;
    private Vector fragments = null;
    private Vector chains = null;
    private Vector ligands = null;
    private Vector bonds = null;
    private Hashtable bondUniqueness = null;
    private Hashtable atomToBonds = null;
    private Hashtable chainById = null;
    private Hashtable residueByChainAndResidueId = null;
    public static final String defaultChainId = "_";
    private boolean generateBondsByDistance = false;
    private boolean fillDisorderedGaps = false;
    private StructureStyles structureStyles = null;

    public StructureMap(Structure structure) {
        if (structure == null) {
            throw new IllegalArgumentException("null Structure");
        }
        this.structure = structure;
        this.initialize();
        if (Status.getOutputLevel() >= 5) {
            this.print();
        }
    }

    private void initialize() {
        int n = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_ATOM);
        this.atoms = n > 0 ? new Vector(n) : new Vector();
        int n2 = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_RESIDUE);
        this.residues = n2 > 0 ? new Vector(n2) : new Vector();
        this.ligands = new Vector();
        this.residueByChainAndResidueId = new Hashtable();
        int n3 = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_BOND);
        this.bonds = n3 > 0 ? new Vector(n3) : new Vector();
        this.bondUniqueness = new Hashtable();
        this.atomToBonds = new Hashtable();
        this.chains = new Vector();
        this.chainById = new Hashtable();
        this.fragments = new Vector();
        if (n > 0) {
            this.processAtomRecords();
            this.generateFragments();
            this.extractLigands();
            this.generateBonds();
        } else if (n2 > 0) {
            this.processResidueRecords();
        }
    }

    private void processAtomRecords() {
        Residue residue;
        int n;
        int n2 = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_ATOM);
        for (n = 0; n < n2; ++n) {
            String string;
            Atom atom = (Atom)this.structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_ATOM, n);
            if (atom.chain_id.length() <= 0) {
                atom.chain_id = defaultChainId;
            }
            boolean bl = false;
            Chain chain = (Chain)this.chainById.get(atom.chain_id);
            if (chain == null) {
                chain = new Chain();
                chain.structure = this.structure;
                bl = true;
                this.chainById.put(atom.chain_id, chain);
            }
            if ((residue = (Residue)this.residueByChainAndResidueId.get(string = atom.chain_id + atom.residue_id)) == null) {
                residue = new Residue();
                residue.structure = this.structure;
                residue.addAtom(atom);
                chain.addResidue(residue);
                this.residueByChainAndResidueId.put(string, residue);
            } else {
                residue.addAtom(atom);
            }
            if (!bl) continue;
            this.addChain(chain);
        }
        n = this.getChainCount();
        for (int i = 0; i < n; ++i) {
            Chain chain = this.getChain(i);
            int n3 = chain.getResidueCount();
            for (int j = 0; j < n3; ++j) {
                residue = chain.getResidue(j);
                this.residues.add(residue);
                n2 = residue.getAtomCount();
                for (int k = 0; k < n2; ++k) {
                    Atom atom = residue.getAtom(k);
                    this.atoms.add(atom);
                }
            }
        }
    }

    private void addChain(Chain chain) {
        if (chain == null) {
            throw new IllegalArgumentException("null chain");
        }
        if (this.chains.size() < 1) {
            this.chains.add(chain);
            return;
        }
        this.chains.add(chain);
    }

    private int getConformationCount() {
        int n = 0;
        n += this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_COIL);
        n += this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_HELIX);
        n += this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_STRAND);
        return n += this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_TURN);
    }

    private void generateFragments() {
        if (this.getConformationCount() > 0) {
            this.loadFragments();
        } else {
            try {
                this.deriveFragments();
            }
            catch (Exception exception) {
                this.loadFragments();
            }
        }
        int n = this.getChainCount();
        for (int i = 0; i < n; ++i) {
            Chain chain = this.getChain(i);
            chain.generateFragments();
            int n2 = chain.getFragmentCount();
            for (int j = 0; j < n2; ++j) {
                Fragment fragment = chain.getFragment(j);
                this.fragments.add(fragment);
            }
        }
    }

    public void setFillDisorderedGaps(boolean bl) {
        this.fillDisorderedGaps = bl;
    }

    public boolean getFillDisorderedGaps() {
        return this.fillDisorderedGaps;
    }

    private void loadFragments() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n8;
        int n9 = this.getChainCount();
        for (int i = 0; i < n9; ++i) {
            Chain chain = (Chain)this.chains.elementAt(i);
            n8 = chain.getResidueCount();
            chain.setFragment(0, n8 - 1, "UNDEFINED_CONFORMATION");
        }
        Object object5 = null;
        int n10 = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_COIL);
        for (n8 = 0; n8 < n10; ++n8) {
            int n11;
            Coil coil = (Coil)this.structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_COIL, n8);
            object5 = coil;
            object4 = defaultChainId;
            if (((Conformation)object5).start_chain.length() > 0) {
                object4 = ((Conformation)object5).start_chain;
            }
            object3 = (Chain)this.chainById.get(object4);
            object2 = (String)object4 + ((Conformation)object5).start_residue;
            object = (Residue)this.residueByChainAndResidueId.get(object2);
            if (object == null || (n11 = ((Chain)object3).getResidueIndex((Residue)object)) < 0) continue;
            n7 = ((Conformation)object5).end_residue - ((Conformation)object5).start_residue;
            if (((Conformation)object5).end_residue < ((Conformation)object5).start_residue) {
                Status.output(2, "Skipping reversed conformation record in chain " + (String)object4 + " at residue " + ((Conformation)object5).start_residue);
                continue;
            }
            if (n11 + n7 >= ((Chain)object3).getResidueCount()) {
                Status.output(2, "Skipping oversized conformation record in chain " + (String)object4 + " at residue " + ((Conformation)object5).start_residue);
                continue;
            }
            ((Chain)object3).setFragment(n11, n11 + n7, StructureComponentRegistry.TYPE_COIL);
        }
        n8 = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_HELIX);
        for (n6 = 0; n6 < n8; ++n6) {
            object5 = object4 = (Helix)this.structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_HELIX, n6);
            object3 = defaultChainId;
            if (((Conformation)object5).start_chain.length() > 0) {
                object3 = ((Conformation)object5).start_chain;
            }
            object2 = (Chain)this.chainById.get(object3);
            object = (String)object3 + ((Conformation)object5).start_residue;
            Residue residue = (Residue)this.residueByChainAndResidueId.get(object);
            if (residue == null || (n7 = ((Chain)object2).getResidueIndex(residue)) < 0) continue;
            n5 = ((Conformation)object5).end_residue - ((Conformation)object5).start_residue;
            if (((Conformation)object5).end_residue < ((Conformation)object5).start_residue) {
                Status.output(2, "Skipping reversed conformation record in chain " + (String)object3 + " at residue " + ((Conformation)object5).start_residue);
                continue;
            }
            if (n7 + n5 >= ((Chain)object2).getResidueCount()) {
                Status.output(2, "Skipping oversized conformation record in chain " + (String)object3 + " at residue " + ((Conformation)object5).start_residue);
                continue;
            }
            ((Chain)object2).setFragment(n7, n7 + n5, StructureComponentRegistry.TYPE_HELIX);
        }
        n6 = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_STRAND);
        for (n4 = 0; n4 < n6; ++n4) {
            object5 = object3 = (Strand)this.structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_STRAND, n4);
            object2 = defaultChainId;
            if (((Conformation)object5).start_chain.length() > 0) {
                object2 = ((Conformation)object5).start_chain;
            }
            object = (Chain)this.chainById.get(object2);
            String string = (String)object2 + ((Conformation)object5).start_residue;
            Residue residue = (Residue)this.residueByChainAndResidueId.get(string);
            if (residue == null || (n5 = ((Chain)object).getResidueIndex(residue)) < 0) continue;
            n3 = ((Conformation)object5).end_residue - ((Conformation)object5).start_residue;
            if (((Conformation)object5).end_residue < ((Conformation)object5).start_residue) {
                Status.output(2, "Skipping reversed conformation record in chain " + (String)object2 + " at residue " + ((Conformation)object5).start_residue);
                continue;
            }
            if (n5 + n3 >= ((Chain)object).getResidueCount()) {
                Status.output(2, "Skipping oversized conformation record in chain " + (String)object2 + " at residue " + ((Conformation)object5).start_residue);
                continue;
            }
            ((Chain)object).setFragment(n5, n5 + n3, StructureComponentRegistry.TYPE_STRAND);
        }
        n4 = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_TURN);
        for (n2 = 0; n2 < n4; ++n2) {
            object5 = object2 = (Turn)this.structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_TURN, n2);
            object = defaultChainId;
            if (((Conformation)object5).start_chain.length() > 0) {
                object = ((Conformation)object5).start_chain;
            }
            Chain chain = (Chain)this.chainById.get(object);
            String string = (String)object + ((Conformation)object5).start_residue;
            Residue residue = (Residue)this.residueByChainAndResidueId.get(string);
            if (residue == null || (n3 = chain.getResidueIndex(residue)) < 0) continue;
            n = ((Conformation)object5).end_residue - ((Conformation)object5).start_residue;
            if (((Conformation)object5).end_residue < ((Conformation)object5).start_residue) {
                Status.output(2, "Skipping reversed conformation record in chain " + (String)object + " at residue " + ((Conformation)object5).start_residue);
                continue;
            }
            if (n3 + n >= chain.getResidueCount()) {
                Status.output(2, "Skipping oversized conformation record in chain " + (String)object + " at residue " + ((Conformation)object5).start_residue);
                continue;
            }
            chain.setFragment(n3, n3 + n, StructureComponentRegistry.TYPE_TURN);
        }
        for (n2 = 0; n2 < n9; ++n2) {
            int n12;
            object2 = (Chain)this.chains.elementAt(n2);
            int n13 = ((Chain)object2).getResidueCount();
            if (n13 < 2 || ((Chain)object2).getFragmentCount() == 1 && ((Chain)object2).getFragmentType(0) == "UNDEFINED_CONFORMATION") continue;
            for (n12 = 0; n12 < n13; ++n12) {
                Residue residue = ((Chain)object2).getResidue(n12);
                String string = residue.getClassification();
                if (string != "Amino Acid" && string != "Nucleic Acid") {
                    ((Chain)object2).setFragment(n12, n12, "UNDEFINED_CONFORMATION");
                    continue;
                }
                if (residue.getAlphaAtomIndex() >= 0) {
                    String string2 = residue.getConformationType();
                    if (string2 != "UNDEFINED_CONFORMATION") continue;
                    ((Chain)object2).setFragment(n12, n12, StructureComponentRegistry.TYPE_COIL);
                    continue;
                }
                if (this.fillDisorderedGaps) {
                    int n14 = residue.getAtomCount() / 2;
                    residue.setAlphaAtomIndex(n14);
                    ((Chain)object2).setFragment(n12, n12, StructureComponentRegistry.TYPE_COIL);
                    continue;
                }
                ((Chain)object2).setFragment(n12, n12, "UNDEFINED_CONFORMATION");
            }
            for (n12 = 1; n12 < ((Chain)object2).getFragmentCount(); ++n12) {
                String string = ((Chain)object2).getFragmentType(n12);
                int n15 = ((Chain)object2).getFragmentStartResidue(n12);
                int n16 = ((Chain)object2).getFragmentEndResidue(n12);
                n = n16 - n15;
                if (n >= 3 || string == "UNDEFINED_CONFORMATION" || string == StructureComponentRegistry.TYPE_COIL) continue;
                ((Chain)object2).setFragment(n15, n16, StructureComponentRegistry.TYPE_COIL);
            }
            int[] nArray = new int[2];
            int n17 = ((Chain)object2).getFragmentCount();
            if (n17 <= 0) continue;
            String string = ((Chain)object2).getFragmentType(0);
            int[] nArray2 = new int[]{((Chain)object2).getFragmentStartResidue(0), ((Chain)object2).getFragmentEndResidue(0)};
            for (n = 1; n < ((Chain)object2).getFragmentCount(); ++n) {
                String string3 = ((Chain)object2).getFragmentType(n);
                nArray[0] = ((Chain)object2).getFragmentStartResidue(n);
                nArray[1] = ((Chain)object2).getFragmentEndResidue(n);
                if (string3 == StructureComponentRegistry.TYPE_COIL && string == StructureComponentRegistry.TYPE_COIL) {
                    Residue residue = ((Chain)object2).getResidue(nArray2[1]);
                    Residue residue2 = ((Chain)object2).getResidue(nArray[0]);
                    int n18 = residue2.getResidueId() - residue.getResidueId();
                    if (n18 <= 1) {
                        ((Chain)object2).setFragment(nArray2[0], nArray[1], StructureComponentRegistry.TYPE_COIL);
                        --n;
                        string = string3;
                        nArray2[1] = nArray[1];
                        continue;
                    }
                    ((Chain)object2).setFragment(nArray[0], nArray[1], StructureComponentRegistry.TYPE_COIL);
                    string = string3;
                    nArray2[0] = nArray[0];
                    nArray2[1] = nArray[1];
                    continue;
                }
                string = string3;
                nArray2[0] = nArray[0];
                nArray2[1] = nArray[1];
            }
        }
    }

    private void deriveFragments() {
        DerivedInformation derivedInformation = new DerivedInformation(this.structure, this);
        derivedInformation.setConformationType(this.residues);
    }

    private void processResidueRecords() {
        int n = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_RESIDUE);
        if (n <= 0) {
            return;
        }
        Chain chain = new Chain();
        chain.structure = this.structure;
        this.addChain(chain);
        String string = chain.getChainId();
        this.chainById.put(string, chain);
        for (int i = 0; i < n; ++i) {
            Residue residue = (Residue)this.structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_RESIDUE, i);
            this.residues.add(residue);
            chain.addResidue(residue);
            String string2 = string + i;
            this.residueByChainAndResidueId.put(string2, residue);
        }
    }

    private void extractLigands() {
        int n = this.residues.size();
        for (int i = 0; i < n; ++i) {
            Residue residue = (Residue)this.residues.elementAt(i);
            String string = residue.getClassification();
            if (string != "Ligand") continue;
            this.ligands.add(residue);
        }
    }

    public Structure getStructure() {
        return this.structure;
    }

    public double[][] getAtomCoordinateBounds() {
        return AtomStats.getAtomCoordinateBounds(this.structure);
    }

    public double[] getAtomCoordinateAverage() {
        return AtomStats.getAtomCoordinateAverage(this.structure);
    }

    public int getAtomCount() {
        if (this.atoms == null) {
            return 0;
        }
        return this.atoms.size();
    }

    public Vector getAtoms() {
        if (this.atoms == null) {
            return null;
        }
        return new Vector(this.atoms);
    }

    public Atom getAtom(int n) {
        if (this.atoms == null) {
            return null;
        }
        return (Atom)this.atoms.elementAt(n);
    }

    public int getAtomIndex(Atom atom) {
        int n;
        if (atom == null) {
            throw new IllegalArgumentException("null atom");
        }
        if (this.atoms == null) {
            throw new IllegalArgumentException("no atoms!");
        }
        int n2 = 0;
        int n3 = this.atoms.size() - 1;
        while (n2 <= n3) {
            n = (n2 + n3) / 2;
            Atom atom2 = (Atom)this.atoms.elementAt(n);
            if (atom == atom2) {
                return n;
            }
            int n4 = atom.chain_id.compareTo(atom2.chain_id);
            if (n4 == 0) {
                if (atom.residue_id == atom2.residue_id) {
                    for (int i = n2; i <= n3; ++i) {
                        atom2 = (Atom)this.atoms.elementAt(i);
                        if (atom != atom2) continue;
                        return i;
                    }
                    break;
                }
                if (atom.residue_id < atom2.residue_id) {
                    n3 = n - 1;
                    continue;
                }
                n2 = n + 1;
                continue;
            }
            if (n4 < 0) {
                n3 = n - 1;
                continue;
            }
            n2 = n + 1;
        }
        n = this.atoms.size();
        for (int i = 0; i < n; ++i) {
            Atom atom3 = (Atom)this.atoms.elementAt(i);
            if (atom != atom3) continue;
            return i;
        }
        throw new IllegalArgumentException("eek, no atom found!");
    }

    public Residue getResidue(Atom atom) {
        if (atom == null) {
            return null;
        }
        if (this.residueByChainAndResidueId == null) {
            return null;
        }
        String string = atom.chain_id + atom.residue_id;
        return (Residue)this.residueByChainAndResidueId.get(string);
    }

    public Residue getResidue(String string, int n) {
        if (string == null) {
            throw new NullPointerException("null chainId");
        }
        if (n < 0) {
            throw new IllegalArgumentException("negative residueId");
        }
        if (n >= this.getResidueCount()) {
            throw new IllegalArgumentException("residueId out of bounds");
        }
        String string2 = string + n;
        return (Residue)this.residueByChainAndResidueId.get(string2);
    }

    public Chain getChain(Atom atom) {
        if (atom == null) {
            return null;
        }
        if (this.residueByChainAndResidueId == null) {
            return null;
        }
        return (Chain)this.chainById.get(atom.chain_id);
    }

    public Chain getChain(String string) {
        if (string == null) {
            return null;
        }
        if (this.chainById == null) {
            return null;
        }
        return (Chain)this.chainById.get(string);
    }

    public int getBondCount() {
        return this.bonds.size();
    }

    public Bond getBond(int n) {
        return (Bond)this.bonds.elementAt(n);
    }

    public int getBondIndex(Bond bond) {
        if (bond == null) {
            return -1;
        }
        int n = this.bonds.size();
        if (n < 1) {
            return -1;
        }
        Atom atom = bond.getAtom(0);
        if (atom == null) {
            return -1;
        }
        Atom atom2 = bond.getAtom(1);
        if (atom2 == null) {
            return -1;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = (n2 + n3) / 2;
        int n5 = bond.hashCode();
        Bond bond2 = this.getBond(n4);
        int n6 = bond2.hashCode();
        while (n2 <= n3) {
            n4 = (n2 + n3) / 2;
            bond2 = this.getBond(n4);
            n6 = bond2.hashCode();
            if (n5 < n6) {
                n3 = n4 - 1;
                continue;
            }
            if (n5 <= n6) break;
            n2 = n4 + 1;
        }
        if (n5 == n6) {
            return n4;
        }
        return -1;
    }

    public void addBond(Bond bond) {
        int n;
        if (bond == null) {
            throw new NullPointerException("null bond argument");
        }
        Atom atom = bond.getAtom(0);
        Atom atom2 = bond.getAtom(1);
        if (atom == null || atom2 == null) {
            throw new IllegalArgumentException("bond has null atom");
        }
        if (this.bondUniqueness.put(bond, bond) != null) {
            return;
        }
        for (n = 0; n <= 1; ++n) {
            Atom atom3 = bond.getAtom(n);
            Vector<Bond> vector = (Vector<Bond>)this.atomToBonds.get(atom3);
            if (vector == null) {
                vector = new Vector<Bond>();
                this.atomToBonds.put(atom3, vector);
            }
            vector.add(bond);
        }
        n = this.bonds.size();
        if (n < 1) {
            this.bonds.add(bond);
            return;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = (n2 + n3) / 2;
        int n5 = bond.hashCode();
        Bond bond2 = this.getBond(n4);
        int n6 = bond2.hashCode();
        while (n2 <= n3) {
            n4 = (n2 + n3) / 2;
            bond2 = this.getBond(n4);
            n6 = bond2.hashCode();
            if (n5 < n6) {
                n3 = n4 - 1;
                continue;
            }
            if (n5 > n6) {
                n2 = n4 + 1;
                continue;
            }
            return;
        }
        if (n5 == n6) {
            return;
        }
        if (n5 < n6) {
            this.bonds.add(n4, bond);
        } else {
            this.bonds.add(n4 + 1, bond);
        }
    }

    public void addBonds(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.addBond((Bond)vector.elementAt(i));
        }
    }

    public void removeBond(Bond bond) {
        if (bond == null) {
            return;
        }
        this.removeBond(this.getBondIndex(bond));
    }

    public void removeBond(int n) {
        if (n < 0) {
            return;
        }
        Bond bond = (Bond)this.bonds.elementAt(n);
        if (bond == null) {
            return;
        }
        this.bonds.removeElementAt(n);
        this.bondUniqueness.remove(bond);
        for (int i = 0; i <= 1; ++i) {
            Atom atom = bond.getAtom(i);
            Vector vector = (Vector)this.atomToBonds.get(atom);
            if (vector == null) continue;
            vector.remove(bond);
            if (vector.size() > 0) continue;
            this.atomToBonds.remove(atom);
        }
    }

    public void removeAllBonds() {
        this.bonds.clear();
        this.atomToBonds.clear();
        this.bondUniqueness.clear();
    }

    public Vector getBonds(Atom atom) {
        return (Vector)this.atomToBonds.get(atom);
    }

    public Vector getBonds(Vector vector) {
        Object object;
        Cloneable cloneable;
        int n;
        Hashtable<Bond, Bond> hashtable = new Hashtable<Bond, Bond>();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            cloneable = (Atom)vector.elementAt(n);
            object = this.getBonds((Atom)cloneable);
            if (object == null) continue;
            int n3 = ((Vector)object).size();
            for (int i = 0; i < n3; ++i) {
                Bond bond = (Bond)((Vector)object).elementAt(i);
                hashtable.put(bond, bond);
            }
        }
        n = hashtable.size();
        cloneable = new Vector(n);
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            ((Vector)cloneable).add(object.nextElement());
        }
        return cloneable;
    }

    public void setGenerateBondsByDistance(boolean bl) {
        this.generateBondsByDistance = bl;
    }

    public boolean getGenerateBondsByDistance() {
        return this.generateBondsByDistance;
    }

    public void generateBonds() {
        this.removeAllBonds();
        if (this.generateBondsByDistance) {
            this.addBonds(BondFactory.generateCovalentBonds(this.atoms));
        } else {
            BondFactory.generateCovalentBonds(this);
        }
        int n = this.structure.getStructureComponentCount(StructureComponentRegistry.TYPE_BOND);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Bond bond = (Bond)this.structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_BOND, i);
                this.addBond(bond);
            }
        }
        if (this.getBondCount() <= 0) {
            this.addBonds(BondFactory.generateCovalentBonds(this.atoms));
        }
    }

    public int getLigandCount() {
        if (this.ligands == null) {
            return 0;
        }
        return this.ligands.size();
    }

    public Residue getLigandResidue(int n) {
        if (this.ligands == null) {
            return null;
        }
        return (Residue)this.ligands.elementAt(n);
    }

    public int getResidueCount() {
        if (this.residues == null) {
            return 0;
        }
        return this.residues.size();
    }

    public Residue getResidue(int n) {
        if (this.residues == null) {
            return null;
        }
        return (Residue)this.residues.elementAt(n);
    }

    public int getResidueIndex(Residue residue) throws IllegalArgumentException {
        Object object;
        int n;
        if (residue == null) {
            throw new IllegalArgumentException("null residue");
        }
        if (this.residues == null) {
            throw new IllegalArgumentException("no residues");
        }
        int n2 = 0;
        int n3 = this.residues.size() - 1;
        while (n2 <= n3) {
            n = (n2 + n3) / 2;
            Residue residue2 = (Residue)this.residues.elementAt(n);
            if (residue == residue2) {
                return n;
            }
            object = residue.getChainId();
            String string = residue2.getChainId();
            if (object == null || string == null) break;
            int n4 = ((String)object).compareTo(string);
            if (n4 == 0) {
                int n5;
                int n6 = residue.getResidueId();
                if (n6 == (n5 = residue2.getResidueId())) {
                    if (residue != residue2) break;
                    return n;
                }
                if (n6 < n5) {
                    n3 = n - 1;
                    continue;
                }
                n2 = n + 1;
                continue;
            }
            if (n4 < 0) {
                n3 = n - 1;
                continue;
            }
            n2 = n + 1;
        }
        n = this.residues.size();
        for (int i = 0; i < n; ++i) {
            object = (Residue)this.residues.elementAt(i);
            if (residue != object) continue;
            return i;
        }
        return -1;
    }

    public int getFragmentCount() {
        if (this.fragments == null) {
            return 0;
        }
        return this.fragments.size();
    }

    public Fragment getFragment(int n) {
        if (this.fragments == null) {
            return null;
        }
        return (Fragment)this.fragments.elementAt(n);
    }

    public int getFragmentIndex(Fragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("null fragment");
        }
        if (this.fragments == null) {
            throw new IllegalArgumentException("no fragments!");
        }
        int n = this.fragments.size();
        for (int i = 0; i < n; ++i) {
            Fragment fragment2 = (Fragment)this.fragments.elementAt(i);
            if (fragment2 != fragment) continue;
            return i;
        }
        throw new IllegalArgumentException("eek, no fragment found!");
    }

    public int getChainCount() {
        if (this.chains == null) {
            return 0;
        }
        return this.chains.size();
    }

    public Chain getChain(int n) {
        if (this.chains == null) {
            return null;
        }
        return (Chain)this.chains.elementAt(n);
    }

    public int getChainIndex(Chain chain) {
        if (this.chains == null) {
            return -1;
        }
        int n = this.chains.size();
        for (int i = 0; i < n; ++i) {
            Chain chain2 = (Chain)this.chains.elementAt(i);
            if (chain != chain2) continue;
            return i;
        }
        return -1;
    }

    public StructureStyles getStructureStyles() {
        if (this.structureStyles == null) {
            this.structureStyles = new StructureStyles(this);
        }
        return this.structureStyles;
    }

    public int getStructureComponentCount(String string) {
        if (string == StructureComponentRegistry.TYPE_ATOM) {
            return this.atoms.size();
        }
        if (string == StructureComponentRegistry.TYPE_RESIDUE) {
            return this.residues.size();
        }
        if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
            return this.fragments.size();
        }
        if (string == StructureComponentRegistry.TYPE_CHAIN) {
            return this.chains.size();
        }
        if (string == StructureComponentRegistry.TYPE_BOND) {
            return this.bonds.size();
        }
        return this.structure.getStructureComponentCount(string);
    }

    public StructureComponent getStructureComponentByIndex(String string, int n) {
        if (string == StructureComponentRegistry.TYPE_ATOM) {
            return (Atom)this.atoms.elementAt(n);
        }
        if (string == StructureComponentRegistry.TYPE_RESIDUE) {
            return (Residue)this.residues.elementAt(n);
        }
        if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
            return (Fragment)this.fragments.elementAt(n);
        }
        if (string == StructureComponentRegistry.TYPE_CHAIN) {
            return (Chain)this.chains.elementAt(n);
        }
        if (string == StructureComponentRegistry.TYPE_BOND) {
            return (Bond)this.bonds.elementAt(n);
        }
        return this.structure.getStructureComponentByIndex(string, n);
    }

    private void print() {
        StructureComponent structureComponent;
        int n;
        System.err.println("StructureMap.print: BEGIN");
        int n2 = this.getChainCount();
        System.err.println("chainCount = " + n2);
        for (n = 0; n < n2; ++n) {
            Chain chain = this.getChain(n);
            System.err.println("chain " + n + " = { " + "id=" + chain.getChainId() + ", " + "classification=" + chain.getClassification() + ", " + "residueCount=" + chain.getResidueCount() + "}");
            int n3 = chain.getResidueCount();
            for (int i = 0; i < n3; ++i) {
                structureComponent = chain.getResidue(i);
                System.err.println("   residue " + i + " = { " + "compoundCode=" + ((Residue)structureComponent).getCompoundCode() + ", " + "hydrophobicity=" + ((Residue)structureComponent).getHydrophobicity() + ", " + "alphaAtomIndex=" + ((Residue)structureComponent).getAlphaAtomIndex() + ", " + "conformationType=" + ((Residue)structureComponent).getConformationType() + ", " + "atomCount=" + ((Residue)structureComponent).getAtomCount() + "}");
                int n4 = ((Residue)structureComponent).getAlphaAtomIndex();
                Atom atom = ((Residue)structureComponent).getAlphaAtom();
                if (atom == null) continue;
                System.err.println("      atom " + n4 + " = { " + "element=" + atom.element + ", " + "coordinate=[" + atom.coordinate[0] + "," + atom.coordinate[1] + "," + atom.coordinate[2] + "]" + "}");
            }
        }
        n = this.getBondCount();
        System.err.println("bondCount = " + n);
        for (int i = 0; i < n; ++i) {
            Bond bond = this.getBond(i);
            Atom atom = bond.getAtom(0);
            structureComponent = bond.getAtom(1);
            System.err.println("bond: " + atom.number + " - " + ((Atom)structureComponent).number);
        }
        System.err.println("StructureMap.print: END");
    }
}

