/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ColorChooserDialog
extends JDialog {
    protected Window parent = null;
    protected JPanel innerPanel = null;
    protected JColorChooser colorChooser = null;
    protected Color startingColor = Color.white;
    protected boolean okWasPressed = false;

    public ColorChooserDialog() {
        this.parent = null;
        this.initialize();
    }

    public ColorChooserDialog(Frame frame) {
        super(frame, true);
        this.parent = frame;
        this.initialize();
    }

    public ColorChooserDialog(Dialog dialog) {
        super(dialog, true);
        this.parent = dialog;
        this.initialize();
    }

    protected void initialize() {
        this.setTitle("Color");
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(10, 10, 10, 10))));
        container.add((Component)this.innerPanel, "Center");
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.innerPanel.add((Component)jTabbedPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BorderLayout());
        jTabbedPane.addTab("Color", jPanel);
        this.colorChooser = new JColorChooser();
        jPanel.add((Component)this.colorChooser, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 0, 0));
        jPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 3, 5, 0));
        jPanel2.add(jPanel3);
        JButton jButton = new JButton("Reset");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog.this.colorChooser.setColor(ColorChooserDialog.this.startingColor);
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("OK");
        jButton2.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog.this.okWasPressed = true;
                ColorChooserDialog.this.hide();
            }
        });
        jPanel3.add(jButton2);
        JButton jButton3 = new JButton("Cancel");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog.this.colorChooser.setColor(ColorChooserDialog.this.startingColor);
                ColorChooserDialog.this.okWasPressed = false;
                ColorChooserDialog.this.hide();
            }
        });
        jPanel3.add(jButton3);
        this.pack();
        this.validate();
    }

    public void show() {
        int n;
        int n2;
        Rectangle rectangle = this.getBounds();
        if (this.parent == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            n2 = dimension.width / 2 - rectangle.width / 2;
            n = dimension.height / 2 - rectangle.height / 2;
        } else {
            Rectangle rectangle2 = this.parent.getBounds();
            n2 = rectangle2.x + rectangle2.width / 2 - rectangle.width / 2;
            n = rectangle2.y + rectangle2.height / 2 - rectangle.height / 2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n < 0) {
            n = 0;
        }
        this.setLocation(n2, n);
        this.okWasPressed = false;
        super.show();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.innerPanel != null) {
            this.innerPanel.setBackground(color);
        }
    }

    public boolean showDialog() {
        if (this.isModal()) {
            this.show();
            return this.okWasPressed;
        }
        this.setModal(true);
        this.show();
        boolean bl = this.okWasPressed;
        this.setModal(false);
        return bl;
    }

    public boolean wasOKPressed() {
        return this.okWasPressed;
    }

    public Color getColor() {
        return this.colorChooser.getColor();
    }

    public void setColor(Color color) {
        this.colorChooser.setColor(color);
        this.startingColor = color;
    }

    public void setColor(int n, int n2, int n3) {
        this.startingColor = new Color(n, n2, n3);
        this.colorChooser.setColor(this.startingColor);
    }
}

