/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureInfo;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.gui.InterpolatedColorMapEditor;
import edu.sdsc.mbt.viewables.InterpolatedColorMap;
import edu.sdsc.mbt.viewables.ResidueColor;
import edu.sdsc.mbt.viewables.StructureDocument;
import edu.sdsc.mbt.viewables.StructureStyles;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ColorMapDialog
extends JDialog {
    protected Hashtable mapUsage = new Hashtable();
    protected Window parent = null;
    protected JComboBox mapsCombo = null;
    protected JPanel innerPanel = null;
    protected InterpolatedColorMapEditor colorEditor = null;
    protected InterpolatedColorMap colorMap = null;
    protected StructureDocument document = null;

    public ColorMapDialog(InterpolatedColorMap interpolatedColorMap) {
        if (interpolatedColorMap == null) {
            throw new NullPointerException("null color map");
        }
        this.parent = null;
        this.colorMap = interpolatedColorMap;
        this.initialize();
    }

    public ColorMapDialog(Frame frame, InterpolatedColorMap interpolatedColorMap) {
        super(frame, true);
        if (interpolatedColorMap == null) {
            throw new NullPointerException("null color map");
        }
        this.parent = frame;
        this.colorMap = interpolatedColorMap;
        this.initialize();
    }

    public ColorMapDialog(Dialog dialog, InterpolatedColorMap interpolatedColorMap) {
        super(dialog, true);
        if (interpolatedColorMap == null) {
            throw new NullPointerException("null color map");
        }
        this.parent = dialog;
        this.colorMap = interpolatedColorMap;
        this.initialize();
    }

    public ColorMapDialog(StructureDocument structureDocument) {
        if (structureDocument == null) {
            throw new NullPointerException("null document");
        }
        this.parent = null;
        this.document = structureDocument;
        this.buildMapUsage();
        this.colorMap = null;
        this.initialize();
    }

    public ColorMapDialog(Frame frame, StructureDocument structureDocument) {
        super(frame, true);
        if (structureDocument == null) {
            throw new NullPointerException("null document");
        }
        this.parent = frame;
        this.document = structureDocument;
        this.buildMapUsage();
        this.colorMap = null;
        this.initialize();
    }

    public ColorMapDialog(Dialog dialog, StructureDocument structureDocument) {
        super(dialog, true);
        if (structureDocument == null) {
            throw new NullPointerException("null document");
        }
        this.parent = dialog;
        this.document = structureDocument;
        this.buildMapUsage();
        this.colorMap = null;
        this.initialize();
    }

    protected void initialize() {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        JPanel jPanel;
        this.setTitle("Edit color map");
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(10, 10, 10, 10))));
        container.add((Component)this.innerPanel, "Center");
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.innerPanel.add((Component)jTabbedPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new BorderLayout());
        jTabbedPane.addTab("Color map", jPanel2);
        if (this.document != null) {
            jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
            jPanel.setLayout(new GridBagLayout());
            jPanel2.add((Component)jPanel, "North");
            serializable2 = new JLabel("Color maps:");
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 10);
            ((GridBagConstraints)serializable).gridx = 0;
            ((GridBagConstraints)serializable).gridy = 0;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).fill = 2;
            jPanel.add((Component)serializable2, serializable);
            object = this.getMapUseArray();
            this.mapsCombo = new JComboBox<MapUse>((E[])object);
            this.mapsCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                    MapUse mapUse = (MapUse)jComboBox.getSelectedItem();
                    InterpolatedColorMap interpolatedColorMap = mapUse.getInterpolatedColorMap();
                    ColorMapDialog.this.colorEditor.setInterpolatedColorMap(interpolatedColorMap);
                }
            });
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).gridx = 1;
            ((GridBagConstraints)serializable).gridy = 0;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).weightx = 1.0;
            jPanel.add((Component)this.mapsCombo, serializable);
            if (((Object)object).length != 0) {
                this.colorMap = ((MapUse)object[0]).getInterpolatedColorMap();
            }
        }
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(10, 10, 10, 10)));
        jPanel2.add((Component)jPanel, "Center");
        this.colorEditor = new InterpolatedColorMapEditor(this.colorMap);
        serializable2 = new Dimension(300, 50);
        this.colorEditor.setPreferredSize((Dimension)serializable2);
        this.colorEditor.setMinimumSize((Dimension)serializable2);
        this.colorEditor.setSize((Dimension)serializable2);
        jPanel.add((Component)this.colorEditor, "Center");
        serializable = new JPanel();
        ((Container)serializable).setLayout(new FlowLayout(2, 0, 0));
        ((JComponent)serializable).setBorder(new EmptyBorder(10, 0, 0, 0));
        object = new JButton("Close");
        ((JButton)object).setDefaultCapable(true);
        this.getRootPane().setDefaultButton((JButton)object);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorMapDialog.this.hide();
            }
        });
        ((Container)serializable).add((Component)object);
        jPanel2.add((Component)serializable, "South");
        this.pack();
        this.validate();
    }

    protected void buildMapUsage() {
        if (this.document == null) {
            return;
        }
        int n = this.document.getStructureCount();
        for (int i = 0; i < n; ++i) {
            Structure structure = this.document.getStructure(i);
            StructureMap structureMap = structure.getStructureMap();
            StructureStyles structureStyles = structureMap.getStructureStyles();
            int n2 = structureMap.getResidueCount();
            MapUse mapUse = null;
            ResidueColor residueColor = null;
            ResidueColor residueColor2 = null;
            InterpolatedColorMap interpolatedColorMap = null;
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                residueColor2 = structureStyles.getResidueColorObject(j);
                if (residueColor2 == residueColor) continue;
                if (mapUse != null) {
                    mapUse.addRange(n3, j - 1);
                }
                residueColor = null;
                mapUse = (MapUse)this.mapUsage.get(residueColor2);
                if (mapUse != null) {
                    n3 = j;
                    residueColor = residueColor2;
                    continue;
                }
                Class<?> clazz = residueColor2.getClass();
                Method method = null;
                try {
                    method = clazz.getMethod("getColorMap", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    continue;
                }
                Object object = null;
                try {
                    object = method.invoke((Object)residueColor2, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    continue;
                }
                if (object == null || !(object instanceof InterpolatedColorMap)) continue;
                interpolatedColorMap = (InterpolatedColorMap)object;
                mapUse = new MapUse(structure, residueColor2, interpolatedColorMap);
                this.mapUsage.put(residueColor2, mapUse);
                n3 = j;
                residueColor = residueColor2;
            }
            if (mapUse == null) continue;
            mapUse.addRange(n3, n2 - 1);
        }
    }

    protected int getMapUseCount() {
        return this.mapUsage.size();
    }

    protected MapUse[] getMapUseArray() {
        Collection collection = this.mapUsage.values();
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        MapUse[] mapUseArray = new MapUse[n];
        for (int i = 0; i < n; ++i) {
            mapUseArray[i] = (MapUse)objectArray[i];
        }
        return mapUseArray;
    }

    public void show() {
        int n;
        int n2;
        Rectangle rectangle = this.getBounds();
        if (this.parent == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            n2 = dimension.width / 2 - rectangle.width / 2;
            n = dimension.height / 2 - rectangle.height / 2;
        } else {
            Rectangle rectangle2 = this.parent.getBounds();
            n2 = rectangle2.x + rectangle2.width / 2 - rectangle.width / 2;
            n = rectangle2.y + rectangle2.height / 2 - rectangle.height / 2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n < 0) {
            n = 0;
        }
        this.setLocation(n2, n);
        super.show();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.innerPanel != null) {
            this.innerPanel.setBackground(color);
        }
        if (this.colorEditor != null) {
            this.colorEditor.setBackgroundForDialogs(color);
        }
    }

    protected final class MapUse {
        protected ResidueColor colorer = null;
        protected Structure structure = null;
        protected InterpolatedColorMap colorMap = null;
        protected int[] rangeFirsts = null;
        protected int[] rangeLasts = null;
        protected int nAlloc = 0;
        protected int nUsed = 0;

        public MapUse(Structure structure, ResidueColor residueColor, InterpolatedColorMap interpolatedColorMap) {
            this.structure = structure;
            this.colorer = residueColor;
            this.colorMap = interpolatedColorMap;
            this.nAlloc = 10;
            this.rangeFirsts = new int[this.nAlloc];
            this.rangeLasts = new int[this.nAlloc];
        }

        public Structure getStructure() {
            return this.structure;
        }

        public ResidueColor getResidueColor() {
            return this.colorer;
        }

        public InterpolatedColorMap getInterpolatedColorMap() {
            return this.colorMap;
        }

        public void addRange(int n, int n2) {
            if (this.nUsed >= this.nAlloc) {
                this.nAlloc += 10;
                int[] nArray = new int[this.nAlloc];
                int[] nArray2 = new int[this.nAlloc];
                for (int i = 0; i < this.nUsed; ++i) {
                    nArray[i] = this.rangeFirsts[i];
                    nArray2[i] = this.rangeLasts[i];
                }
                this.rangeFirsts = nArray;
                this.rangeLasts = nArray2;
            }
            this.rangeFirsts[this.nUsed] = n;
            this.rangeLasts[this.nUsed] = n2;
            ++this.nUsed;
        }

        public int getRangeCount() {
            return this.nUsed;
        }

        public int getRangeFirst(int n) {
            return this.rangeFirsts[n];
        }

        public int getRangeLast(int n) {
            return this.rangeLasts[n];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            StructureInfo structureInfo = this.structure.getStructureInfo();
            String string = null;
            if (structureInfo != null) {
                string = structureInfo.getIdCode();
            } else {
                String string2 = this.structure.getUrlString();
                try {
                    URL uRL = new URL(string2);
                    File file = new File(uRL.getPath());
                    string = file.getName();
                    int n = string.indexOf(46);
                    if (n != -1) {
                        string = string.substring(0, n);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    string = string2;
                }
            }
            stringBuffer.append(string);
            stringBuffer.append(" residues ");
            for (int i = 0; i < this.nUsed; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.rangeFirsts[i]);
                stringBuffer.append("-");
                stringBuffer.append(this.rangeLasts[i]);
            }
            return stringBuffer.toString();
        }
    }
}

