/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.util.AtomStats;
import edu.sdsc.mbt.viewables.StructureDocument;
import edu.sdsc.mbt.viewables.StructureDocumentEvent;
import edu.sdsc.mbt.viewers.StructureViewer;
import edu.sdsc.mbt.viewers.Viewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DepthCueDialog
extends JDialog
implements Viewer {
    protected Window parent = null;
    protected JPanel innerPanel = null;
    protected JCheckBox cueCheck = null;
    protected JLabel nearLabel = null;
    protected JSlider nearSlider = null;
    protected JLabel farLabel = null;
    protected JSlider farSlider = null;
    protected JButton resetButton = null;
    protected StructureViewer viewer = null;
    protected boolean firstEnableOccurred = false;

    public DepthCueDialog(Frame frame, StructureViewer structureViewer) {
        super(frame, false);
        if (structureViewer == null) {
            throw new NullPointerException("Null viewer");
        }
        this.parent = frame;
        this.viewer = structureViewer;
        this.initialize();
    }

    public DepthCueDialog(Dialog dialog, StructureViewer structureViewer) {
        super(dialog, false);
        if (structureViewer == null) {
            throw new NullPointerException("Null viewer");
        }
        this.parent = dialog;
        this.viewer = structureViewer;
        this.initialize();
    }

    protected void initialize() {
        this.setTitle("Depth cueing parameters");
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DepthCueDialog.this.setVisible(false);
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setResizable(false);
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(10, 10, 10, 10)));
        container.add((Component)this.innerPanel, "Center");
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.innerPanel.add((Component)jTabbedPane, "Center");
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Depth Cue", jPanel);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = null;
        this.cueCheck = new JCheckBox("Enable depth cueing");
        this.cueCheck.setSelected(this.viewer.getDepthCueEnable());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.cueCheck, gridBagConstraints);
        this.cueCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DepthCueDialog.this.updateGUIState();
            }
        });
        this.nearLabel = new JLabel("Front of cueing:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)this.nearLabel, gridBagConstraints);
        this.nearSlider = new JSlider(0, 100, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.nearSlider, gridBagConstraints);
        this.nearSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = DepthCueDialog.this.nearSlider.getValue();
                DepthCueDialog.this.viewer.setDepthCueFrontDistance(n);
                int n2 = DepthCueDialog.this.farSlider.getValue();
                if (n2 < n) {
                    DepthCueDialog.this.farSlider.setValue(n);
                }
            }
        });
        this.farLabel = new JLabel("Back of cueing:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)this.farLabel, gridBagConstraints);
        this.farSlider = new JSlider(0, 100, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.farSlider, gridBagConstraints);
        this.farSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = DepthCueDialog.this.farSlider.getValue();
                DepthCueDialog.this.viewer.setDepthCueBackDistance(n);
                int n2 = DepthCueDialog.this.nearSlider.getValue();
                if (n < n2) {
                    DepthCueDialog.this.nearSlider.setValue(n);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.resetButton = new JButton("Reset");
        jPanel2.add((Component)this.resetButton, "East");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DepthCueDialog.this.resetDistances();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        StructureDocument structureDocument = this.viewer.getStructureDocument();
        if (structureDocument != null) {
            structureDocument.addViewer(this);
            this.resetDistances();
        }
        this.updateGUIState();
        this.pack();
        this.validate();
    }

    public void processStructureDocumentEvent(StructureDocumentEvent structureDocumentEvent) {
        switch (structureDocumentEvent.type) {
            case 1: {
                this.resetDistances();
                break;
            }
            case 0: {
                if (structureDocumentEvent.viewer != this.viewer) break;
                this.resetDistances();
            }
        }
    }

    protected void updateGUIState() {
        if (this.cueCheck.isSelected()) {
            this.nearLabel.setEnabled(true);
            this.nearSlider.setEnabled(true);
            this.farLabel.setEnabled(true);
            this.farSlider.setEnabled(true);
            this.resetButton.setEnabled(true);
            this.viewer.setDepthCueEnable(true);
            if (!this.firstEnableOccurred) {
                this.resetDistances();
                this.firstEnableOccurred = true;
            } else {
                this.viewer.setDepthCueFrontDistance(this.nearSlider.getValue());
                this.viewer.setDepthCueBackDistance(this.farSlider.getValue());
            }
        } else {
            this.nearLabel.setEnabled(false);
            this.nearSlider.setEnabled(false);
            this.farLabel.setEnabled(false);
            this.farSlider.setEnabled(false);
            this.resetButton.setEnabled(false);
            this.viewer.setDepthCueEnable(false);
        }
    }

    protected void resetDistances() {
        StructureDocument structureDocument = this.viewer.getStructureDocument();
        if (structureDocument == null) {
            this.cueCheck.setSelected(false);
            this.updateGUIState();
            return;
        }
        int n = structureDocument.getStructureCount();
        if (n == 0) {
            this.cueCheck.setSelected(false);
            this.updateGUIState();
            return;
        }
        Structure structure = structureDocument.getStructure(0);
        double[][] dArray = AtomStats.getAtomCoordinateBounds(structure);
        double d = dArray[0][0];
        double d2 = dArray[1][0];
        double d3 = dArray[0][1];
        double d4 = dArray[1][1];
        double d5 = dArray[0][2];
        double d6 = dArray[1][2];
        for (int i = 1; i < n; ++i) {
            structure = structureDocument.getStructure(i);
            dArray = AtomStats.getAtomCoordinateBounds(structure);
            if (dArray[0][0] < d) {
                d = dArray[0][0];
            }
            if (dArray[1][0] > d2) {
                d2 = dArray[1][0];
            }
            if (dArray[0][1] < d3) {
                d3 = dArray[0][1];
            }
            if (dArray[1][1] > d4) {
                d4 = dArray[1][1];
            }
            if (dArray[0][2] < d5) {
                d5 = dArray[0][2];
            }
            if (!(dArray[1][2] > d6)) continue;
            d6 = dArray[1][2];
        }
        double d7 = (d2 - d) / 2.0;
        double d8 = (d4 - d3) / 2.0;
        double d9 = (d6 - d5) / 2.0;
        double d10 = Math.sqrt(d7 * d7 + d8 * d8 + d9 * d9);
        double d11 = d + d7;
        double d12 = d3 + d8;
        double d13 = d5 + d9;
        double[] dArray2 = new double[16];
        this.viewer.getViewpoint(dArray2);
        double d14 = dArray2[3];
        double d15 = dArray2[7];
        double d16 = dArray2[11];
        double d17 = Math.sqrt((d14 - d11) * (d14 - d11) + (d15 - d12) * (d15 - d12) + (d16 - d13) * (d16 - d13));
        this.nearSlider.setMaximum((int)(d17 + 2.0 * d10));
        this.farSlider.setMaximum((int)(d17 + 2.0 * d10));
        this.nearSlider.setValue((int)d17);
        this.farSlider.setValue((int)(d17 + d10));
    }

    public void show() {
        if (this.isVisible()) {
            return;
        }
        Rectangle rectangle = this.parent.getBounds();
        Rectangle rectangle2 = this.getBounds();
        int n = rectangle.x + rectangle.width / 2 - rectangle2.width / 2;
        int n2 = rectangle.y + rectangle.height / 2 - rectangle2.height / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.setLocation(n, n2);
        super.show();
    }

    public final void setBackground(Color color) {
        super.setBackground(color);
        if (this.innerPanel != null) {
            this.innerPanel.setBackground(color);
        }
    }
}

