/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.gui.ColorChooserDialog;
import edu.sdsc.mbt.util.Element;
import edu.sdsc.mbt.util.PeriodicTable;
import edu.sdsc.mbt.viewables.ElementStyles;
import edu.sdsc.mbt.viewables.StructureDocument;
import edu.sdsc.mbt.viewables.StructureStyles;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class ElementStylesEditor
extends JPanel {
    private static final int[][] elementNumbers = new int[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 6, 7, 8, 9, 10}, {11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 14, 15, 16, 17, 18}, {19, 20, 0, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36}, {37, 38, 0, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54}, {55, 56, 0, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86}, {87, 88, 0, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 0, 0}, {0, 0, 0, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 0, 0}};
    private StructureDocument structureDocument = null;
    private ColorChooserDialog colorChooser = null;
    private Color background = null;

    public ElementStylesEditor() {
        this.setLayout(new GridLayout(elementNumbers.length, elementNumbers[0].length));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (int i = 0; i < elementNumbers.length; ++i) {
            for (int j = 0; j < elementNumbers[i].length; ++j) {
                int n = elementNumbers[i][j];
                JComponent jComponent = null;
                if (n == 0) {
                    jComponent = new JLabel("");
                } else {
                    Color color;
                    Element element = PeriodicTable.getElement(n);
                    JButton jButton = null;
                    jButton = element == null ? new JButton(String.valueOf(n)) : new JButton(element.symbol);
                    jComponent = jButton;
                    PtListener ptListener = new PtListener(element, this, jButton);
                    jButton.addActionListener(ptListener);
                    float[] fArray = ElementStyles.getElementColor(n);
                    if (fArray != null && (color = new Color(fArray[0], fArray[1], fArray[2])) != null) {
                        jComponent.setBackground(color);
                    }
                    jComponent.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(4, 0, 4, 0)));
                }
                this.add(jComponent);
            }
        }
    }

    public ElementStylesEditor(StructureDocument structureDocument) {
        this();
        this.structureDocument = structureDocument;
    }

    public void setStructureDocument(StructureDocument structureDocument) {
        this.structureDocument = structureDocument;
    }

    public void setBackgroundForDialogs(Color color) {
        if (this.colorChooser != null) {
            this.colorChooser.setBackground(color);
        }
        this.background = color;
    }

    public void tileClicked(Element element, JButton jButton) {
        Object object;
        if (this.colorChooser == null) {
            for (object = this.getParent(); object != null && !(object instanceof Dialog) && !(object instanceof Frame); object = ((Component)object).getParent()) {
            }
            this.colorChooser = object == null ? new ColorChooserDialog() : (object instanceof Dialog ? new ColorChooserDialog((Dialog)object) : new ColorChooserDialog((Frame)object));
            if (this.background != null) {
                this.colorChooser.setBackground(this.background);
            } else {
                this.colorChooser.setBackground(this.getBackground());
            }
            this.colorChooser.setTitle("Element color");
        }
        object = ElementStyles.getElementColor(element.atomic_number);
        this.colorChooser.setColor(new Color((float)object[0], (float)object[1], (float)object[2]));
        this.colorChooser.show();
        if (!this.colorChooser.wasOKPressed()) {
            return;
        }
        Color color = this.colorChooser.getColor();
        color.getRGBColorComponents((float[])object);
        ElementStyles.setElementColor(element.atomic_number, (float)object[0], (float)object[1], (float)object[2]);
        jButton.setBackground(color);
        if (this.structureDocument != null) {
            int n = this.structureDocument.getStructureCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                Structure structure = this.structureDocument.getStructure(i);
                StructureMap structureMap = structure.getStructureMap();
                StructureStyles structureStyles = structureMap.getStructureStyles();
                int n3 = structureMap.getAtomCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!structureStyles.getAtomVisibility(n2)) continue;
                    structureStyles.updateAtomColor(n2);
                }
                n2 = structureMap.getBondCount();
                for (int j = 0; j < n2; ++j) {
                    if (!structureStyles.getBondVisibility(j)) continue;
                    structureStyles.updateBondColor(j);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Element Styles Editor");
        Container container = jFrame.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        ElementStylesEditor elementStylesEditor = new ElementStylesEditor();
        container.add(elementStylesEditor);
        jFrame.setSize(640, 480);
        jFrame.setVisible(true);
    }

    public class PtButton
    extends JButton {
        Element element = null;
        String atomicNumber = null;

        public PtButton(Element element) {
            Color color;
            this.element = element;
            float[] fArray = ElementStyles.getElementColor(this.element.atomic_number);
            if (fArray != null && (color = new Color(fArray[0], fArray[1], fArray[2])) != null) {
                this.setBackground(color);
            }
            this.atomicNumber = String.valueOf(this.element.atomic_number);
        }

        public void paint(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = n / 2;
            int n4 = n2 / 2;
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
            graphics.drawString(this.element.symbol, n3, n2);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = fontMetrics.stringWidth(this.element.symbol);
            int n6 = n5 / 2;
            graphics.setColor(Color.black);
            graphics.drawString(this.element.symbol, n3 - n6, n4);
            n5 = fontMetrics.stringWidth(this.atomicNumber);
            n6 = n5 / 2;
            graphics.drawString(this.atomicNumber, n3 - n6, n4 + fontMetrics.getAscent());
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
    }

    public class PtListener
    implements ActionListener {
        Element element = null;
        ElementStylesEditor elementStylesEditor = null;
        JButton button = null;

        public PtListener(Element element, ElementStylesEditor elementStylesEditor2, JButton jButton) {
            this.element = element;
            this.elementStylesEditor = elementStylesEditor2;
            this.button = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.elementStylesEditor.tileClicked(this.element, this.button);
        }
    }
}

