/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImageFileManager
extends JFileChooser {
    private JComboBox imageFormatComboBox;
    private Component parentComponent;
    private int saveWidth = 512;
    private int saveHeight = 512;
    private JTextField widthField = new JTextField("9999", 4);
    private JTextField heightField = new JTextField("9999", 4);

    public ImageFileManager(Component component) {
        super(new File(System.getProperty("user.dir")));
        this.parentComponent = component;
    }

    private static Vector getWriterFormats() {
        Vector<FormatDescriptor> vector = new Vector<FormatDescriptor>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
            while (iterator.hasNext()) {
                ImageWriter imageWriter = iterator.next();
                ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
                String[] stringArray2 = imageWriterSpi.getFileSuffixes();
                boolean bl = true;
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string2 = stringArray2[j];
                    if (hashtable.containsKey(string2 = string2.toLowerCase())) continue;
                    hashtable.put(string2, string2);
                    String string3 = string + " (*." + string2 + ")";
                    FormatDescriptor formatDescriptor = new FormatDescriptor(string2, imageWriter, string3);
                    vector.addElement(formatDescriptor);
                }
            }
        }
        return vector;
    }

    public BufferedImage load(File file) {
        if (file == null) {
            return null;
        }
        try {
            String string = file.getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string2);
            ImageReader imageReader = iterator.next();
            FileInputStream fileInputStream = new FileInputStream(file);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(fileInputStream);
            imageReader.setInput(imageInputStream, false);
            BufferedImage bufferedImage = imageReader.read(0);
            fileInputStream.close();
            return bufferedImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public BufferedImage load() {
        int n = this.showOpenDialog(this.parentComponent);
        if (n == 0) {
            return this.load(this.getSelectedFile());
        }
        return null;
    }

    private void updateFileSuffix(String string) {
        File file = this.getSelectedFile();
        if (file == null) {
            Container container = (Container)this.getComponent(2);
            Container container2 = (Container)container.getComponent(2);
            Container container3 = (Container)container2.getComponent(0);
            JTextField jTextField = (JTextField)container3.getComponent(1);
            String string2 = jTextField.getText();
            if (string2 == null) {
                return;
            }
            int n = string2.lastIndexOf(".");
            if (n == -1) {
                return;
            }
            string2 = string2.substring(0, n) + "." + string;
            jTextField.setText(string2);
        } else {
            if (file == null) {
                return;
            }
            String string3 = file.getPath();
            int n = string3.lastIndexOf(".");
            if (n == -1) {
                return;
            }
            string3 = string3.substring(0, n) + "." + string;
            this.setSelectedFile(new File(string3));
        }
    }

    private void augmentSaveDialog() {
        Vector vector = ImageFileManager.getWriterFormats();
        this.imageFormatComboBox = new JComboBox(vector);
        JComboBox jComboBox = this.imageFormatComboBox;
        this.imageFormatComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatDescriptor formatDescriptor = (FormatDescriptor)ImageFileManager.this.imageFormatComboBox.getSelectedItem();
                String string = formatDescriptor.suffix;
                ImageFileManager.this.updateFileSuffix(string);
            }
        });
        Component component = this.getComponent(0);
        Component component2 = this.getComponent(1);
        Component component3 = this.getComponent(2);
        this.remove(component);
        this.remove(component2);
        this.remove(component3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.add(component, "North");
        jPanel.add(component2, "Center");
        jPanel.add(component3, "South");
        JLabel jLabel = new JLabel("Select Format:");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.imageFormatComboBox, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(new JLabel("Width:"));
        jPanel3.add(this.widthField);
        jPanel3.add(new JLabel("Height:"));
        jPanel3.add(this.heightField);
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(10, 10));
        jPanel4.add((Component)jPanel2, "South");
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel4);
        Dimension dimension = new Dimension(100, 10);
        this.add(new Box.Filler(dimension, dimension, dimension));
        this.add(jPanel);
        this.setSize(450, 550);
        this.setLocation(30, 30);
    }

    public void save(BufferedImage bufferedImage, File file) {
        try {
            String string = file.getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix(string2);
            ImageWriter imageWriter = iterator.next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            IIOImage iIOImage = null;
            if (imageWriteParam instanceof JPEGImageWriteParam) {
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(1.0f);
                iIOImage = new IIOImage(bufferedImage, null, null);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(fileOutputStream);
            imageWriter.setOutput(imageOutputStream);
            if (iIOImage != null) {
                imageWriter.write(null, iIOImage, imageWriteParam);
            } else {
                imageWriter.write(bufferedImage);
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void save(BufferedImage bufferedImage) {
        this.augmentSaveDialog();
        int n = this.showSaveDialog(this.parentComponent);
        if (n == 0) {
            this.save(bufferedImage, this.getSelectedFile());
        }
    }

    public File save(int n, int n2) {
        this.augmentSaveDialog();
        this.widthField.setText(String.valueOf(n));
        this.heightField.setText(String.valueOf(n2));
        int n3 = this.showSaveDialog(this.parentComponent);
        if (n3 == 0) {
            this.saveWidth = Integer.parseInt(this.widthField.getText());
            this.saveHeight = Integer.parseInt(this.heightField.getText());
            return this.getSelectedFile();
        }
        return null;
    }

    public int getSaveWidth() {
        return this.saveWidth;
    }

    public int getSaveHeight() {
        return this.saveHeight;
    }

    private static class FormatDescriptor {
        public String suffix;
        public ImageWriter imageWriter;
        public String description;

        public FormatDescriptor(String string, ImageWriter imageWriter, String string2) {
            this.suffix = string;
            this.imageWriter = imageWriter;
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }
    }
}

