/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import edu.sdsc.mbt.gui.ColorChooserDialog;
import edu.sdsc.mbt.viewables.InterpolatedColorMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class InterpolatedColorMapEditor
extends JPanel
implements FocusListener {
    private InterpolatedColorMap interpolatedColorMap = null;
    private float[] color = null;
    private int controlAreaHeight = 30;
    private int scaleHeight = 20;
    private int markerWidth = 3;
    private int handleSize = 7;
    private int editKnot = -1;
    private boolean knotMoved = false;
    private long lastClickTime = 0L;
    private boolean hasFocus = false;
    private ColorChooserDialog colorChooser = null;
    private Color background = null;

    public InterpolatedColorMapEditor(InterpolatedColorMap interpolatedColorMap) {
        this.interpolatedColorMap = interpolatedColorMap;
        this.color = new float[3];
        int n = interpolatedColorMap.getKnotCount();
        for (int i = 0; i < n; ++i) {
            interpolatedColorMap.getKnotColor(i, this.color);
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                InterpolatedColorMapEditor.this.doMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                InterpolatedColorMapEditor.this.doMouseReleased(mouseEvent);
            }
        };
        this.addMouseListener(mouseAdapter);
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                InterpolatedColorMapEditor.this.doMouseDragged(mouseEvent);
            }
        };
        this.addMouseMotionListener(mouseMotionAdapter);
        this.setFocusable(true);
        this.addFocusListener(this);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                InterpolatedColorMapEditor.this.doKeyPressed(keyEvent);
            }
        };
        this.addKeyListener(keyAdapter);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.editKnot = -1;
        this.repaint();
    }

    private void doMousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.editKnot = this.knotHit(mouseEvent.getX(), mouseEvent.getY());
        int n = this.getHeight() - this.controlAreaHeight;
        if (this.editKnot >= 0) {
            this.setEditKnot(this.editKnot);
        } else if (this.editKnot < 0 && mouseEvent.getY() < n) {
            int n2 = this.interpolatedColorMap.getKnotCount();
            float[][] fArray = new float[n2][4];
            float[][] fArray2 = new float[n2 + 1][4];
            this.interpolatedColorMap.getKnots(fArray);
            float f = this.positionToSample(mouseEvent.getX());
            float[] fArray3 = new float[3];
            this.interpolatedColorMap.getColor(f, fArray3);
            int n3 = 0;
            boolean bl = false;
            for (int i = 0; i < fArray2.length; ++i) {
                fArray2[i][0] = fArray[n3][0];
                fArray2[i][1] = fArray[n3][1];
                fArray2[i][2] = fArray[n3][2];
                fArray2[i][3] = fArray[n3][3];
                if (!bl && f > fArray[n3][0] && f < fArray[n3 + 1][0]) {
                    fArray2[i + 1][0] = f;
                    fArray2[i + 1][1] = fArray3[0];
                    fArray2[i + 1][2] = fArray3[1];
                    fArray2[i + 1][3] = fArray3[2];
                    this.editKnot = i + 1;
                    bl = true;
                    ++i;
                }
                ++n3;
            }
            this.interpolatedColorMap.setKnots(fArray2);
            this.setEditKnot(this.editKnot);
        } else if (this.editKnot < 0) {
            this.setEditKnot(this.editKnot);
        }
        this.knotMoved = false;
    }

    public void setBackgroundForDialogs(Color color) {
        if (this.colorChooser != null) {
            this.colorChooser.setBackground(color);
        }
        this.background = color;
    }

    private void doMouseReleased(MouseEvent mouseEvent) {
        long l = System.currentTimeMillis();
        if (this.editKnot != -1 && !this.knotMoved && l - this.lastClickTime < 500L) {
            Serializable serializable;
            this.interpolatedColorMap.getKnotColor(this.editKnot, this.color);
            int n = this.editKnot;
            if (this.colorChooser == null) {
                for (serializable = this.getParent(); serializable != null && !(serializable instanceof Dialog) && !(serializable instanceof Frame); serializable = ((Component)serializable).getParent()) {
                }
                this.colorChooser = serializable == null ? new ColorChooserDialog() : (serializable instanceof Dialog ? new ColorChooserDialog((Dialog)serializable) : new ColorChooserDialog((Frame)serializable));
                if (this.background != null) {
                    this.colorChooser.setBackground(this.background);
                } else {
                    this.colorChooser.setBackground(this.getBackground());
                }
                this.colorChooser.setTitle("Color");
            }
            this.colorChooser.setColor(new Color(this.color[0], this.color[1], this.color[2]));
            this.colorChooser.show();
            if (this.colorChooser.wasOKPressed()) {
                serializable = this.colorChooser.getColor();
                this.setEditKnot(n);
                if (serializable != null) {
                    ((Color)serializable).getRGBColorComponents(this.color);
                    this.interpolatedColorMap.setKnotColor(n, this.color);
                }
            }
        }
        this.lastClickTime = l;
        this.knotMoved = false;
    }

    private void doMouseDragged(MouseEvent mouseEvent) {
        if (this.editKnot != -1) {
            this.knotMoved = true;
            if (this.interpolatedColorMap == null) {
                return;
            }
            if (this.editKnot == 0) {
                return;
            }
            int n = this.interpolatedColorMap.getKnotCount();
            if (this.editKnot >= n - 1) {
                return;
            }
            float f = this.positionToSample(mouseEvent.getX());
            this.interpolatedColorMap.setKnotLocation(this.editKnot, f);
            this.repaint();
        }
    }

    public void doKeyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (c == '\b' || c == '\u007f') {
            if (this.editKnot >= 0) {
                int n2 = this.interpolatedColorMap.getKnotCount();
                if (this.editKnot == 0) {
                    return;
                }
                if (this.editKnot >= n2 - 1) {
                    return;
                }
                boolean bl = false;
                float[][] fArray = new float[n2][4];
                float[][] fArray2 = new float[n2 - 1][4];
                this.interpolatedColorMap.getKnots(fArray);
                int n3 = 0;
                int n4 = 0;
                while (n3 < fArray2.length) {
                    if (n3 == this.editKnot && !bl) {
                        bl = true;
                        ++n4;
                    }
                    fArray2[n3][0] = fArray[n4][0];
                    fArray2[n3][1] = fArray[n4][1];
                    fArray2[n3][2] = fArray[n4][2];
                    fArray2[n3][3] = fArray[n4][3];
                    ++n3;
                    ++n4;
                }
                this.interpolatedColorMap.setKnots(fArray2);
                this.editKnot = -1;
                this.repaint();
            }
        } else if ((n == 37 || n == 39) && this.editKnot >= 0) {
            float f = 0.0f;
            if (n == 37) {
                f = -0.01f;
            }
            if (n == 39) {
                f = 0.01f;
            }
            float f2 = this.interpolatedColorMap.getKnotLocation(this.editKnot);
            this.interpolatedColorMap.setKnotLocation(this.editKnot, f2 + f);
            this.repaint();
        }
    }

    private int knotHit(int n, int n2) {
        int n3 = this.interpolatedColorMap.getKnotCount();
        int n4 = this.getHeight() - this.controlAreaHeight;
        int n5 = this.getWidth();
        int n6 = (this.handleSize - this.markerWidth) / 2;
        for (int i = 0; i < n3; ++i) {
            float f = this.interpolatedColorMap.getKnotLocation(i);
            int n7 = (int)(f * (float)n5);
            if (n < n7 - n6 || n > n7 - n6 + this.handleSize || n2 < n4 || n2 > n4 + this.handleSize) continue;
            return i;
        }
        return -1;
    }

    private float positionToSample(int n) {
        if (n <= 0) {
            return 0.0f;
        }
        int n2 = this.getWidth();
        if (n >= n2) {
            return 1.0f;
        }
        return (float)n / (float)n2;
    }

    private void setEditKnot(int n) {
        this.editKnot = n;
        this.repaint();
    }

    private int getEditKnot() {
        return this.editKnot;
    }

    public void setInterpolatedColorMap(InterpolatedColorMap interpolatedColorMap) {
        this.interpolatedColorMap = interpolatedColorMap;
        this.editKnot = -1;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Serializable serializable;
        if (graphics == null) {
            return;
        }
        if (this.interpolatedColorMap == null) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n2 - this.controlAreaHeight;
        float f = 1.0f / (float)n;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        for (int i = 0; i < n; ++i) {
            float f2 = f * (float)i;
            this.interpolatedColorMap.getColor(f2, this.color);
            serializable = new Color(this.color[0], this.color[1], this.color[2]);
            graphics.setColor((Color)serializable);
            graphics.fillRect(i, 0, 1, n3);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, n, n3);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        Font font = graphics.getFont();
        serializable = graphics.getFontMetrics();
        int n4 = ((FontMetrics)serializable).getHeight();
        int n5 = this.interpolatedColorMap.getKnotCount();
        int n6 = (this.handleSize - this.markerWidth) / 2;
        for (int i = 0; i < n5; ++i) {
            float f3 = this.interpolatedColorMap.getKnotLocation(i);
            int n7 = (int)(f3 * (float)n);
            if (i == n5 - 1) {
                n7 = n - this.markerWidth;
            }
            graphics.setColor(Color.black);
            graphics.drawRect(n7, 0, this.markerWidth, n3);
            this.interpolatedColorMap.getKnotColor(i, this.color);
            graphics.setColor(new Color(this.color[0], this.color[1], this.color[2]));
            graphics.fillRect(n7 - n6, n3, this.handleSize, this.handleSize);
            graphics.setColor(Color.black);
            graphics.drawRect(n7 - n6, n3, this.handleSize, this.handleSize);
            if (i == this.editKnot) {
                graphics.drawRect(n7 - n6 - 1, n3 - 1, this.handleSize + 2, this.handleSize + 2);
                graphics.drawRect(n7 - n6 - 2, n3 - 2, this.handleSize + 4, this.handleSize + 4);
            }
            String string = numberFormat.format(f3);
            int n8 = ((FontMetrics)serializable).stringWidth(string);
            int n9 = n7 - n8 / 2;
            if (i == 0) {
                n9 = 1;
            }
            if (i == n5 - 1) {
                n9 = n7 - n8;
            }
            int n10 = n3 + this.handleSize + n4;
            graphics.drawString(string, n9, n10);
            if (!this.hasFocus) continue;
            graphics.setColor(Color.blue);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
    }

    public static void main(String[] stringArray) {
        InterpolatedColorMap[] interpolatedColorMapArray = new InterpolatedColorMap[]{new InterpolatedColorMap(1), new InterpolatedColorMap(2), new InterpolatedColorMap(0), new InterpolatedColorMap(4)};
        String[] stringArray2 = new String[]{"RAINBOW", "COLD_TO_HOT", "BLACK_TO_WHITE", "HSB_HUES"};
        InterpolatedColorMapEditor interpolatedColorMapEditor = new InterpolatedColorMapEditor(interpolatedColorMapArray[0]);
        JFrame jFrame = new JFrame("InterpolatedColorMapEditor");
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", interpolatedColorMapEditor);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        container.add("South", jPanel);
        for (int i = 0; i < interpolatedColorMapArray.length; ++i) {
            JButton jButton = new JButton(stringArray2[i]);
            MyActionListener myActionListener = interpolatedColorMapEditor.createMyActionListener(interpolatedColorMapEditor, interpolatedColorMapArray[i]);
            jButton.addActionListener(myActionListener);
            jPanel.add(jButton);
        }
        jFrame.setSize(500, 150);
        jFrame.setVisible(true);
    }

    protected MyActionListener createMyActionListener(InterpolatedColorMapEditor interpolatedColorMapEditor, InterpolatedColorMap interpolatedColorMap) {
        return new MyActionListener(interpolatedColorMapEditor, interpolatedColorMap);
    }

    private class MyActionListener
    implements ActionListener {
        InterpolatedColorMap icm = null;
        InterpolatedColorMapEditor icme = null;

        public MyActionListener(InterpolatedColorMapEditor interpolatedColorMapEditor2, InterpolatedColorMap interpolatedColorMap) {
            this.icm = interpolatedColorMap;
            this.icme = interpolatedColorMapEditor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.icme.setInterpolatedColorMap(this.icm);
        }
    }
}

