/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import edu.sdsc.mbt.util.Status;
import edu.sdsc.mbt.util.StatusEvent;
import edu.sdsc.mbt.util.StatusListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class ProgressDialog
extends JDialog
implements StatusListener {
    protected Window parent = null;
    protected JProgressBar progressBar = null;
    protected JLabel messageLabel = null;
    protected JLabel noteLabel = null;
    protected float percent = 0.0f;
    protected boolean statusMonitored = true;

    public ProgressDialog(String string, String string2) {
        this.parent = null;
        this.initialize(string, string2);
    }

    public ProgressDialog(Frame frame, String string, String string2) {
        super(frame, true);
        this.parent = frame;
        this.initialize(string, string2);
    }

    public ProgressDialog(Dialog dialog, String string, String string2) {
        super(dialog, true);
        this.parent = dialog;
        this.initialize(string, string2);
    }

    protected void initialize(String string, String string2) {
        if (string == null) {
            this.setTitle("Progress");
        } else {
            this.setTitle(string);
        }
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        container.add(jPanel);
        if (string2 == null) {
            string2 = "";
        }
        this.messageLabel = new JLabel(string2);
        Font font = this.messageLabel.getFont();
        Font font2 = font.deriveFont(1);
        this.messageLabel.setFont(font2);
        jPanel.add((Component)this.messageLabel, "North");
        this.noteLabel = new JLabel(" ");
        jPanel.add((Component)this.noteLabel, "Center");
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setBorderPainted(true);
        this.progressBar.setStringPainted(false);
        this.progressBar.setValue(0);
        Dimension dimension = new Dimension(300, 20);
        this.progressBar.setMinimumSize(dimension);
        this.progressBar.setPreferredSize(dimension);
        jPanel.add((Component)this.progressBar, "South");
        this.pack();
        this.validate();
        Status.addStatusListener(this);
    }

    public void show() {
        int n;
        int n2;
        Object object;
        Object object2;
        Rectangle rectangle = this.getBounds();
        if (this.parent == null) {
            object2 = Toolkit.getDefaultToolkit();
            object = ((Toolkit)object2).getScreenSize();
            n2 = ((Dimension)object).width / 2 - rectangle.width / 2;
            n = ((Dimension)object).height / 2 - rectangle.height / 2;
        } else {
            object2 = this.parent.getBounds();
            n2 = ((Rectangle)object2).x + ((Rectangle)object2).width / 2 - rectangle.width / 2;
            n = ((Rectangle)object2).y + ((Rectangle)object2).height / 2 - rectangle.height / 2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n < 0) {
            n = 0;
        }
        this.setLocation(n2, n);
        if (!this.isModal()) {
            super.show();
            return;
        }
        object2 = this;
        object = new Thread(new Runnable((ProgressDialog)object2){
            private final /* synthetic */ ProgressDialog val$thisDialog;
            {
                this.val$thisDialog = progressDialog2;
            }

            public void run() {
                this.val$thisDialog.showIt();
            }
        });
        ((Thread)object).start();
    }

    private void showIt() {
        super.show();
    }

    public void hide() {
        super.hide();
        if (this.statusMonitored) {
            Status.removeStatusListener(this);
        }
    }

    public void processStatusEvent(StatusEvent statusEvent) {
        switch (statusEvent.type) {
            case 0: {
                this.setNote(statusEvent.message);
                break;
            }
            case 1: {
                this.setNote(statusEvent.message);
                this.setProgress(statusEvent.percent);
            }
        }
    }

    public float getProgress() {
        return this.percent;
    }

    public void setProgress(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        } else if (f < 0.0f) {
            f = 0.0f;
        }
        this.percent = f;
        this.progressBar.setValue((int)(f * 100.0f));
        this.repaint();
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public String getNote() {
        return this.noteLabel.getText();
    }

    public void setNote(String string) {
        this.noteLabel.setText(string);
        this.repaint();
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    public void setIndeterminate(boolean bl) {
        this.progressBar.setIndeterminate(bl);
    }

    public boolean isStatusMonitored() {
        return this.statusMonitored;
    }

    public void setStatusMonitored(boolean bl) {
        if (bl == this.statusMonitored) {
            return;
        }
        if (bl) {
            Status.addStatusListener(this);
        } else {
            Status.removeStatusListener(this);
        }
        this.statusMonitored = bl;
    }
}

