/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import edu.sdsc.mbt.viewers.StructureViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class StructureViewerPrefs
extends JPanel {
    private JPanel environmentPanel;
    private JLabel backgroundColorLabel;
    private JButton backgroundColorButton;
    private StructureViewer structureViewer = null;

    public StructureViewerPrefs(StructureViewer structureViewer) {
        this.structureViewer = structureViewer;
        this.initialize();
    }

    private void initialize() {
        this.environmentPanel = new JPanel();
        this.backgroundColorLabel = new JLabel();
        this.backgroundColorButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.environmentPanel.setLayout(new GridBagLayout());
        this.environmentPanel.setBorder(new TitledBorder("Environment"));
        this.backgroundColorLabel.setText("Background Color");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.environmentPanel.add((Component)this.backgroundColorLabel, gridBagConstraints);
        this.backgroundColorButton.setText(" ");
        float[] fArray = new float[3];
        this.structureViewer.getBackgroundColor(fArray);
        this.backgroundColorButton.setBackground(new Color(fArray[0], fArray[1], fArray[2]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.environmentPanel.add((Component)this.backgroundColorButton, gridBagConstraints);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerPrefs.this.setBackgroundColor();
            }
        };
        this.backgroundColorButton.addActionListener(actionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.environmentPanel, gridBagConstraints);
    }

    private void setBackgroundColor() {
        float[] fArray = new float[3];
        this.structureViewer.getBackgroundColor(fArray);
        Color color = JColorChooser.showDialog(this, "Background Color", new Color(fArray[0], fArray[1], fArray[2]));
        if (color == null) {
            return;
        }
        this.backgroundColorButton.setBackground(color);
        color.getRGBColorComponents(fArray);
        this.structureViewer.setBackgroundColor(fArray);
    }
}

