/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.gui.ColorMapDialog;
import edu.sdsc.mbt.gui.ElementStylesEditorDialog;
import edu.sdsc.mbt.viewables.AtomColorRegistry;
import edu.sdsc.mbt.viewables.AtomLabelRegistry;
import edu.sdsc.mbt.viewables.AtomRadiusRegistry;
import edu.sdsc.mbt.viewables.BondColorRegistry;
import edu.sdsc.mbt.viewables.BondLabelRegistry;
import edu.sdsc.mbt.viewables.BondRadiusRegistry;
import edu.sdsc.mbt.viewables.FragmentFormRegistry;
import edu.sdsc.mbt.viewables.ResidueColorRegistry;
import edu.sdsc.mbt.viewables.StructureDocument;
import edu.sdsc.mbt.viewables.StructureStyles;
import edu.sdsc.mbt.viewables.VisibilityRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class StyleEditor
extends JPanel {
    private static final String NO_CHANGE = "No Change";
    private static final String SHOW = "Show";
    private static final String HIDE = "Hide";
    private JComboBox atomsColorCombo;
    private JPanel fragmentsPanel;
    private JLabel bondsVisibilityLabel;
    private JPanel residuesFragmentsMacrosPanel;
    private JPanel residuesFragmentsMacrosGridPanel;
    private JLabel atombsBondsMacrosLabel;
    private JButton wireframeBondsButton;
    private JComboBox fragmentsVisibilityCombo;
    private JLabel bondsLabelsLabel;
    private JPanel residuesPanel;
    private JButton residuesFragmentsHideButton;
    private JLabel residuesColorLabel;
    private JLabel fragmentsVisibilityLabel;
    private JPanel atomsBondsPanel;
    private JComboBox bondsLabelsCombo;
    private JButton residuesFragmentsApplyButton;
    private JLabel atomsLabelsLabel;
    private JComboBox bondsRadiusCombo;
    private JPanel atomsBondsMacrosPanel;
    private JPanel atomsBondsMacrosGridPanel;
    private JComboBox residuesColorCombo;
    private JLabel fragmentsStyleLabel;
    private JComboBox atomsLabelsCombo;
    private JLabel atomsColorLabel;
    private JPanel bondsPanel;
    private JLabel atomsRadiusLabel;
    private JLabel bondsColorLabel;
    private JButton atomsBondsApplyButton;
    private JComboBox atomsVisibilityCombo;
    private JButton cpkButton;
    private JTabbedPane stylesTabPanel;
    private JPanel atomsPanel;
    private JButton tubeBackboneButton;
    private JButton wireframeBackboneButton;
    private JButton atomsBondsHideButton;
    private JComboBox bondsVisibilityCombo;
    private JLabel residuesFragmentsMacrosLabel;
    private JLabel atomsVisibilityLabel;
    private JButton editElementStylesButton;
    private JComboBox fragmentsStyleCombo;
    private JButton atomMarkersButton;
    private JButton ballAndStickButton;
    private JComboBox bondsColorCombo;
    private JButton editColorMapButton;
    private JComboBox atomsRadiusCombo;
    private JLabel bondsRadiusLabel;
    private JButton smoothBondsButton;
    private JButton cartoonButton;
    private JPanel residuesFragmentsPanel;
    private ElementStylesEditorDialog elementStylesDialog = null;
    private ColorMapDialog colorMapDialog = null;
    private StructureDocument structureDocument = null;

    public StyleEditor(StructureDocument structureDocument) {
        this.structureDocument = structureDocument;
        this.initialize();
    }

    private void initialize() {
        this.stylesTabPanel = new JTabbedPane();
        this.atomsBondsPanel = new JPanel();
        this.atomsPanel = new JPanel();
        this.atomsVisibilityLabel = new JLabel();
        this.atomsVisibilityCombo = new JComboBox();
        this.atomsColorLabel = new JLabel();
        this.atomsColorCombo = new JComboBox();
        this.atomsRadiusLabel = new JLabel();
        this.atomsRadiusCombo = new JComboBox();
        this.atomsLabelsLabel = new JLabel();
        this.atomsLabelsCombo = new JComboBox();
        this.bondsPanel = new JPanel();
        this.bondsVisibilityLabel = new JLabel();
        this.bondsVisibilityCombo = new JComboBox();
        this.bondsColorLabel = new JLabel();
        this.bondsColorCombo = new JComboBox();
        this.bondsRadiusLabel = new JLabel();
        this.bondsRadiusCombo = new JComboBox();
        this.bondsLabelsLabel = new JLabel();
        this.bondsLabelsCombo = new JComboBox();
        this.atomsBondsMacrosPanel = new JPanel();
        this.atomsBondsMacrosGridPanel = new JPanel();
        this.atombsBondsMacrosLabel = new JLabel();
        this.ballAndStickButton = new JButton();
        this.atomMarkersButton = new JButton();
        this.smoothBondsButton = new JButton();
        this.cpkButton = new JButton();
        this.wireframeBondsButton = new JButton();
        this.atomsBondsHideButton = new JButton();
        this.editElementStylesButton = new JButton();
        this.atomsBondsApplyButton = new JButton();
        this.residuesFragmentsPanel = new JPanel();
        this.residuesPanel = new JPanel();
        this.residuesColorLabel = new JLabel();
        this.residuesColorCombo = new JComboBox();
        this.fragmentsPanel = new JPanel();
        this.fragmentsVisibilityLabel = new JLabel();
        this.fragmentsVisibilityCombo = new JComboBox();
        this.fragmentsStyleLabel = new JLabel();
        this.fragmentsStyleCombo = new JComboBox();
        this.residuesFragmentsMacrosPanel = new JPanel();
        this.residuesFragmentsMacrosGridPanel = new JPanel();
        this.residuesFragmentsMacrosLabel = new JLabel();
        this.wireframeBackboneButton = new JButton();
        this.cartoonButton = new JButton();
        this.tubeBackboneButton = new JButton();
        this.residuesFragmentsHideButton = new JButton();
        this.editColorMapButton = new JButton();
        this.residuesFragmentsApplyButton = new JButton();
        this.setLayout(new BorderLayout());
        this.atomsBondsPanel.setLayout(new GridBagLayout());
        this.atomsBondsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.atomsPanel.setLayout(new GridBagLayout());
        this.atomsPanel.setBorder(new CompoundBorder(new TitledBorder("Atoms"), new EmptyBorder(10, 10, 10, 10)));
        this.atomsVisibilityLabel.setText("Visibility:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.atomsPanel.add((Component)this.atomsVisibilityLabel, gridBagConstraints);
        this.populate(VisibilityRegistry.names(), this.atomsVisibilityCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.atomsPanel.add((Component)this.atomsVisibilityCombo, gridBagConstraints);
        this.atomsColorLabel.setText("Color:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.atomsPanel.add((Component)this.atomsColorLabel, gridBagConstraints);
        this.populate(AtomColorRegistry.names(), this.atomsColorCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.atomsPanel.add((Component)this.atomsColorCombo, gridBagConstraints);
        this.atomsRadiusLabel.setText("Radius:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.atomsPanel.add((Component)this.atomsRadiusLabel, gridBagConstraints);
        this.populate(AtomRadiusRegistry.names(), this.atomsRadiusCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.atomsPanel.add((Component)this.atomsRadiusCombo, gridBagConstraints);
        this.atomsLabelsLabel.setText("Labels:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.atomsPanel.add((Component)this.atomsLabelsLabel, gridBagConstraints);
        this.populate(AtomLabelRegistry.names(), this.atomsLabelsCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.atomsPanel.add((Component)this.atomsLabelsCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.atomsBondsPanel.add((Component)this.atomsPanel, gridBagConstraints);
        this.bondsPanel.setLayout(new GridBagLayout());
        this.bondsPanel.setBorder(new CompoundBorder(new TitledBorder("Bonds"), new EmptyBorder(10, 10, 10, 10)));
        this.bondsVisibilityLabel.setText("Visibility:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.bondsPanel.add((Component)this.bondsVisibilityLabel, gridBagConstraints);
        this.populate(VisibilityRegistry.names(), this.bondsVisibilityCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.bondsPanel.add((Component)this.bondsVisibilityCombo, gridBagConstraints);
        this.bondsColorLabel.setText("Color:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.bondsPanel.add((Component)this.bondsColorLabel, gridBagConstraints);
        this.populate(BondColorRegistry.names(), this.bondsColorCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.bondsPanel.add((Component)this.bondsColorCombo, gridBagConstraints);
        this.bondsRadiusLabel.setText("Radius:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.bondsPanel.add((Component)this.bondsRadiusLabel, gridBagConstraints);
        this.populate(BondRadiusRegistry.names(), this.bondsRadiusCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.bondsPanel.add((Component)this.bondsRadiusCombo, gridBagConstraints);
        this.bondsLabelsLabel.setText("Labels:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.bondsPanel.add((Component)this.bondsLabelsLabel, gridBagConstraints);
        this.populate(BondLabelRegistry.names(), this.bondsLabelsCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.bondsPanel.add((Component)this.bondsLabelsCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.atomsBondsPanel.add((Component)this.bondsPanel, gridBagConstraints);
        this.atomsBondsMacrosPanel.setLayout(new GridBagLayout());
        this.atomsBondsMacrosPanel.setBorder(new CompoundBorder(new TitledBorder("Macros"), new EmptyBorder(10, 10, 10, 10)));
        this.atombsBondsMacrosLabel.setText("Auto-configure attributes above:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.atomsBondsMacrosPanel.add((Component)this.atombsBondsMacrosLabel, gridBagConstraints);
        this.atomsBondsMacrosGridPanel.setLayout(new GridLayout(3, 2, 5, 5));
        this.ballAndStickButton.setText("Ball-And-Stick");
        this.atomsBondsMacrosGridPanel.add(this.ballAndStickButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setBallAndStickStyle();
            }
        };
        this.ballAndStickButton.addActionListener(actionListener);
        this.wireframeBondsButton.setText("Wireframe Bonds");
        this.atomsBondsMacrosGridPanel.add(this.wireframeBondsButton);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setWireframeBondsStyle();
            }
        };
        this.wireframeBondsButton.addActionListener(actionListener2);
        this.smoothBondsButton.setText("Smooth Bonds");
        this.atomsBondsMacrosGridPanel.add(this.smoothBondsButton);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setSmoothBondsStyle();
            }
        };
        this.smoothBondsButton.addActionListener(actionListener3);
        this.atomMarkersButton.setText("Atom Markers");
        this.atomsBondsMacrosGridPanel.add(this.atomMarkersButton);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setAtomMarkersStyle();
            }
        };
        this.atomMarkersButton.addActionListener(actionListener4);
        this.cpkButton.setText("CPK Spheres");
        this.atomsBondsMacrosGridPanel.add(this.cpkButton);
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setCPKStyle();
            }
        };
        this.cpkButton.addActionListener(actionListener5);
        this.atomsBondsHideButton.setText(HIDE);
        this.atomsBondsMacrosGridPanel.add(this.atomsBondsHideButton);
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setAtomsBondsHideStyle();
            }
        };
        this.atomsBondsHideButton.addActionListener(actionListener6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints = new GridBagConstraints();
        this.atomsBondsMacrosPanel.add((Component)this.atomsBondsMacrosGridPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.atomsBondsPanel.add((Component)this.atomsBondsMacrosPanel, gridBagConstraints);
        this.editElementStylesButton.setText("Element Colors...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.atomsBondsPanel.add((Component)this.editElementStylesButton, gridBagConstraints);
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.showElementStylesEditor();
            }
        };
        this.editElementStylesButton.addActionListener(actionListener7);
        this.atomsBondsApplyButton.setText("Apply");
        this.atomsBondsApplyButton.setDefaultCapable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 13;
        this.atomsBondsPanel.add((Component)this.atomsBondsApplyButton, gridBagConstraints);
        ActionListener actionListener8 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.applyAtomsBondsStyles();
            }
        };
        this.atomsBondsApplyButton.addActionListener(actionListener8);
        this.stylesTabPanel.addTab("Atoms/Bonds", this.atomsBondsPanel);
        this.residuesFragmentsPanel.setLayout(new GridBagLayout());
        this.residuesFragmentsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.residuesPanel.setLayout(new GridBagLayout());
        this.residuesPanel.setBorder(new CompoundBorder(new TitledBorder("Residues"), new EmptyBorder(10, 10, 10, 10)));
        this.residuesColorLabel.setText("Color:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.residuesPanel.add((Component)this.residuesColorLabel, gridBagConstraints);
        this.populate(ResidueColorRegistry.names(), this.residuesColorCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.residuesPanel.add((Component)this.residuesColorCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.residuesFragmentsPanel.add((Component)this.residuesPanel, gridBagConstraints);
        this.fragmentsPanel.setLayout(new GridBagLayout());
        this.fragmentsPanel.setBorder(new CompoundBorder(new TitledBorder("Fragments"), new EmptyBorder(10, 10, 10, 10)));
        this.fragmentsVisibilityLabel.setText("Visibility:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.fragmentsPanel.add((Component)this.fragmentsVisibilityLabel, gridBagConstraints);
        this.populate(VisibilityRegistry.names(), this.fragmentsVisibilityCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fragmentsPanel.add((Component)this.fragmentsVisibilityCombo, gridBagConstraints);
        this.fragmentsStyleLabel.setText("Style:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.fragmentsPanel.add((Component)this.fragmentsStyleLabel, gridBagConstraints);
        this.populate(FragmentFormRegistry.names(), this.fragmentsStyleCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fragmentsPanel.add((Component)this.fragmentsStyleCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.residuesFragmentsPanel.add((Component)this.fragmentsPanel, gridBagConstraints);
        this.residuesFragmentsMacrosPanel.setLayout(new GridBagLayout());
        this.residuesFragmentsMacrosPanel.setBorder(new CompoundBorder(new TitledBorder("Macros"), new EmptyBorder(10, 10, 10, 10)));
        this.residuesFragmentsMacrosLabel.setText("Auto-configure attributes above");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.residuesFragmentsMacrosPanel.add((Component)this.residuesFragmentsMacrosLabel, gridBagConstraints);
        this.residuesFragmentsMacrosGridPanel.setLayout(new GridLayout(2, 2, 5, 5));
        this.wireframeBackboneButton.setText("Wireframe Backbone");
        this.residuesFragmentsMacrosGridPanel.add(this.wireframeBackboneButton);
        ActionListener actionListener9 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setResiduesFragmentsWireframeBackboneStyle();
            }
        };
        this.wireframeBackboneButton.addActionListener(actionListener9);
        this.cartoonButton.setText("Cartoon");
        gridBagConstraints = new GridBagConstraints();
        this.residuesFragmentsMacrosGridPanel.add(this.cartoonButton);
        ActionListener actionListener10 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setCartoonStyle();
            }
        };
        this.cartoonButton.addActionListener(actionListener10);
        this.tubeBackboneButton.setText("Tube Backbone");
        this.residuesFragmentsMacrosGridPanel.add(this.tubeBackboneButton);
        ActionListener actionListener11 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setTubeBackboneStyle();
            }
        };
        this.tubeBackboneButton.addActionListener(actionListener11);
        this.residuesFragmentsHideButton.setText(HIDE);
        gridBagConstraints = new GridBagConstraints();
        this.residuesFragmentsMacrosGridPanel.add(this.residuesFragmentsHideButton);
        ActionListener actionListener12 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.setResiduesFragmentsHideStyle();
            }
        };
        this.residuesFragmentsHideButton.addActionListener(actionListener12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints = new GridBagConstraints();
        this.residuesFragmentsMacrosPanel.add((Component)this.residuesFragmentsMacrosGridPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.residuesFragmentsPanel.add((Component)this.residuesFragmentsMacrosPanel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.residuesFragmentsPanel.add((Component)jPanel, gridBagConstraints);
        this.editColorMapButton.setText("Color Map...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.residuesFragmentsPanel.add((Component)this.editColorMapButton, gridBagConstraints);
        ActionListener actionListener13 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.showColorMapEditor();
            }
        };
        this.editColorMapButton.addActionListener(actionListener13);
        this.residuesFragmentsApplyButton.setText("Apply");
        this.residuesFragmentsApplyButton.setDefaultCapable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 13;
        this.residuesFragmentsPanel.add((Component)this.residuesFragmentsApplyButton, gridBagConstraints);
        ActionListener actionListener14 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.applyResiduesFragmentsStyles();
            }
        };
        this.residuesFragmentsApplyButton.addActionListener(actionListener14);
        this.stylesTabPanel.addTab("Residues/Fragments", this.residuesFragmentsPanel);
        this.add((Component)this.stylesTabPanel, "Center");
    }

    private void populate(Enumeration enumeration, JComboBox jComboBox) {
        jComboBox.addItem(NO_CHANGE);
        while (enumeration.hasMoreElements()) {
            jComboBox.addItem(enumeration.nextElement());
        }
    }

    private Window findParentWindow() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof Dialog) && !(container instanceof Frame); container = container.getParent()) {
        }
        return (Window)container;
    }

    private void showColorMapEditor() {
        if (this.colorMapDialog == null) {
            Window window = this.findParentWindow();
            this.colorMapDialog = window == null ? new ColorMapDialog(this.structureDocument) : (window instanceof Dialog ? new ColorMapDialog((Dialog)window, this.structureDocument) : new ColorMapDialog((Frame)window, this.structureDocument));
            this.colorMapDialog.setBackground(this.getBackground());
        }
        this.colorMapDialog.show();
    }

    private void showElementStylesEditor() {
        if (this.elementStylesDialog == null) {
            Window window = this.findParentWindow();
            this.elementStylesDialog = window == null ? new ElementStylesEditorDialog(this.structureDocument) : (window instanceof Dialog ? new ElementStylesEditorDialog((Dialog)window, this.structureDocument) : new ElementStylesEditorDialog((Frame)window, this.structureDocument));
            this.elementStylesDialog.setBackground(this.getBackground());
        }
        this.elementStylesDialog.show();
    }

    private void setBallAndStickStyle() {
        this.atomsVisibilityCombo.setSelectedItem(SHOW);
        this.atomsColorCombo.setSelectedItem("By Element");
        this.atomsRadiusCombo.setSelectedItem("By Scaled CPK (Ball-and-Stick)");
        this.atomsLabelsCombo.setSelectedItem(NO_CHANGE);
        this.bondsVisibilityCombo.setSelectedItem(SHOW);
        this.bondsColorCombo.setSelectedItem("By Atom Color");
        this.bondsRadiusCombo.setSelectedItem("By Scaled Atom Radius (Ball-And-Stick)");
        this.bondsLabelsCombo.setSelectedItem(NO_CHANGE);
    }

    private void setSmoothBondsStyle() {
        this.atomsVisibilityCombo.setSelectedItem(SHOW);
        this.atomsColorCombo.setSelectedItem("By Element");
        this.atomsRadiusCombo.setSelectedItem("By Constant (Smooth Bonds)");
        this.atomsLabelsCombo.setSelectedItem(NO_CHANGE);
        this.bondsVisibilityCombo.setSelectedItem(SHOW);
        this.bondsColorCombo.setSelectedItem("By Atom Color");
        this.bondsRadiusCombo.setSelectedItem("By Atom Radius (Smooth Bonds)");
        this.bondsLabelsCombo.setSelectedItem(NO_CHANGE);
    }

    private void setCPKStyle() {
        this.atomsVisibilityCombo.setSelectedItem(SHOW);
        this.atomsColorCombo.setSelectedItem("By Element");
        this.atomsRadiusCombo.setSelectedItem("By CPK");
        this.atomsLabelsCombo.setSelectedItem(NO_CHANGE);
        this.bondsVisibilityCombo.setSelectedItem(HIDE);
        this.bondsColorCombo.setSelectedItem(NO_CHANGE);
        this.bondsRadiusCombo.setSelectedItem(NO_CHANGE);
        this.bondsLabelsCombo.setSelectedItem(NO_CHANGE);
    }

    private void setWireframeBondsStyle() {
        this.atomsVisibilityCombo.setSelectedItem(HIDE);
        this.atomsColorCombo.setSelectedItem(NO_CHANGE);
        this.atomsRadiusCombo.setSelectedItem(NO_CHANGE);
        this.atomsLabelsCombo.setSelectedItem(NO_CHANGE);
        this.bondsVisibilityCombo.setSelectedItem(SHOW);
        this.bondsColorCombo.setSelectedItem(NO_CHANGE);
        this.bondsRadiusCombo.setSelectedItem("As Wireframe");
        this.bondsLabelsCombo.setSelectedItem(NO_CHANGE);
    }

    private void setAtomMarkersStyle() {
        this.atomsVisibilityCombo.setSelectedItem(SHOW);
        this.atomsColorCombo.setSelectedItem(NO_CHANGE);
        this.atomsRadiusCombo.setSelectedItem("By Constant (Smooth Bonds)");
        this.atomsLabelsCombo.setSelectedItem(NO_CHANGE);
        this.bondsVisibilityCombo.setSelectedItem(HIDE);
        this.bondsColorCombo.setSelectedItem(NO_CHANGE);
        this.bondsRadiusCombo.setSelectedItem(NO_CHANGE);
        this.bondsLabelsCombo.setSelectedItem(NO_CHANGE);
    }

    private void setAtomsBondsHideStyle() {
        this.atomsVisibilityCombo.setSelectedItem(HIDE);
        this.atomsColorCombo.setSelectedItem(NO_CHANGE);
        this.atomsRadiusCombo.setSelectedItem(NO_CHANGE);
        this.atomsLabelsCombo.setSelectedItem(NO_CHANGE);
        this.bondsVisibilityCombo.setSelectedItem(HIDE);
        this.bondsColorCombo.setSelectedItem(NO_CHANGE);
        this.bondsRadiusCombo.setSelectedItem(NO_CHANGE);
        this.bondsLabelsCombo.setSelectedItem(NO_CHANGE);
    }

    private void setAtomsBondsNoChange() {
        this.atomsVisibilityCombo.setSelectedItem(NO_CHANGE);
        this.atomsColorCombo.setSelectedItem(NO_CHANGE);
        this.atomsRadiusCombo.setSelectedItem(NO_CHANGE);
        this.atomsLabelsCombo.setSelectedItem(NO_CHANGE);
        this.bondsVisibilityCombo.setSelectedItem(NO_CHANGE);
        this.bondsColorCombo.setSelectedItem(NO_CHANGE);
        this.bondsRadiusCombo.setSelectedItem(NO_CHANGE);
        this.bondsLabelsCombo.setSelectedItem(NO_CHANGE);
    }

    private void setResiduesFragmentsWireframeBackboneStyle() {
        this.residuesColorCombo.setSelectedItem(NO_CHANGE);
        this.fragmentsVisibilityCombo.setSelectedItem(SHOW);
        this.fragmentsStyleCombo.setSelectedItem("Wireframe");
    }

    private void setTubeBackboneStyle() {
        this.residuesColorCombo.setSelectedItem(NO_CHANGE);
        this.fragmentsVisibilityCombo.setSelectedItem(SHOW);
        this.fragmentsStyleCombo.setSelectedItem("Tube");
    }

    private void setCartoonStyle() {
        this.residuesColorCombo.setSelectedItem(NO_CHANGE);
        this.fragmentsVisibilityCombo.setSelectedItem(SHOW);
        this.fragmentsStyleCombo.setSelectedItem("Cartoon");
    }

    private void setResiduesFragmentsHideStyle() {
        this.residuesColorCombo.setSelectedItem(NO_CHANGE);
        this.fragmentsVisibilityCombo.setSelectedItem(HIDE);
        this.fragmentsStyleCombo.setSelectedItem(NO_CHANGE);
    }

    private void setResiduesFragmentsNoChange() {
        this.residuesColorCombo.setSelectedItem(NO_CHANGE);
        this.fragmentsVisibilityCombo.setSelectedItem(NO_CHANGE);
        this.fragmentsStyleCombo.setSelectedItem(NO_CHANGE);
    }

    private void applyAtomsBondsStyles() {
        String string = (String)this.atomsVisibilityCombo.getSelectedItem();
        String string2 = (String)this.atomsColorCombo.getSelectedItem();
        String string3 = (String)this.atomsRadiusCombo.getSelectedItem();
        String string4 = (String)this.atomsLabelsCombo.getSelectedItem();
        String string5 = (String)this.bondsVisibilityCombo.getSelectedItem();
        String string6 = (String)this.bondsColorCombo.getSelectedItem();
        String string7 = (String)this.bondsRadiusCombo.getSelectedItem();
        String string8 = (String)this.bondsLabelsCombo.getSelectedItem();
        int n = this.structureDocument.getStructureCount();
        for (int i = 0; i < n; ++i) {
            Structure structure = this.structureDocument.getStructure(i);
            StructureMap structureMap = structure.getStructureMap();
            StructureStyles structureStyles = structureMap.getStructureStyles();
            if (string != NO_CHANGE) {
                if (string == SHOW) {
                    structureStyles.setAtomVisibility(true);
                } else {
                    structureStyles.setAtomVisibility(false);
                }
            }
            if (string2 != NO_CHANGE) {
                structureStyles.setAtomColor(AtomColorRegistry.get(string2));
            }
            if (string3 != NO_CHANGE) {
                structureStyles.setAtomRadius(AtomRadiusRegistry.get(string3));
            }
            if (string4 != NO_CHANGE) {
                structureStyles.setAtomLabel(AtomLabelRegistry.get(string4));
            }
            if (string5 != NO_CHANGE) {
                if (string5 == SHOW) {
                    structureStyles.setBondVisibility(true);
                } else {
                    structureStyles.setBondVisibility(false);
                }
            }
            if (string6 == NO_CHANGE) continue;
            structureStyles.setBondColor(BondColorRegistry.get(string6));
        }
        this.setAtomsBondsNoChange();
    }

    private void applyResiduesFragmentsStyles() {
        String string = (String)this.residuesColorCombo.getSelectedItem();
        String string2 = (String)this.fragmentsVisibilityCombo.getSelectedItem();
        String string3 = (String)this.fragmentsStyleCombo.getSelectedItem();
        int n = this.structureDocument.getStructureCount();
        for (int i = 0; i < n; ++i) {
            Structure structure = this.structureDocument.getStructure(i);
            StructureMap structureMap = structure.getStructureMap();
            StructureStyles structureStyles = structureMap.getStructureStyles();
            if (string != NO_CHANGE) {
                structureStyles.setResidueColor(ResidueColorRegistry.get(string));
            }
            if (string2 == NO_CHANGE) continue;
            if (string2 == SHOW) {
                structureStyles.setFragmentVisibility(true);
                continue;
            }
            structureStyles.setFragmentVisibility(false);
        }
        this.setResiduesFragmentsNoChange();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.elementStylesDialog != null) {
            this.elementStylesDialog.setBackground(color);
        }
        if (this.colorMapDialog != null) {
            this.colorMapDialog.setBackground(color);
        }
    }
}

