/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.gui;

import edu.sdsc.mbt.gui.StyleEditor;
import edu.sdsc.mbt.viewables.StructureDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class StyleEditorDialog
extends JDialog {
    protected Window parent = null;
    protected JPanel innerPanel = null;
    protected StyleEditor styleEditor = null;
    protected StructureDocument document = null;

    public StyleEditorDialog(StructureDocument structureDocument) {
        if (structureDocument == null) {
            throw new NullPointerException("null document");
        }
        this.parent = null;
        this.document = structureDocument;
        this.initialize();
    }

    public StyleEditorDialog(Frame frame, StructureDocument structureDocument) {
        super(frame, false);
        if (structureDocument == null) {
            throw new NullPointerException("null document");
        }
        this.parent = frame;
        this.document = structureDocument;
        this.initialize();
    }

    public StyleEditorDialog(Dialog dialog, StructureDocument structureDocument) {
        super(dialog, false);
        if (structureDocument == null) {
            throw new NullPointerException("null document");
        }
        this.parent = dialog;
        this.document = structureDocument;
        this.initialize();
    }

    protected void initialize() {
        this.setTitle("Structure style");
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(10, 10, 10, 10))));
        container.add((Component)this.innerPanel, "Center");
        this.styleEditor = new StyleEditor(this.document);
        this.innerPanel.add((Component)this.styleEditor, "Center");
        this.pack();
        this.validate();
    }

    public void show() {
        int n;
        int n2;
        Rectangle rectangle = this.getBounds();
        if (this.parent == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            n2 = dimension.width / 2 - rectangle.width / 2;
            n = dimension.height / 2 - rectangle.height / 2;
        } else {
            Rectangle rectangle2 = this.parent.getBounds();
            n2 = rectangle2.x + rectangle2.width / 2 - rectangle.width / 2;
            n = rectangle2.y + rectangle2.height / 2 - rectangle.height / 2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n < 0) {
            n = 0;
        }
        this.setLocation(n2, n);
        super.show();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.innerPanel != null) {
            this.innerPanel.setBackground(color);
        }
        if (this.styleEditor != null) {
            this.styleEditor.setBackground(color);
        }
    }
}

