/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.io;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Conformation;
import edu.sdsc.mbt.Helix;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureInfo;
import edu.sdsc.mbt.io.CifStructureLoaderImpl.MbtBuilder;
import edu.sdsc.mbt.io.FileStructureLoader;
import edu.sdsc.mbt.util.SharedObjects;
import edu.sdsc.mbt.util.Status;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.rcsb.openmms.cifparse.CifDictionary;
import org.rcsb.openmms.cifparse.CifParseException;
import org.rcsb.openmms.cifparse.CifParser;
import org.rcsb.openmms.cifparse.CifTokenizer;
import org.rcsb.openmms.cifparse.DictionaryItemList;

public class CifStructureLoader
implements FileStructureLoader {
    protected String urlString = null;
    protected CifDictionary cifDictionary = null;
    protected CifParser cifParser = null;
    protected MbtBuilder mbtBuilder = null;
    private boolean useLabelFields = true;
    protected Hashtable mbtToCifType = new Hashtable();

    public CifStructureLoader() throws Exception {
        this.mbtToCifType.put(StructureComponentRegistry.TYPE_ATOM, "_atom_site");
        this.mbtToCifType.put(StructureComponentRegistry.TYPE_COIL, "_struct_conf_coil");
        this.mbtToCifType.put(StructureComponentRegistry.TYPE_HELIX, "_struct_conf_helix");
        this.mbtToCifType.put(StructureComponentRegistry.TYPE_STRAND, "_struct_sheet_range");
        this.mbtToCifType.put(StructureComponentRegistry.TYPE_TURN, "_struct_conf_turn");
        String[] stringArray = new String[]{"cif_mm_V2.0.3.dic", "pdbx_exchange.dic"};
        String string = null;
        this.cifDictionary = new CifDictionary();
        this.cifParser = new CifParser();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                CifTokenizer cifTokenizer = new CifTokenizer(string);
                this.cifParser.readDictionary(cifTokenizer, this.cifDictionary, true);
                cifTokenizer.close();
            }
        }
        catch (IOException iOException) {
            throw new Exception("CifStructureLoader: could not find dictionary " + string);
        }
        catch (CifParseException cifParseException) {
            throw new Exception("CifStructureLoader: could not parse dictionary " + string);
        }
    }

    public void setUseLabelFields(boolean bl) {
        this.useLabelFields = bl;
    }

    public boolean getUseLabelFields() {
        return this.useLabelFields;
    }

    public String getLoaderName() {
        return new String("Cif Structure Loader");
    }

    public Structure load(String string) {
        Object object;
        if (!this.canLoad(string)) {
            return null;
        }
        try {
            object = new CifTokenizer(string);
            DictionaryItemList dictionaryItemList = this.cifDictionary.getDictionaryItemList();
            this.mbtBuilder = new MbtBuilder(this.cifParser, dictionaryItemList);
            this.cifParser.setBuilder(this.mbtBuilder);
            this.cifParser.readDataBlock((CifTokenizer)object, dictionaryItemList);
            this.cifParser.setBuilder(null);
            ((CifTokenizer)object).close();
        }
        catch (Exception exception) {
            Status.output(1, "CifStructureLoader.load, exception " + exception);
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Status.output(1, "CifStructureLoader.load, error " + outOfMemoryError);
            return null;
        }
        object = null;
        try {
            object = new Structure(){
                String urlStr = null;
                Hashtable single_items = null;
                Hashtable multi_items = null;
                SharedObjects sharedStrings = new SharedObjects();
                Hashtable blankChainIdFlags = new Hashtable();
                private Hashtable scCache;
                {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    this.urlStr = CifStructureLoader.this.urlString;
                    CifStructureLoader.this.urlString = null;
                    this.single_items = CifStructureLoader.this.mbtBuilder.getSingles();
                    this.multi_items = CifStructureLoader.this.mbtBuilder.getMultis();
                    CifStructureLoader.this.mbtBuilder = null;
                    Vector vector = (Vector)this.multi_items.get("_struct_asym");
                    if (vector != null) {
                        for (int i = 0; i < vector.size(); ++i) {
                            object4 = (Hashtable)vector.get(i);
                            object3 = (String)((Hashtable)object4).get("_struct_asym.id");
                            String string = (String)((Hashtable)object4).get("_struct_asym.pdbx_blank_PDB_chainid_flag");
                            if (!string.equals("Y")) continue;
                            this.blankChainIdFlags.put(object3, string);
                        }
                    }
                    StructureInfo structureInfo = new StructureInfo();
                    object4 = null;
                    object3 = null;
                    object4 = (String)this.single_items.get("_struct.entry_id");
                    structureInfo.setIdCode((String)object4);
                    object4 = (String)this.single_items.get("_struct.pdbx_descriptor");
                    if (object4 != null && ((String)object4).length() > 20) {
                        object4 = ((String)object4).substring(0, 20) + "...";
                    }
                    structureInfo.setShortName((String)object4);
                    object4 = (String)this.single_items.get("_struct.title");
                    structureInfo.setLongName((String)object4);
                    object4 = (String)this.single_items.get("_database_PDB_rev.date");
                    structureInfo.setReleaseDate((String)object4);
                    object4 = null;
                    object3 = (Vector)this.multi_items.get("_citation_author");
                    if (object3 != null) {
                        for (int i = 0; i < ((Vector)object3).size(); ++i) {
                            object2 = (Hashtable)((Vector)object3).get(i);
                            object = (String)((Hashtable)object2).get("_citation_author.name");
                            if (object == null) continue;
                            object4 = object4 == null ? object : (String)object4 + ", " + (String)object;
                        }
                    }
                    structureInfo.setAuthors((String)object4);
                    object4 = (String)this.single_items.get("_exptl.method");
                    structureInfo.setDeterminationMethod((String)object4);
                    this.setStructureInfo(structureInfo);
                    this.single_items.clear();
                    String string = StructureComponentRegistry.TYPE_ATOM;
                    object2 = (String)CifStructureLoader.this.mbtToCifType.get(string);
                    object = (Vector)this.multi_items.get(object2);
                    if (object != null) {
                        String string2;
                        int n = ((Vector)object).size();
                        Hashtable hashtable = (Hashtable)((Vector)object).get(0);
                        if (hashtable != null && (string2 = (String)hashtable.get("_atom_site.pdbx_PDB_model_num")) != null) {
                            for (int i = n - 1; i > 0; --i) {
                                String string3;
                                hashtable = (Hashtable)((Vector)object).get(i);
                                if (hashtable == null || (string3 = (String)hashtable.get("_atom_site.pdbx_PDB_model_num")) == null || string3.equals(string2)) continue;
                                ((Vector)object).remove(i);
                            }
                        }
                    }
                    this.scCache = new Hashtable();
                }

                public String getUrlString() {
                    return this.urlStr;
                }

                public int getStructureComponentCount(String string) {
                    String string2 = (String)CifStructureLoader.this.mbtToCifType.get(string);
                    if (string2 == null) {
                        return 0;
                    }
                    int n = 0;
                    Vector vector = (Vector)this.multi_items.get(string2);
                    if (vector != null && (n = vector.size()) > 0) {
                        return n;
                    }
                    String string3 = (String)this.single_items.get(string2);
                    if (string3 != null) {
                        return 1;
                    }
                    return 0;
                }

                private void getStructureComponentByIndex(int n, StructureComponent structureComponent) throws IndexOutOfBoundsException, IllegalArgumentException {
                    block15: {
                        String string = structureComponent.getStructureComponentType();
                        String string2 = (String)CifStructureLoader.this.mbtToCifType.get(string);
                        structureComponent.structure = this;
                        try {
                            if (string == StructureComponentRegistry.TYPE_ATOM) {
                                Vector vector = (Vector)this.multi_items.get(string2);
                                Hashtable hashtable = (Hashtable)vector.get(n);
                                Atom atom = (Atom)structureComponent;
                                String string3 = (String)hashtable.get("_atom_site.id");
                                try {
                                    atom.number = Integer.parseInt(string3);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    atom.number = -1;
                                }
                                atom.element = (String)hashtable.get("_atom_site.type_symbol");
                                atom.element = this.sharedStrings.share(atom.element);
                                atom.name = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_atom_site.label_atom_id") : (String)hashtable.get("_atom_site.auth_atom_id");
                                atom.name = this.sharedStrings.share(atom.name);
                                atom.altLoc = (String)hashtable.get("_atom_site.label_alt_id");
                                atom.altLoc = this.sharedStrings.share(atom.altLoc);
                                atom.compound = (String)hashtable.get("_atom_site.label_comp_id");
                                atom.compound = this.sharedStrings.share(atom.compound);
                                atom.chain_id = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_atom_site.label_asym_id") : (String)hashtable.get("_atom_site.auth_asym_id");
                                if (this.blankChainIdFlags.get(atom.chain_id) != null) {
                                    atom.chain_id = "_";
                                }
                                atom.chain_id = this.sharedStrings.share(atom.chain_id);
                                atom.residue_id = -1;
                                try {
                                    string3 = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_atom_site.label_seq_id") : (String)hashtable.get("_atom_site.auth_seq_id");
                                    atom.residue_id = Integer.parseInt(string3);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    string3 = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_atom_site.auth_seq_id") : (String)hashtable.get("_atom_site.label_seq_id");
                                    atom.residue_id = Integer.parseInt(string3);
                                }
                                string3 = (String)hashtable.get("_atom_site.Cartn_x");
                                atom.coordinate[0] = Double.parseDouble(string3);
                                string3 = (String)hashtable.get("_atom_site.Cartn_y");
                                atom.coordinate[1] = Double.parseDouble(string3);
                                string3 = (String)hashtable.get("_atom_site.Cartn_z");
                                atom.coordinate[2] = Double.parseDouble(string3);
                                string3 = (String)hashtable.get("_atom_site.occupancy");
                                atom.occupancy = Float.parseFloat(string3);
                                string3 = (String)hashtable.get("_atom_site.B_iso_or_equiv");
                                atom.bfactor = Float.parseFloat(string3);
                                vector.set(n, null);
                                break block15;
                            }
                            if (string == StructureComponentRegistry.TYPE_COIL || string == StructureComponentRegistry.TYPE_HELIX || string == StructureComponentRegistry.TYPE_TURN) {
                                Vector vector = (Vector)this.multi_items.get(string2);
                                Hashtable hashtable = (Hashtable)vector.get(n);
                                Conformation conformation = (Conformation)structureComponent;
                                String string4 = (String)hashtable.get("_struct_conf.id");
                                String string5 = string4.toLowerCase();
                                conformation.name = string4;
                                if (string == StructureComponentRegistry.TYPE_HELIX) {
                                    string4 = (String)hashtable.get("_struct_conf.conf_type_id");
                                    Helix helix = (Helix)conformation;
                                    helix.righthand = string4.startsWith("HELX_RH");
                                }
                                conformation.start_compound = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_conf.beg_label_comp_id") : (String)hashtable.get("_struct_conf.beg_auth_comp_id");
                                conformation.start_compound = this.sharedStrings.share(conformation.start_compound);
                                conformation.start_chain = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_conf.beg_label_asym_id") : (String)hashtable.get("_struct_conf.beg_auth_asym_id");
                                if (this.blankChainIdFlags.get(conformation.start_chain) != null) {
                                    conformation.start_chain = "_";
                                }
                                conformation.start_chain = this.sharedStrings.share(conformation.start_chain);
                                string4 = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_conf.beg_label_seq_id") : (String)hashtable.get("_struct_conf.beg_auth_seq_id");
                                conformation.start_residue = Integer.parseInt(string4);
                                conformation.end_compound = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_conf.end_label_comp_id") : (String)hashtable.get("_struct_conf.end_auth_comp_id");
                                conformation.end_compound = this.sharedStrings.share(conformation.end_compound);
                                conformation.end_chain = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_conf.end_label_asym_id") : (String)hashtable.get("_struct_conf.end_auth_asym_id");
                                if (this.blankChainIdFlags.get(conformation.end_chain) != null) {
                                    conformation.end_chain = "_";
                                }
                                conformation.end_chain = this.sharedStrings.share(conformation.end_chain);
                                string4 = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_conf.end_label_seq_id") : (String)hashtable.get("_struct_conf.end_auth_seq_id");
                                conformation.end_residue = Integer.parseInt(string4);
                                vector.set(n, null);
                                break block15;
                            }
                            if (string == StructureComponentRegistry.TYPE_STRAND) {
                                Vector vector = (Vector)this.multi_items.get(string2);
                                Hashtable hashtable = (Hashtable)vector.get(n);
                                Conformation conformation = (Conformation)structureComponent;
                                String string6 = (String)hashtable.get("_struct_sheet_range.id");
                                String string7 = string6.toLowerCase();
                                conformation.name = string6;
                                conformation.name = this.sharedStrings.share(conformation.name);
                                conformation.start_compound = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_sheet_range.beg_label_comp_id") : (String)hashtable.get("_struct_sheet_range.beg_auth_comp_id");
                                conformation.start_compound = this.sharedStrings.share(conformation.start_compound);
                                conformation.start_chain = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_sheet_range.beg_label_asym_id") : (String)hashtable.get("_struct_sheet_range.beg_auth_asym_id");
                                if (this.blankChainIdFlags.get(conformation.start_chain) != null) {
                                    conformation.start_chain = "_";
                                }
                                conformation.start_chain = this.sharedStrings.share(conformation.start_chain);
                                string6 = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_sheet_range.beg_label_seq_id") : (String)hashtable.get("_struct_sheet_range.beg_auth_seq_id");
                                conformation.start_residue = Integer.parseInt(string6);
                                conformation.end_compound = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_sheet_range.end_label_comp_id") : (String)hashtable.get("_struct_sheet_range.end_auth_comp_id");
                                conformation.end_compound = this.sharedStrings.share(conformation.end_compound);
                                conformation.end_chain = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_sheet_range.end_label_asym_id") : (String)hashtable.get("_struct_sheet_range.end_auth_asym_id");
                                if (this.blankChainIdFlags.get(conformation.end_chain) != null) {
                                    conformation.end_chain = "_";
                                }
                                conformation.end_chain = this.sharedStrings.share(conformation.end_chain);
                                string6 = CifStructureLoader.this.useLabelFields ? (String)hashtable.get("_struct_sheet_range.end_label_seq_id") : (String)hashtable.get("_struct_sheet_range.end_auth_seq_id");
                                conformation.end_residue = Integer.parseInt(string6);
                                vector.set(n, null);
                                break block15;
                            }
                            throw new IllegalArgumentException("unsupported type");
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                            throw new IllegalArgumentException("Bad number in " + string + " " + n + " in " + this.urlStr + ": " + numberFormatException.toString());
                        }
                    }
                }

                public StructureComponent getStructureComponentByIndex(String string, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
                    StructureComponent structureComponent;
                    Vector<StructureComponent> vector = (Vector<StructureComponent>)this.scCache.get(string);
                    if (vector == null) {
                        int n2 = this.getStructureComponentCount(string);
                        vector = new Vector<StructureComponent>(n2);
                        for (int i = 0; i < n2; ++i) {
                            vector.add(null);
                        }
                        this.scCache.put(string, vector);
                    }
                    if ((structureComponent = (StructureComponent)vector.elementAt(n)) != null) {
                        return structureComponent;
                    }
                    try {
                        structureComponent = (StructureComponent)Class.forName(string).newInstance();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    vector.setElementAt(structureComponent, n);
                    this.getStructureComponentByIndex(n, structureComponent);
                    return structureComponent;
                }
            };
        }
        catch (Exception exception) {
            object = null;
            Status.output(1, "CifStructureLoader.load, exception " + exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            object = null;
            Status.output(1, "CifStructureLoader.load, error " + outOfMemoryError);
        }
        this.mbtBuilder = null;
        return object;
    }

    public boolean canLoad(String string) {
        this.urlString = string;
        boolean bl = false;
        if (string.startsWith("file:")) {
            bl = true;
        }
        if (string.startsWith("http:")) {
            bl = true;
        }
        if (string.startsWith("ftp:")) {
            bl = true;
        }
        boolean bl2 = false;
        if (string.endsWith(".cif")) {
            bl2 = true;
        }
        if (string.endsWith(".cif.zip")) {
            bl2 = true;
        }
        if (string.endsWith(".cif.gz")) {
            bl2 = true;
        }
        if (string.endsWith(".cif.Z")) {
            bl2 = true;
        }
        return bl && bl2;
    }

    public Structure load(File file) {
        Structure structure = null;
        try {
            structure = this.load(file.toURL().toExternalForm());
        }
        catch (Exception exception) {
            structure = null;
            Status.output(1, "CifStructureLoader.load, exception " + exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            structure = null;
            Status.output(1, "CifStructureLoader.load, error " + outOfMemoryError);
        }
        return structure;
    }

    public boolean canLoad(File file) {
        try {
            return this.canLoad(file.toURL().toExternalForm());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Structure load(URL uRL) {
        Structure structure = null;
        try {
            structure = this.load(uRL.toExternalForm());
        }
        catch (Exception exception) {
            structure = null;
            Status.output(1, "CifStructureLoader.load, exception " + exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            structure = null;
            Status.output(1, "CifStructureLoader.load, error " + outOfMemoryError);
        }
        return structure;
    }

    public boolean canLoad(URL uRL) {
        return this.canLoad(uRL.toExternalForm());
    }
}

