/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.io.CifStructureLoaderImpl;

import java.util.Hashtable;
import java.util.Vector;
import org.rcsb.openmms.cifparse.Builder;
import org.rcsb.openmms.cifparse.CifParseException;
import org.rcsb.openmms.cifparse.CifParser;
import org.rcsb.openmms.cifparse.CifTokenizer;
import org.rcsb.openmms.cifparse.DataItem;
import org.rcsb.openmms.cifparse.DataItemList;

public class MbtBuilder
implements Builder {
    CifParser cifParser;
    DataItemList dataItemList;
    Hashtable single_values = new Hashtable();
    Hashtable multi_values = new Hashtable();
    String lastKey = null;
    String lastValue = null;
    Vector lastVector = null;
    Hashtable lastHashtable = null;
    private boolean differentiatedConformations = false;
    private Runtime runtime = Runtime.getRuntime();

    public MbtBuilder(CifParser cifParser, DataItemList dataItemList) {
        this.cifParser = cifParser;
        this.dataItemList = dataItemList;
    }

    public void readDataBlock(String string, CifTokenizer cifTokenizer) throws CifParseException {
        this.cifParser.readDataBlock(cifTokenizer, this.dataItemList);
    }

    public Hashtable getSingles() {
        return this.single_values;
    }

    public Hashtable getMultis() {
        if (!this.differentiatedConformations) {
            this.differentiatedConformations = true;
            Vector vector = (Vector)this.multi_values.get("_struct_conf");
            if (vector != null) {
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    Hashtable hashtable = (Hashtable)vector.get(i);
                    String string = (String)hashtable.get("_struct_conf.conf_type_id");
                    string = string.toLowerCase();
                    String string2 = null;
                    if (string.startsWith("coil")) {
                        string2 = "_struct_conf_coil";
                    } else if (string.startsWith("helx")) {
                        string2 = "_struct_conf_helix";
                    } else if (string.startsWith("strand")) {
                        string2 = "_struct_conf_strand";
                    } else if (string.startsWith("turn")) {
                        string2 = "_struct_conf_turn";
                    }
                    if (string2 == null) continue;
                    Vector<Hashtable> vector2 = (Vector<Hashtable>)this.multi_values.get(string2);
                    if (vector2 == null) {
                        vector2 = new Vector<Hashtable>();
                        this.multi_values.put(string2, vector2);
                    }
                    vector2.add(hashtable);
                }
            }
        }
        return this.multi_values;
    }

    public void beginCompound() throws CifParseException {
    }

    public void endCompound() throws CifParseException {
    }

    public void setSingleItem(DataItem dataItem) throws CifParseException {
    }

    public void insertSingleValue(DataItem dataItem, String string) throws CifParseException {
        this.lastKey = dataItem.getItemName();
        this.lastValue = string;
        this.single_values.put(this.lastKey, this.lastValue);
    }

    public void beginLoop() throws CifParseException {
        this.lastVector = new Vector();
    }

    public void endLoop() throws CifParseException {
        String string = null;
        if (this.lastVector.size() > 0 && this.keepLoop(string = this.lastKey.substring(0, this.lastKey.indexOf(".")))) {
            this.multi_values.put(string, this.lastVector);
        }
        this.lastVector = null;
    }

    private boolean keepLoop(String string) {
        if (string.equals("_citation_author")) {
            return true;
        }
        if (string.equals("_atom_site")) {
            return true;
        }
        if (string.equals("_struct_conf")) {
            return true;
        }
        if (string.equals("_struct_sheet_range")) {
            return true;
        }
        return string.equals("_struct_asym");
    }

    public void beginRow() throws CifParseException {
        this.lastHashtable = new Hashtable();
    }

    public void endRow() throws CifParseException {
        if (this.lastHashtable.size() > 0) {
            this.lastVector.add(this.lastHashtable);
        }
        this.lastHashtable = null;
    }

    public void setLoopItem(int n, DataItem dataItem) throws CifParseException {
    }

    public void insertLoopValue(int n, DataItem dataItem, String string) throws CifParseException {
        if (dataItem == null) {
            return;
        }
        if (string == null) {
            return;
        }
        this.lastKey = dataItem.getItemName();
        if (this.lastKey == null) {
            return;
        }
        this.lastValue = string;
        this.lastHashtable.put(this.lastKey, this.lastValue);
    }
}

