/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.io;

import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.io.FileStructureLoader;
import edu.sdsc.mbt.util.AminoAcidInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class FastaStructureLoader
implements FileStructureLoader {
    protected String urlString;

    public String getLoaderName() {
        return new String("Fasta Structure Loader");
    }

    public Structure load(String string) {
        if (!this.canLoad(string)) {
            return null;
        }
        Structure structure = null;
        try {
            File file = new File(string);
            structure = this.load(file);
        }
        catch (NullPointerException nullPointerException) {
            try {
                URL uRL = new URL(string);
                structure = this.load(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return structure;
    }

    public boolean canLoad(String string) {
        this.urlString = string;
        if (!string.endsWith(".fsa")) {
            return false;
        }
        return string.startsWith("file:") || string.startsWith("http:") || string.startsWith("ftp:");
    }

    public Structure load(File file) {
        if (!this.canLoad(file)) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public boolean canLoad(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            String string = file.getCanonicalPath();
            string = "file:" + string;
            return this.canLoad(string);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Structure load(URL uRL) {
        if (!this.canLoad(uRL)) {
            return null;
        }
        try {
            InputStream inputStream = uRL.openStream();
            return this.load(inputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean canLoad(URL uRL) {
        return this.canLoad(uRL.toExternalForm());
    }

    public Structure load(InputStream inputStream) {
        byte[] byArray;
        int n = 0;
        int n2 = 0;
        try {
            n = inputStream.available();
            byArray = new byte[n];
            n2 = inputStream.read(byArray, 0, n);
            inputStream.close();
            if (n2 != n) {
                return null;
            }
        }
        catch (IOException iOException) {
            try {
                inputStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return null;
        }
        int n3 = 0;
        if (byArray[0] == 62) {
            for (n3 = 0; n3 < n && byArray[n3] != 10 && byArray[n3] != 13; ++n3) {
            }
            ++n3;
        }
        int n4 = 0;
        for (int i = n3; i < n; ++i) {
            if (byArray[i] == 10 || byArray[i] == 13) continue;
            ++n4;
        }
        final byte[] byArray2 = new byte[n4];
        int n5 = 0;
        for (int i = n3; i < n; ++i) {
            if (byArray[i] == 10 || byArray[i] == 13) continue;
            byArray2[n5++] = byArray[i];
        }
        Structure structure = new Structure(){
            String urlStr;
            byte[] data;
            private Vector residues;
            {
                this.urlStr = FastaStructureLoader.this.urlString;
                this.data = byArray2;
                this.residues = null;
            }

            public String getUrlString() {
                return this.urlStr;
            }

            public int getStructureComponentCount(String string) {
                if (string == StructureComponentRegistry.TYPE_RESIDUE) {
                    return this.data.length;
                }
                return 0;
            }

            private void getStructureComponentByIndex(int n, StructureComponent structureComponent) throws IndexOutOfBoundsException, IllegalArgumentException {
                if (structureComponent.getStructureComponentType() != StructureComponentRegistry.TYPE_RESIDUE) {
                    throw new IllegalArgumentException("type mismatch");
                }
                structureComponent.structure = this;
                Residue residue = (Residue)structureComponent;
                residue.setCompoundCode(AminoAcidInfo.getCodeFromLetter(this.data[n]));
            }

            public StructureComponent getStructureComponentByIndex(String string, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
                Residue residue;
                if (string != StructureComponentRegistry.TYPE_RESIDUE) {
                    throw new IllegalArgumentException("type mismatch");
                }
                if (this.residues == null) {
                    int n2 = this.getStructureComponentCount(StructureComponentRegistry.TYPE_RESIDUE);
                    this.residues = new Vector(n2);
                    for (int i = 0; i < n2; ++i) {
                        this.residues.add(null);
                    }
                }
                if ((residue = (Residue)this.residues.elementAt(n)) != null) {
                    return residue;
                }
                String string2 = AminoAcidInfo.getCodeFromLetter(this.data[n]);
                residue = new Residue(string2);
                residue.structure = this;
                this.residues.setElementAt(residue, n);
                return residue;
            }
        };
        return structure;
    }
}

