/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.io;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Helix;
import edu.sdsc.mbt.Strand;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureInfo;
import edu.sdsc.mbt.Turn;
import edu.sdsc.mbt.io.FileStructureLoader;
import edu.sdsc.mbt.util.PeriodicTable;
import edu.sdsc.mbt.util.SharedObjects;
import edu.sdsc.mbt.util.Status;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class PdbStructureLoader
implements FileStructureLoader {
    protected String urlString = null;
    private long expectedInputBytes = 1L;
    protected Hashtable passComponents = null;
    protected StructureInfo structureInfo = null;

    public String getLoaderName() {
        return new String("PDB Structure Loader");
    }

    public Structure load(String string) {
        Structure structure = null;
        try {
            File file = new File(string);
            structure = this.load(file);
        }
        catch (NullPointerException nullPointerException) {
            try {
                URL uRL = new URL(string);
                structure = this.load(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (structure != null) {
            this.urlString = string;
        }
        return structure;
    }

    public boolean canLoad(String string) {
        if (!string.endsWith(".pdb") && !string.endsWith(".pdb.gz")) {
            return false;
        }
        return string.startsWith("file:") || string.startsWith("http:") || string.startsWith("ftp:");
    }

    public Structure load(File file) {
        if (!this.canLoad(file)) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        this.expectedInputBytes = file.length();
        if (this.expectedInputBytes <= 0L) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (fileInputStream == null) {
                return null;
            }
            this.urlString = file.toURL().toExternalForm();
            BufferedInputStream bufferedInputStream = null;
            if (this.urlString.endsWith(".gz")) {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
                bufferedInputStream = new BufferedInputStream(gZIPInputStream);
                this.expectedInputBytes *= 4L;
            } else {
                bufferedInputStream = new BufferedInputStream(fileInputStream);
            }
            return this.load(bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean canLoad(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            String string = file.toURL().toExternalForm();
            return this.canLoad(string);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Structure load(URL uRL) {
        if (!this.canLoad(uRL)) {
            return null;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.expectedInputBytes = uRLConnection.getContentLength();
            if (this.expectedInputBytes <= 0L) {
                return null;
            }
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedInputStream bufferedInputStream = null;
            if (inputStream != null) {
                this.urlString = uRL.toExternalForm();
            }
            if (this.urlString.endsWith(".pdb.gz")) {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
                bufferedInputStream = new BufferedInputStream(gZIPInputStream);
            } else {
                bufferedInputStream = new BufferedInputStream(inputStream);
            }
            return this.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            Status.output(1, "PdbStructureLoader.load( " + uRL + " ): " + iOException);
            return null;
        }
    }

    public boolean canLoad(URL uRL) {
        return this.canLoad(uRL.toExternalForm());
    }

    public Structure load(BufferedInputStream bufferedInputStream) {
        if (bufferedInputStream == null) {
            return null;
        }
        SharedObjects sharedObjects = new SharedObjects();
        this.passComponents = new Hashtable();
        long l = this.expectedInputBytes;
        byte[] byArray = new byte[2048];
        byte[] byArray2 = new byte[100];
        int n = (int)((float)l / (float)byArray.length);
        int n2 = (int)((float)l / (float)byArray.length / 100.0f);
        if (n2 <= 0) {
            n2 = 1;
        }
        float f = 0.0f;
        Status.progress(f, "Loading " + this.urlString);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        try {
            while (bufferedInputStream.available() > 0) {
                try {
                    n5 = bufferedInputStream.read(byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    Status.output(1, "PdbStructureLoader.load( stream ): " + iOException);
                    return null;
                }
                n4 += n5;
                if (++n7 % n2 == 0) {
                    f = (float)n4 / (float)l;
                    Status.progress(f, "Loading " + this.urlString);
                }
                for (int i = 0; i < n5; ++i) {
                    byArray2[n3] = byArray[i];
                    if (byArray[i] == 10) {
                        Vector<Helix> vector;
                        ++n6;
                        boolean bl = false;
                        if (byArray2[0] == 65 && byArray2[1] == 84 && byArray2[2] == 79 && byArray2[3] == 77) {
                            bl = true;
                        } else if (byArray2[0] == 72 && byArray2[1] == 69 && byArray2[2] == 84 && byArray2[3] == 65 && byArray2[4] == 84 && byArray2[5] == 77) {
                            bl = true;
                        }
                        if (bl) {
                            Atom atom = new Atom();
                            vector = null;
                            atom.number = Integer.parseInt(new String(byArray2, 6, 5).trim());
                            atom.name = new String(byArray2, 12, 4).trim();
                            atom.name = sharedObjects.share(atom.name);
                            atom.element = new String(byArray2, 76, 2).trim();
                            atom.element = atom.element.replaceAll("[0-9]", "");
                            if (atom.element == null || atom.element.equals("") || PeriodicTable.getElement(atom.element) == null) {
                                atom.element = atom.name.substring(0, 1);
                                if (PeriodicTable.getElement(atom.element) == null) {
                                    throw new IllegalArgumentException("no atom element symbol around line " + n6);
                                }
                            }
                            atom.element = sharedObjects.share(atom.element);
                            atom.altLoc = new String(byArray2, 16, 1).trim();
                            atom.altLoc = sharedObjects.share(atom.altLoc);
                            atom.compound = new String(byArray2, 17, 3).trim();
                            atom.compound = sharedObjects.share(atom.compound);
                            atom.chain_id = new String(byArray2, 21, 1).trim();
                            if (atom.chain_id == null) {
                                atom.chain_id = "_";
                            } else if (atom.chain_id.equals("")) {
                                atom.chain_id = "_";
                            }
                            atom.chain_id = sharedObjects.share(atom.chain_id);
                            atom.residue_id = Integer.parseInt(new String(byArray2, 22, 4).trim());
                            atom.coordinate = new double[3];
                            atom.coordinate[0] = Double.parseDouble(new String(byArray2, 30, 8).trim());
                            atom.coordinate[1] = Double.parseDouble(new String(byArray2, 38, 8).trim());
                            atom.coordinate[2] = Double.parseDouble(new String(byArray2, 46, 8).trim());
                            vector = new String(byArray2, 54, 6).trim();
                            atom.occupancy = ((String)((Object)vector)).length() == 0 ? 1.0f : Float.parseFloat((String)((Object)vector));
                            vector = new String(byArray2, 60, 6).trim();
                            atom.bfactor = ((String)((Object)vector)).length() == 0 ? 0.0f : Float.parseFloat((String)((Object)vector));
                            Vector<Atom> vector2 = (Vector<Atom>)this.passComponents.get(StructureComponentRegistry.TYPE_ATOM);
                            if (vector2 == null) {
                                vector2 = new Vector<Atom>();
                                this.passComponents.put(StructureComponentRegistry.TYPE_ATOM, vector2);
                            }
                            vector2.add(atom);
                            n3 = 0;
                            continue;
                        }
                        if (byArray2[0] == 72 && byArray2[1] == 69 && byArray2[2] == 76 && byArray2[3] == 73 && byArray2[4] == 88) {
                            Helix helix = new Helix();
                            helix.name = new String(byArray2, 0, 6).trim();
                            helix.name = sharedObjects.share(helix.name);
                            helix.start_compound = new String(byArray2, 15, 3).trim();
                            helix.start_compound = sharedObjects.share(helix.start_compound);
                            helix.start_chain = new String(byArray2, 19, 1).trim();
                            if (helix.start_chain == null) {
                                helix.start_chain = "A";
                            }
                            helix.start_chain = sharedObjects.share(helix.start_chain);
                            helix.start_residue = Integer.parseInt(new String(byArray2, 21, 4).trim());
                            helix.end_compound = new String(byArray2, 27, 3).trim();
                            helix.end_compound = sharedObjects.share(helix.end_compound);
                            helix.end_chain = new String(byArray2, 31, 1).trim();
                            if (helix.end_chain == null) {
                                helix.end_chain = "A";
                            }
                            helix.end_chain = sharedObjects.share(helix.end_chain);
                            helix.end_residue = Integer.parseInt(new String(byArray2, 33, 4).trim());
                            helix.righthand = true;
                            vector = (Vector)this.passComponents.get(StructureComponentRegistry.TYPE_HELIX);
                            if (vector == null) {
                                vector = new Vector();
                                this.passComponents.put(StructureComponentRegistry.TYPE_HELIX, vector);
                            }
                            vector.add(helix);
                            n3 = 0;
                            continue;
                        }
                        if (byArray2[0] == 84 && byArray2[1] == 85 && byArray2[2] == 82 && byArray2[3] == 78) {
                            Turn turn = new Turn();
                            turn.name = new String(byArray2, 0, 6).trim();
                            turn.name = sharedObjects.share(turn.name);
                            turn.start_compound = new String(byArray2, 15, 3).trim();
                            turn.start_compound = sharedObjects.share(turn.start_compound);
                            turn.start_chain = new String(byArray2, 19, 1).trim();
                            if (turn.start_chain == null) {
                                turn.start_chain = "A";
                            }
                            turn.start_chain = sharedObjects.share(turn.start_chain);
                            turn.start_residue = Integer.parseInt(new String(byArray2, 20, 4).trim());
                            turn.end_compound = new String(byArray2, 26, 3).trim();
                            turn.end_compound = sharedObjects.share(turn.end_compound);
                            turn.end_chain = new String(byArray2, 30, 1).trim();
                            if (turn.end_chain == null) {
                                turn.end_chain = "A";
                            }
                            turn.end_chain = sharedObjects.share(turn.end_chain);
                            turn.end_residue = Integer.parseInt(new String(byArray2, 31, 4).trim());
                            vector = (Vector)this.passComponents.get(StructureComponentRegistry.TYPE_TURN);
                            if (vector == null) {
                                vector = new Vector<Helix>();
                                this.passComponents.put(StructureComponentRegistry.TYPE_TURN, vector);
                            }
                            vector.add((Helix)((Object)turn));
                            n3 = 0;
                            continue;
                        }
                        if (byArray2[0] == 83 && byArray2[1] == 72 && byArray2[2] == 69 && byArray2[3] == 69 && byArray2[4] == 84) {
                            Strand strand = new Strand();
                            strand.name = new String(byArray2, 0, 6).trim();
                            strand.name = sharedObjects.share(strand.name);
                            strand.start_compound = new String(byArray2, 17, 3).trim();
                            strand.start_compound = sharedObjects.share(strand.start_compound);
                            strand.start_chain = new String(byArray2, 21, 1).trim();
                            if (strand.start_chain == null) {
                                strand.start_chain = "A";
                            }
                            strand.start_chain = sharedObjects.share(strand.start_chain);
                            strand.start_residue = Integer.parseInt(new String(byArray2, 22, 4).trim());
                            strand.end_compound = new String(byArray2, 28, 3).trim();
                            strand.end_compound = sharedObjects.share(strand.end_compound);
                            strand.end_chain = new String(byArray2, 32, 1).trim();
                            if (strand.end_chain == null) {
                                strand.end_chain = "A";
                            }
                            strand.end_chain = sharedObjects.share(strand.end_chain);
                            strand.end_residue = Integer.parseInt(new String(byArray2, 33, 4).trim());
                            vector = (Vector<Helix>)this.passComponents.get(StructureComponentRegistry.TYPE_STRAND);
                            if (vector == null) {
                                vector = new Vector<Helix>();
                                this.passComponents.put(StructureComponentRegistry.TYPE_STRAND, vector);
                            }
                            vector.add((Helix)((Object)strand));
                            n3 = 0;
                            continue;
                        }
                        if (byArray2[0] == 72 && byArray2[1] == 69 && byArray2[2] == 65 && byArray2[3] == 68 && byArray2[4] == 69 && byArray2[5] == 82) {
                            if (this.structureInfo == null) {
                                this.structureInfo = new StructureInfo();
                            }
                            this.structureInfo.setReleaseDate(new String(byArray2, 50, 9).trim());
                            this.structureInfo.setIdCode(new String(byArray2, 62, 4).trim());
                            n3 = 0;
                            continue;
                        }
                        if (byArray2[0] == 65 && byArray2[1] == 85 && byArray2[2] == 84 && byArray2[3] == 72 && byArray2[4] == 79 && byArray2[5] == 82) {
                            if (this.structureInfo == null) {
                                this.structureInfo = new StructureInfo();
                            }
                            String string = this.structureInfo.getAuthors();
                            vector = new String(byArray2, 10, 60).trim();
                            if (string == null) {
                                this.structureInfo.setAuthors((String)((Object)vector));
                            } else {
                                this.structureInfo.setAuthors(string + (String)((Object)vector));
                            }
                            n3 = 0;
                            continue;
                        }
                        if (byArray2[0] == 67 && byArray2[1] == 79 && byArray2[2] == 77 && byArray2[3] == 80 && byArray2[4] == 78 && byArray2[5] == 68) {
                            if (this.structureInfo == null) {
                                this.structureInfo = new StructureInfo();
                            }
                            String string = this.structureInfo.getLongName();
                            vector = new String(byArray2, 10, 60).trim();
                            if (string == null) {
                                this.structureInfo.setLongName((String)((Object)vector));
                                if (((String)((Object)vector)).length() > 20) {
                                    this.structureInfo.setShortName(((String)((Object)vector)).substring(0, 20) + "...");
                                } else {
                                    this.structureInfo.setShortName((String)((Object)vector));
                                }
                            } else {
                                this.structureInfo.setLongName(string + " : " + (String)((Object)vector));
                            }
                            n3 = 0;
                            continue;
                        }
                        if (byArray2[0] == 69 && byArray2[1] == 88 && byArray2[2] == 80 && byArray2[3] == 68 && byArray2[4] == 84 && byArray2[5] == 65) {
                            if (this.structureInfo == null) {
                                this.structureInfo = new StructureInfo();
                            }
                            String string = this.structureInfo.getDeterminationMethod();
                            vector = new String(byArray2, 10, 60).trim();
                            if (string == null) {
                                this.structureInfo.setDeterminationMethod((String)((Object)vector));
                            } else {
                                this.structureInfo.setDeterminationMethod(string + " : " + (String)((Object)vector));
                            }
                            n3 = 0;
                            continue;
                        }
                        if (byArray2[0] == 77 && byArray2[1] == 79 && byArray2[2] == 68 && byArray2[3] == 69 && byArray2[4] == 76) {
                            int n9 = Integer.parseInt(new String(byArray2, 10, 4).trim());
                            if (++n8 >= 2) break;
                            n3 = 0;
                            continue;
                        }
                        n3 = 0;
                        continue;
                    }
                    if (++n3 < byArray2.length) continue;
                    Status.output(1, "PdbStructureLoader.load( stream ): buffer overflow!");
                    return null;
                }
                if (n8 < 2) continue;
                break;
            }
        }
        catch (IOException iOException) {
            Status.output(1, "PdbStructureLoader.load( stream ): " + iOException);
            return null;
        }
        Structure structure = new Structure(){
            protected Hashtable structureComponents = null;
            private String localUrlString;
            {
                this.structureComponents = PdbStructureLoader.this.passComponents;
                PdbStructureLoader.this.passComponents = null;
                this.localUrlString = PdbStructureLoader.this.urlString;
                PdbStructureLoader.this.urlString = null;
                if (PdbStructureLoader.this.structureInfo != null) {
                    this.setStructureInfo(PdbStructureLoader.this.structureInfo);
                }
            }

            public String getUrlString() {
                return this.localUrlString;
            }

            public int getStructureComponentCount(String string) {
                Vector vector = (Vector)this.structureComponents.get(string);
                if (vector == null) {
                    return 0;
                }
                return vector.size();
            }

            private void getStructureComponentByIndex(int n, StructureComponent structureComponent) throws IndexOutOfBoundsException, IllegalArgumentException {
                String string = structureComponent.getStructureComponentType();
                if (string == null) {
                    throw new IllegalArgumentException("unknown type " + string);
                }
                Vector vector = (Vector)this.structureComponents.get(string);
                if (vector == null) {
                    throw new IllegalArgumentException("no records of type " + string);
                }
                StructureComponent structureComponent2 = (StructureComponent)vector.elementAt(n);
                structureComponent2.structure = this;
                structureComponent.structure = this;
                structureComponent.copy(structureComponent2);
            }

            public StructureComponent getStructureComponentByIndex(String string, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
                Vector vector = (Vector)this.structureComponents.get(string);
                if (vector == null) {
                    throw new IllegalArgumentException("no records of type " + string);
                }
                StructureComponent structureComponent = (StructureComponent)vector.elementAt(n);
                structureComponent.structure = this;
                return structureComponent;
            }
        };
        sharedObjects.clear();
        sharedObjects = null;
        Status.progress(1.0f, null);
        return structure;
    }
}

