/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.io;

import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.io.BatchStructureLoader;
import edu.sdsc.mbt.io.CifStructureLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class RcsbStructureLoader
implements BatchStructureLoader {
    private Vector idCodes = null;
    private CifStructureLoader cifStructureLoader = null;
    private String rcsbSitePrefix = "ftp://beta.rcsb.org/pub/pdb/uniformity/data/mmCIF.gz/all/";
    private String rcsbSitePostfix = ".cif.gz";

    public Vector getStructureNames() {
        if (this.idCodes == null) {
            URL uRL = null;
            try {
                uRL = new URL(this.rcsbSitePrefix);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                return null;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.idCodes = new Vector();
            String string = null;
            while (true) {
                try {
                    string = bufferedReader.readLine();
                    if (string == null) {
                    }
                }
                catch (IOException iOException) {}
                break;
                if (!string.endsWith(".gz")) continue;
                int n = string.lastIndexOf(32);
                string = string.substring(n + 1);
                int n2 = string.indexOf(46);
                string = string.substring(0, n2);
                this.idCodes.add(string);
            }
        }
        return this.idCodes;
    }

    public String getLoaderName() {
        return "RCSB Structure Loader";
    }

    public Structure load(String string) {
        if (string == null) {
            throw new NullPointerException("null PDB ID");
        }
        if (!this.canLoad(string)) {
            throw new IllegalArgumentException("unknown PDB ID");
        }
        if (this.cifStructureLoader == null) {
            try {
                this.cifStructureLoader = new CifStructureLoader();
            }
            catch (Exception exception) {
                throw new NullPointerException("null CifStructureLoader");
            }
        }
        String string2 = this.rcsbSitePrefix + string + this.rcsbSitePostfix;
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("bad PDB ID");
        }
        return this.cifStructureLoader.load(uRL);
    }

    public boolean canLoad(String string) {
        if (string == null) {
            return false;
        }
        Vector vector = this.getStructureNames();
        if (vector == null) {
            return false;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.elementAt(i);
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }
}

