/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.io;

import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.io.BatchStructureLoader;
import edu.sdsc.mbt.io.CifStructureLoader;
import edu.sdsc.mbt.io.FastaStructureLoader;
import edu.sdsc.mbt.io.FileStructureLoader;
import edu.sdsc.mbt.io.PdbStructureLoader;
import edu.sdsc.mbt.io.RcsbStructureLoader;
import edu.sdsc.mbt.io.StructureLoader;
import edu.sdsc.mbt.util.Status;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StructureFactory {
    private static Hashtable fileStructureLoaders = new Hashtable();
    private static Hashtable batchStructureLoaders = new Hashtable();
    private static BatchStructureLoader defaultBatchStructureLoader;
    private static boolean doVerify;

    private static String[] getHashNames(Hashtable hashtable) {
        int n = hashtable.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = hashtable.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public static String[] getFileStructureLoaderNames() {
        return StructureFactory.getHashNames(fileStructureLoaders);
    }

    public static String[] getBatchStructureLoaderNames() {
        return StructureFactory.getHashNames(batchStructureLoaders);
    }

    public static FileStructureLoader getFileStructureLoader(String string) {
        return (FileStructureLoader)fileStructureLoaders.get(string);
    }

    public static BatchStructureLoader getBatchStructureLoader(String string) {
        return (BatchStructureLoader)batchStructureLoaders.get(string);
    }

    public static void addStructureLoader(StructureLoader structureLoader) {
        String string = structureLoader.getLoaderName();
        if (structureLoader instanceof FileStructureLoader) {
            fileStructureLoaders.put(string, structureLoader);
        }
        if (structureLoader instanceof BatchStructureLoader) {
            batchStructureLoaders.put(string, structureLoader);
            if (defaultBatchStructureLoader == null) {
                defaultBatchStructureLoader = (BatchStructureLoader)structureLoader;
            }
        }
    }

    public static void removeStructureLoader(String string) {
        fileStructureLoaders.remove(string);
        batchStructureLoaders.remove(string);
    }

    public static Vector getBatchStructureNames() {
        if (defaultBatchStructureLoader == null) {
            return null;
        }
        return defaultBatchStructureLoader.getStructureNames();
    }

    public static void setDefaultBatchStructureLoader(BatchStructureLoader batchStructureLoader) {
        defaultBatchStructureLoader = batchStructureLoader;
    }

    public static Structure load(File file) {
        Structure structure = null;
        Status.output(3, "Loading file...");
        Enumeration enumeration = fileStructureLoaders.elements();
        while (enumeration.hasMoreElements()) {
            FileStructureLoader fileStructureLoader = (FileStructureLoader)enumeration.nextElement();
            if (!fileStructureLoader.canLoad(file)) continue;
            try {
                structure = fileStructureLoader.load(file);
                if (structure == null) break;
                if (doVerify && !StructureFactory.verify(structure)) {
                    structure = null;
                    Status.output(1, "StructureFactory.load, verify failed.");
                }
            }
            catch (Exception exception) {
                structure = null;
                Status.output(1, "StructureFactory.load, exception: " + exception);
            }
            catch (Error error) {
                structure = null;
                Status.output(3, "StructureFactory.load, error: " + error);
            }
            if (structure == null) continue;
        }
        if (structure == null) {
            Status.output(1, "StructureFactory.load failed!");
        } else {
            Status.output(3, "Done loading file.");
        }
        return structure;
    }

    public static Structure load(URL uRL) {
        Structure structure = null;
        Status.output(3, "Loading URL...");
        Enumeration enumeration = fileStructureLoaders.elements();
        while (enumeration.hasMoreElements()) {
            FileStructureLoader fileStructureLoader = (FileStructureLoader)enumeration.nextElement();
            if (!fileStructureLoader.canLoad(uRL)) continue;
            try {
                structure = fileStructureLoader.load(uRL);
                if (structure == null) break;
                if (doVerify && !StructureFactory.verify(structure)) {
                    structure = null;
                    Status.output(1, "StructureFactory.load, verify failed.");
                }
            }
            catch (Exception exception) {
                structure = null;
                Status.output(1, "StructureFactory.load, exception: " + exception);
            }
            catch (Error error) {
                structure = null;
                Status.output(1, "StructureFactory.load, error: " + error);
            }
            if (structure == null) continue;
        }
        if (structure == null) {
            Status.output(1, "StructureFactory.load failed!");
        } else {
            Status.output(3, "Done loading URL.");
        }
        return structure;
    }

    public static Structure load(String string) {
        Object object;
        Structure structure = null;
        Status.output(3, "Loading " + string + "...");
        Enumeration enumeration = fileStructureLoaders.elements();
        while (enumeration.hasMoreElements()) {
            object = (FileStructureLoader)enumeration.nextElement();
            if (!object.canLoad(string)) continue;
            try {
                structure = object.load(string);
                if (structure == null) break;
                if (doVerify && !StructureFactory.verify(structure)) {
                    structure = null;
                    Status.output(1, "StructureFactory.load, verify failed.");
                }
            }
            catch (Exception exception) {
                structure = null;
                Status.output(1, "StructureFactory.load, exception: " + exception);
            }
            catch (Error error) {
                structure = null;
                Status.output(3, "StructureFactory.load, error: " + error);
            }
            if (structure == null) continue;
        }
        if (structure != null) {
            Status.output(3, "Done loading URL.");
            return structure;
        }
        object = batchStructureLoaders.elements();
        while (object.hasMoreElements()) {
            BatchStructureLoader batchStructureLoader = (BatchStructureLoader)object.nextElement();
            if (!batchStructureLoader.canLoad(string)) continue;
            try {
                structure = batchStructureLoader.load(string);
                if (structure == null) break;
                if (doVerify && !StructureFactory.verify(structure)) {
                    structure = null;
                    Status.output(1, "StructureFactory.load, verify failed.");
                }
            }
            catch (Exception exception) {
                structure = null;
                Status.output(1, "StructureFactory.load, exception: " + exception);
            }
            catch (Error error) {
                structure = null;
                Status.output(3, "StructureFactory.load, error: " + error);
            }
            if (structure == null) continue;
        }
        if (structure == null) {
            Status.output(1, "StructureFactory.load failed!");
        } else {
            Status.output(3, "Done loading " + string);
        }
        return structure;
    }

    public static void setVerify(boolean bl) {
        doVerify = bl;
    }

    public static boolean getVerify() {
        return doVerify;
    }

    public static boolean verify(Structure structure) {
        if (structure == null) {
            return false;
        }
        Enumeration enumeration = StructureComponentRegistry.getTypeNames();
        try {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n = structure.getStructureComponentCount(string);
                StructureComponent structureComponent = null;
                for (int i = 0; i < n; ++i) {
                    structureComponent = structure.getStructureComponentByIndex(string, i);
                    if (structureComponent != null) continue;
                    String string2 = "Null " + string + " at index " + i;
                    Status.output(1, string2);
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            Status.output(1, exception.toString());
            return false;
        }
    }

    static {
        doVerify = true;
        StructureFactory.addStructureLoader(new FastaStructureLoader());
        try {
            CifStructureLoader cifStructureLoader = new CifStructureLoader();
            StructureFactory.addStructureLoader(cifStructureLoader);
        }
        catch (Exception exception) {
            Status.output(1, exception.getMessage());
        }
        StructureFactory.addStructureLoader(new PdbStructureLoader());
        StructureFactory.addStructureLoader(new RcsbStructureLoader());
    }
}

