/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.io;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Conformation;
import edu.sdsc.mbt.Helix;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.io.BatchStructureLoader;
import edu.sdsc.mbt.io.FileStructureLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import java.util.Vector;

public class TestStructureLoader
implements FileStructureLoader,
BatchStructureLoader {
    public String getLoaderName() {
        return new String("Test Structure Loader");
    }

    public Structure load(String string) {
        Structure structure = new Structure(){
            private int sc_count = 50;
            private Random random = new Random();

            public String getUrlString() {
                return "file://c:/myFiles/5ebx.pdb";
            }

            public int getStructureComponentCount(String string) {
                if (StructureComponentRegistry.getTypeName(string) != null) {
                    return this.sc_count;
                }
                return 0;
            }

            public void getStructureComponentByIndex(int n, StructureComponent structureComponent) {
                if (n < 0) {
                    return;
                }
                if (n >= this.sc_count) {
                    return;
                }
                float f = this.random.nextFloat();
                String string = structureComponent.getStructureComponentType();
                structureComponent.structure = this;
                if (string == StructureComponentRegistry.TYPE_ATOM) {
                    Atom atom = (Atom)structureComponent;
                    atom.number = n;
                    if ((double)f <= 0.1) {
                        atom.element = "C";
                        atom.name = "CA";
                        atom.compound = "VAL";
                        atom.chain_id = "A";
                        atom.residue_id = 10;
                    } else {
                        atom.element = "N";
                        atom.name = "N";
                        atom.compound = "THR";
                        atom.chain_id = "A";
                        atom.residue_id = 10;
                    }
                    atom.coordinate[0] = (double)(f * (float)n) * 1.0;
                    atom.coordinate[1] = (double)(f * (float)n) * 2.0;
                    atom.coordinate[2] = (double)(f * (float)n) * 3.0;
                    atom.occupancy = f * (float)n * 0.3f;
                    atom.bfactor = f * (float)n * 20.0f;
                } else if (string == StructureComponentRegistry.TYPE_COIL || string == StructureComponentRegistry.TYPE_HELIX || string == StructureComponentRegistry.TYPE_STRAND || string == StructureComponentRegistry.TYPE_TURN) {
                    Conformation conformation = (Conformation)structureComponent;
                    conformation.name = string + n;
                    conformation.start_compound = "VAL";
                    conformation.start_chain = "A";
                    conformation.start_residue = n;
                    conformation.end_compound = "VAL";
                    conformation.end_chain = "A";
                    conformation.end_residue = n + 20;
                    if (string == StructureComponentRegistry.TYPE_HELIX) {
                        Helix helix = (Helix)conformation;
                        helix.righthand = false;
                    }
                } else if (string == StructureComponentRegistry.TYPE_RESIDUE) {
                    Residue residue = (Residue)structureComponent;
                    residue.setCompoundCode("ARG");
                } else {
                    throw new IllegalArgumentException("unsupported type");
                }
            }

            public StructureComponent getStructureComponentByIndex(String string, int n) {
                StructureComponent structureComponent = null;
                try {
                    structureComponent = (StructureComponent)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    return null;
                }
                this.getStructureComponentByIndex(n, structureComponent);
                return structureComponent;
            }
        };
        return structure;
    }

    public boolean canLoad(String string) {
        return true;
    }

    public Vector getStructureNames() {
        return null;
    }

    public Structure load(File file) {
        try {
            String string = file.getCanonicalPath();
            return this.load(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean canLoad(File file) {
        return true;
    }

    public Structure load(URL uRL) {
        return null;
    }

    public boolean canLoad(URL uRL) {
        return true;
    }
}

