/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

public class Algebra {
    public static double distance(double[] dArray, double[] dArray2) {
        return Math.sqrt((dArray2[0] - dArray[0]) * (dArray2[0] - dArray[0]) + (dArray2[1] - dArray[1]) * (dArray2[1] - dArray[1]) + (dArray2[2] - dArray[2]) * (dArray2[2] - dArray[2]));
    }

    public static double angle(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = (dArray[0] - dArray2[0]) * (dArray3[0] - dArray2[0]) + (dArray[1] - dArray2[1]) * (dArray3[1] - dArray2[1]) + (dArray[2] - dArray2[2]) * (dArray3[2] - dArray2[2]);
        double d2 = Math.sqrt((dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]) + (dArray[1] - dArray2[1]) * (dArray[1] - dArray2[1]) + (dArray[2] - dArray2[2]) * (dArray[2] - dArray2[2]));
        double d3 = Math.sqrt((dArray3[0] - dArray2[0]) * (dArray3[0] - dArray2[0]) + (dArray3[1] - dArray2[1]) * (dArray3[1] - dArray2[1]) + (dArray3[2] - dArray2[2]) * (dArray3[2] - dArray2[2]));
        double d4 = d / (d2 * d3);
        double d5 = Math.acos(d4);
        double d6 = Math.toDegrees(d5);
        return d6;
    }

    public static double dihedralAngle(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d = (dArray3[1] - dArray2[1]) * (dArray[2] - dArray2[2]) - (dArray[1] - dArray2[1]) * (dArray3[2] - dArray2[2]);
        double d2 = (dArray[0] - dArray2[0]) * (dArray3[2] - dArray2[2]) - (dArray3[0] - dArray2[0]) * (dArray[2] - dArray2[2]);
        double d3 = (dArray3[0] - dArray2[0]) * (dArray[1] - dArray2[1]) - (dArray[0] - dArray2[0]) * (dArray3[1] - dArray2[1]);
        double d4 = (dArray3[1] - dArray2[1]) * (dArray4[2] - dArray2[2]) - (dArray4[1] - dArray2[1]) * (dArray3[2] - dArray2[2]);
        double d5 = (dArray4[0] - dArray2[0]) * (dArray3[2] - dArray2[2]) - (dArray3[0] - dArray2[0]) * (dArray4[2] - dArray2[2]);
        double d6 = (dArray3[0] - dArray2[0]) * (dArray4[1] - dArray2[1]) - (dArray4[0] - dArray2[0]) * (dArray3[1] - dArray2[1]);
        double d7 = d * d4 + d2 * d5 + d3 * d6;
        double d8 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d9 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        double d10 = d7 / (d8 * d9);
        double d11 = Math.acos(d10);
        double d12 = Math.toDegrees(d11);
        return d12;
    }

    public static void crossProduct(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("v1.length != 3");
        }
        if (dArray2.length != 3) {
            throw new IllegalArgumentException("v2.length != 3");
        }
        if (dArray3.length != 3) {
            throw new IllegalArgumentException("result.length != 3");
        }
        if (dArray == dArray2) {
            throw new IllegalArgumentException("v1 == v2");
        }
        if (dArray3 == dArray) {
            throw new IllegalArgumentException("result == v1");
        }
        if (dArray3 == dArray2) {
            throw new IllegalArgumentException("result == v2");
        }
        dArray3[0] = dArray[1] * dArray2[2] - dArray2[1] * dArray[2];
        dArray3[1] = -(dArray[0] * dArray2[2] - dArray2[0] * dArray[2]);
        dArray3[2] = dArray[0] * dArray2[1] - dArray2[0] * dArray[1];
    }

    public static double dotProduct(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("v1.length != v2.length");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static void normalizeVector(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            throw new NullPointerException("null inVector");
        }
        if (dArray2 == null) {
            throw new NullPointerException("null outVector");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("vector length mismatch");
        }
        double d = Algebra.vectorLength(dArray);
        if (d == 0.0) {
            d = 1.0;
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] / d;
        }
    }

    public static void normalizeVector(double[] dArray) {
        Algebra.normalizeVector(dArray, dArray);
    }

    public static double vectorLength(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException("null vector");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return Math.sqrt(d);
    }

    public static void angleAxisRotate(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            throw new NullPointerException("null angleAxis");
        }
        if (dArray.length < 4) {
            throw new IllegalArgumentException("angleAxis.length < 4");
        }
        if (dArray2 == null) {
            throw new NullPointerException("null point");
        }
        if (dArray2.length < 3) {
            throw new IllegalArgumentException("point.length < 3");
        }
        double[] dArray3 = new double[16];
        Algebra.rotationToMatrix(dArray, dArray3);
        Algebra.matrixRotate(dArray3, dArray2);
    }

    public static void matrixRotate(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            throw new NullPointerException("null matrix");
        }
        if (dArray.length < 16) {
            throw new IllegalArgumentException("matrix.length < 16");
        }
        if (dArray2 == null) {
            throw new NullPointerException("null point");
        }
        if (dArray2.length < 3) {
            throw new IllegalArgumentException("point.length < 3");
        }
        double[] dArray3 = dArray;
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        double d4 = 1.0;
        dArray2[0] = dArray3[0] * d + dArray3[1] * d2 + dArray3[2] * d3 + dArray3[3] * d4;
        dArray2[1] = dArray3[4] * d + dArray3[5] * d2 + dArray3[6] * d3 + dArray3[7] * d4;
        dArray2[2] = dArray3[8] * d + dArray3[9] * d2 + dArray3[10] * d3 + dArray3[11] * d4;
    }

    public static void rotationToMatrix(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            throw new NullPointerException("null rotation");
        }
        if (dArray.length < 4) {
            throw new IllegalArgumentException("rotation.length < 4");
        }
        if (dArray2 == null) {
            throw new NullPointerException("null matrix");
        }
        if (dArray2.length < 16) {
            throw new IllegalArgumentException("matrix.length < 16");
        }
        double d = Math.sqrt(dArray[1] * dArray[1] + dArray[2] * dArray[2] + dArray[3] * dArray[3]);
        double d2 = 1.0 / d;
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        double d3 = dArray[0];
        double d4 = dArray[1] * d2;
        double d5 = dArray[2] * d2;
        double d6 = dArray[3] * d2;
        double d7 = Math.cos(d3);
        double d8 = Math.sin(d3);
        double d9 = 1.0 - d7;
        dArray2[0] = d9 * d4 * d4 + d7;
        dArray2[1] = d9 * d4 * d5 - d8 * d6;
        dArray2[2] = d9 * d4 * d6 + d8 * d5;
        dArray2[3] = 0.0;
        dArray2[4] = d9 * d4 * d5 + d8 * d6;
        dArray2[5] = d9 * d5 * d5 + d7;
        dArray2[6] = d9 * d5 * d6 - d8 * d4;
        dArray2[7] = 0.0;
        dArray2[8] = d9 * d4 * d6 - d8 * d5;
        dArray2[9] = d9 * d5 * d6 + d8 * d4;
        dArray2[10] = d9 * d6 * d6 + d7;
        dArray2[11] = 0.0;
        dArray2[12] = 0.0;
        dArray2[13] = 0.0;
        dArray2[14] = 0.0;
        dArray2[15] = 1.0;
    }
}

